/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.ssl;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.net.ssl.SSLEngine;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.glassfish.grizzly.utils.StringFilter;

public class SSLEchoClient {
    private static final String MESSAGE = "Hello World!";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        SSLEngineConfigurator serverConfig = SSLEchoClient.initializeSSL();
        SSLEngineConfigurator clientConfig = serverConfig.copy().setClientMode(true);
        SSLFilter sslFilter = new SSLFilter(serverConfig, clientConfig);
        filterChainBuilder.add((Filter)sslFilter);
        filterChainBuilder.add((Filter)new StringFilter(Charset.forName("UTF-8")));
        filterChainBuilder.add((Filter)new SendMessageFilter(sslFilter));
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)filterChainBuilder.build());
        try {
            transport.start();
            transport.connect("localhost", 7777);
            System.out.println("Press any key to stop the client...");
            System.in.read();
        }
        finally {
            System.out.println("Stopping transport...");
            transport.shutdownNow();
            System.out.println("Stopped transport...");
        }
    }

    private static SSLEngineConfigurator initializeSSL() {
        URL keystoreUrl;
        SSLContextConfigurator sslContextConfig = new SSLContextConfigurator();
        ClassLoader cl = SSLEchoClient.class.getClassLoader();
        URL cacertsUrl = cl.getResource("ssltest-cacerts.jks");
        if (cacertsUrl != null) {
            sslContextConfig.setTrustStoreFile(cacertsUrl.getFile());
            sslContextConfig.setTrustStorePass("changeit");
        }
        if ((keystoreUrl = cl.getResource("ssltest-keystore.jks")) != null) {
            sslContextConfig.setKeyStoreFile(keystoreUrl.getFile());
            sslContextConfig.setKeyStorePass("changeit");
        }
        return new SSLEngineConfigurator(sslContextConfig.createSSLContext(), false, false, false);
    }

    private static class SendMessageFilter
    extends BaseFilter {
        private final SSLFilter sslFilter;

        public SendMessageFilter(SSLFilter sslFilter) {
            this.sslFilter = sslFilter;
        }

        public NextAction handleConnect(FilterChainContext ctx) throws IOException {
            final Connection connection = ctx.getConnection();
            this.sslFilter.handshake(connection, (CompletionHandler)new EmptyCompletionHandler<SSLEngine>(){

                public void completed(SSLEngine result) {
                    connection.write((Object)SSLEchoClient.MESSAGE);
                }
            });
            return ctx.getInvokeAction();
        }

        public NextAction handleRead(FilterChainContext ctx) throws IOException {
            String message = (String)ctx.getMessage();
            if (SSLEchoClient.MESSAGE.equals(message)) {
                System.out.println("Got echo message: \"" + message + "\"");
            } else {
                System.out.println("Got unexpected echo message: \"" + message + "\"");
            }
            return ctx.getStopAction();
        }
    }
}

