/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.tunnel;

import java.io.IOException;
import java.util.logging.Logger;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.SocketConnectorHandler;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOConnectorHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.samples.tunnel.TunnelFilter;

public class TunnelServer {
    private static final Logger logger = Logger.getLogger(TunnelServer.class.getName());
    public static final String HOST = "localhost";
    public static final int PORT = 7777;
    public static final String REDIRECT_HOST = "localhost";
    public static final int REDIRECT_PORT = 5001;

    public static void main(String[] args) throws IOException {
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        filterChainBuilder.add((Filter)new TunnelFilter((SocketConnectorHandler)TCPNIOConnectorHandler.builder((TCPNIOTransport)transport).build(), "localhost", 5001));
        transport.setProcessor((Processor)filterChainBuilder.build());
        transport.getAsyncQueueIO().getWriter().setMaxPendingBytesPerConnection(262144);
        try {
            transport.bind("localhost", 7777);
            transport.start();
            logger.info("Press any key to stop the server...");
            System.in.read();
        }
        finally {
            logger.info("Stopping transport...");
            transport.shutdownNow();
            logger.info("Stopped transport...");
        }
    }
}

