/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.simpleauth;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentMap;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.samples.simpleauth.MultiLinePacket;
import org.glassfish.grizzly.utils.DataStructures;

public class ClientAuthFilter
extends BaseFilter {
    private static final MultiLinePacket authPacket = MultiLinePacket.create("authentication-request");
    private final ConcurrentMap<Connection, ConnectionAuthInfo> authenticatedConnections = DataStructures.getConcurrentMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        MultiLinePacket packet = (MultiLinePacket)ctx.getMessage();
        String command = packet.getLines().get(0);
        if (command.startsWith("authentication-response")) {
            String id = this.getId(packet.getLines().get(1));
            Connection connection2 = connection;
            synchronized (connection2) {
                ConnectionAuthInfo info = (ConnectionAuthInfo)this.authenticatedConnections.get(connection);
                info.id = id;
                for (FilterChainContext pendedContext : info.pendingMessages) {
                    pendedContext.resume();
                }
                info.pendingMessages = null;
            }
            return ctx.getStopAction();
        }
        String idLine = packet.getLines().get(1);
        if (this.checkAuth(connection, idLine)) {
            packet.getLines().remove(1);
            return ctx.getInvokeAction();
        }
        throw new IllegalStateException("Client is not authenticated!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        MultiLinePacket packet = (MultiLinePacket)ctx.getMessage();
        ConnectionAuthInfo authInfo = (ConnectionAuthInfo)this.authenticatedConnections.get(connection);
        if (authInfo == null) {
            authInfo = new ConnectionAuthInfo();
            ConnectionAuthInfo existingInfo = this.authenticatedConnections.putIfAbsent(connection, authInfo);
            if (existingInfo == null) {
                ctx.write((Object)authPacket);
            } else {
                authInfo = existingInfo;
            }
        }
        if (authInfo.pendingMessages != null) {
            Connection connection2 = connection;
            synchronized (connection2) {
                if (authInfo.pendingMessages != null && authInfo.id == null) {
                    ctx.suspend();
                    authInfo.pendingMessages.add(ctx);
                    return ctx.getSuspendAction();
                }
            }
        }
        System.out.println("packet: " + packet);
        packet.getLines().add(1, "auth-id: " + authInfo.id);
        return ctx.getInvokeAction();
    }

    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        this.authenticatedConnections.remove(ctx.getConnection());
        return ctx.getInvokeAction();
    }

    private boolean checkAuth(Connection connection, String idLine) {
        ConnectionAuthInfo registeredId = (ConnectionAuthInfo)this.authenticatedConnections.get(connection);
        if (registeredId == null || registeredId.id == null) {
            return false;
        }
        if (idLine.startsWith("auth-id:")) {
            String id = this.getId(idLine);
            return registeredId.id.equals(id);
        }
        return false;
    }

    private String getId(String idLine) {
        return idLine.split(":")[1].trim();
    }

    public static class ConnectionAuthInfo {
        public volatile String id;
        public volatile Queue<FilterChainContext> pendingMessages = new LinkedList<FilterChainContext>();
    }
}

