/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.connectionpool;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ConnectorHandler;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.connectionpool.Endpoint;
import org.glassfish.grizzly.connectionpool.EndpointKey;
import org.glassfish.grizzly.connectionpool.MultiEndpointPool;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOConnectorHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.samples.connectionpool.ClientCallback;
import org.glassfish.grizzly.samples.connectionpool.ClientFilter;
import org.glassfish.grizzly.samples.connectionpool.EchoServer;
import org.glassfish.grizzly.utils.Charsets;
import org.glassfish.grizzly.utils.StringFilter;

public class MultiEndpointPoolSample
implements ClientCallback {
    private static final Logger LOGGER = Grizzly.logger(MultiEndpointPoolSample.class);
    private static final Random RANDOM = new Random();
    private EchoServer server1;
    private EchoServer server2;
    private Transport clientTransport;
    private ConnectorHandler<SocketAddress> connectorHandler;
    private MultiEndpointPool<SocketAddress> connectionPool;
    private final AtomicInteger clientConnectionsCounter = new AtomicInteger();
    private final Set<String> messageTracker = Collections.newSetFromMap(new ConcurrentHashMap());
    private CountDownLatch responsesCountDownLatch;

    public static void main(String[] args) throws Exception {
        new MultiEndpointPoolSample().exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exec() throws Exception {
        try {
            this.startServers();
            this.initializeClientTransport();
            EndpointKey server1EndpointKey = new EndpointKey((Object)"server1", (Object)this.server1.getEndpointAddress());
            EndpointKey server2EndpointKey = new EndpointKey((Object)"server2", (Object)this.server2.getEndpointAddress());
            this.connectionPool = MultiEndpointPool.builder(SocketAddress.class).connectorHandler(this.connectorHandler).maxConnectionsPerEndpoint(2).maxConnectionsTotal(4).build();
            ExecutorService testingThreadPool = Executors.newFixedThreadPool(256);
            try {
                int requestsCount = 100000;
                this.responsesCountDownLatch = new CountDownLatch(100000);
                LOGGER.log(Level.INFO, "Making {0} requests...", 100000);
                long startTime = System.currentTimeMillis();
                for (int i = 0; i < 100000; ++i) {
                    final EndpointKey serverEndpoint = RANDOM.nextBoolean() ? server1EndpointKey : server2EndpointKey;
                    final String testMessage = "Message #" + (i + 1);
                    this.messageTracker.add(testMessage);
                    testingThreadPool.execute(new Runnable(){

                        @Override
                        public void run() {
                            MultiEndpointPoolSample.this.connectionPool.take((Endpoint)serverEndpoint, (CompletionHandler)new EmptyCompletionHandler<Connection>(){

                                public void failed(Throwable throwable) {
                                    LOGGER.log(Level.WARNING, "Can't allocate a Connection", throwable);
                                }

                                public void completed(Connection connection) {
                                    connection.write((Object)testMessage);
                                }
                            });
                        }
                    });
                }
                this.responsesCountDownLatch.await(30L, TimeUnit.SECONDS);
                long runTime = (System.currentTimeMillis() - startTime) / 1000L;
                LOGGER.log(Level.INFO, "Completed in {0} seconds\nRequests sent: {1}\nResponses missed: {2}\nConnections created: {3}", new Object[]{runTime, 100000, this.responsesCountDownLatch.getCount(), this.clientConnectionsCounter.get()});
            }
            finally {
                testingThreadPool.shutdownNow();
                this.connectionPool.close();
            }
        }
        finally {
            this.stopClientTransport();
            this.stopServers();
        }
    }

    @Override
    public void onConnectionEstablished(Connection connection) {
        this.clientConnectionsCounter.incrementAndGet();
    }

    @Override
    public void onResponseReceived(Connection connection, String responseMessage) {
        if (this.messageTracker.remove(responseMessage)) {
            this.responsesCountDownLatch.countDown();
        } else {
            LOGGER.log(Level.WARNING, "Received unexpected response: {0}", responseMessage);
        }
        this.connectionPool.release(connection);
    }

    private void initializeClientTransport() throws IOException {
        TCPNIOTransport tcpTransport = TCPNIOTransportBuilder.newInstance().build();
        tcpTransport.start();
        this.clientTransport = tcpTransport;
        FilterChain clientFilterChain = FilterChainBuilder.stateless().add((Filter)new TransportFilter()).add((Filter)new StringFilter(Charsets.UTF8_CHARSET)).add((Filter)new ClientFilter(this)).build();
        this.connectorHandler = ((TCPNIOConnectorHandler.Builder)TCPNIOConnectorHandler.builder((TCPNIOTransport)tcpTransport).processor((Processor)clientFilterChain)).build();
    }

    private void stopClientTransport() throws IOException {
        if (this.clientTransport != null) {
            Transport localTransport = this.clientTransport;
            this.clientTransport = null;
            try {
                localTransport.shutdownNow();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void startServers() throws IOException {
        this.server1 = new EchoServer(new InetSocketAddress("0.0.0.0", 18080));
        this.server2 = new EchoServer(new InetSocketAddress("0.0.0.0", 18081));
        this.server1.start();
        this.server2.start();
    }

    private void stopServers() {
        if (this.server1 != null) {
            try {
                this.server1.stop();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.server1 = null;
        }
        if (this.server2 != null) {
            try {
                this.server2.stop();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.server2 = null;
        }
    }
}

