/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.dmt;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;

public final class Uri {
    public static final String ROOT_NODE = ".";
    public static final char ROOT_NODE_CHAR = '.';
    public static final String PATH_SEPARATOR = "/";
    public static final char PATH_SEPARATOR_CHAR = '/';
    private static final char[] BASE_64_TABLE = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '_'};

    private Uri() {
    }

    public static String mangle(String nodeName) {
        return nodeName;
    }

    public static String toUri(String[] path) {
        if (0 == path.length) {
            return "";
        }
        StringBuffer uri = new StringBuffer();
        for (int i = 0; i < path.length; ++i) {
            if (i > 0) {
                uri.append('/');
            }
            if (path[i] == null) {
                throw new NullPointerException("One of its segments is null.");
            }
            uri.append(path[i]);
        }
        return uri.toString();
    }

    private static int getSegmentLength(String segment) {
        if (segment.length() == 0) {
            throw new IllegalArgumentException("URI segment is empty.");
        }
        StringBuffer newsegment = new StringBuffer(segment);
        for (int i = 0; i < newsegment.length(); ++i) {
            if (newsegment.charAt(i) == '\\') {
                if (i == newsegment.length() - 1) {
                    throw new IllegalArgumentException("URI segment ends with the escape character.");
                }
                newsegment.deleteCharAt(i);
                continue;
            }
            if (newsegment.charAt(i) != '/') continue;
            throw new IllegalArgumentException("URI segment contains an unescaped '/' character.");
        }
        if (newsegment.toString().equals("..")) {
            throw new IllegalArgumentException("URI segment must not be \"..\".");
        }
        try {
            return newsegment.toString().getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public static String[] toPath(String uri) {
        if (uri == null) {
            throw new NullPointerException("'uri' parameter is null.");
        }
        if (!Uri.isValidUri(uri)) {
            throw new IllegalArgumentException("Malformed URI: " + uri);
        }
        if (uri.length() == 0) {
            return new String[0];
        }
        ArrayList<String> segments = new ArrayList<String>();
        StringBuffer segment = new StringBuffer();
        boolean escape = false;
        for (int i = 0; i < uri.length(); ++i) {
            char ch = uri.charAt(i);
            if (escape) {
                if (ch == '/' || ch == '\\') {
                    segment.append('\\');
                }
                segment.append(ch);
                escape = false;
                continue;
            }
            if (ch == '/') {
                segments.add(segment.toString());
                segment = new StringBuffer();
                continue;
            }
            if (ch == '\\') {
                escape = true;
                continue;
            }
            segment.append(ch);
        }
        if (segment.length() > 0) {
            segments.add(segment.toString());
        }
        return segments.toArray(new String[segments.size()]);
    }

    public static boolean isAbsoluteUri(String uri) {
        if (null == uri) {
            throw new NullPointerException("'uri' parameter is null.");
        }
        if (!Uri.isValidUri(uri)) {
            throw new IllegalArgumentException("Malformed URI: " + uri);
        }
        return uri.equals(ROOT_NODE) || uri.equals("\\.") || uri.startsWith("./") || uri.startsWith("\\./");
    }

    public static String encode(String nodeName) {
        for (int i = 0; i < nodeName.length(); ++i) {
            char c = nodeName.charAt(i);
            if (c != '\\' && c != '/') continue;
            StringBuffer sb = new StringBuffer(nodeName);
            while (i < sb.length()) {
                c = sb.charAt(i);
                if (c == '\\' || c == '/') {
                    sb.insert(i++, '\\');
                }
                ++i;
            }
            return sb.toString();
        }
        return nodeName;
    }

    public static String decode(String nodeName) {
        int n = nodeName.indexOf(92);
        if (n < 0) {
            return nodeName;
        }
        StringBuffer sb = new StringBuffer(nodeName);
        while (n >= 0 && n < sb.length()) {
            sb.deleteCharAt(n);
            ++n;
            while (n < sb.length() && sb.charAt(n) != '\\') {
                ++n;
            }
        }
        return sb.toString();
    }

    public static boolean isValidUri(String uri) {
        if (null == uri) {
            return false;
        }
        int paramLen = ((String)uri).length();
        if (paramLen == 0) {
            return true;
        }
        if (((String)uri).charAt(0) == '/' || ((String)uri).charAt(paramLen - 1) == '\\') {
            return false;
        }
        int segmentNumber = 0;
        uri = (String)uri + PATH_SEPARATOR;
        ++paramLen;
        int start = 0;
        for (int i = 1; i < paramLen; ++i) {
            if (((String)uri).charAt(i) != '/' || ((String)uri).charAt(i - 1) == '\\') continue;
            String segment = ((String)uri).substring(start, i);
            if (++segmentNumber > 1 && segment.equals(ROOT_NODE)) {
                return false;
            }
            try {
                Uri.getSegmentLength(segment);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            start = i + 1;
        }
        return true;
    }

    static String mangle(String nodeName, int limit) {
        if (nodeName == null) {
            throw new NullPointerException("The 'nodeName' parameter must not be null.");
        }
        if (nodeName.equals("")) {
            throw new IllegalArgumentException("The 'nodeName' parameter must not be empty.");
        }
        if (nodeName.length() > limit) {
            return Uri.getHash(nodeName);
        }
        StringBuffer nameBuffer = new StringBuffer(nodeName);
        for (int i = 0; i < nameBuffer.length(); ++i) {
            if (nameBuffer.charAt(i) != '\\' && nameBuffer.charAt(i) != '/') continue;
            nameBuffer.insert(i++, '\\');
        }
        return nameBuffer.toString();
    }

    private static String getHash(String from) {
        byte[] bytes;
        try {
            bytes = from.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("there's no UTF-8 encoder here!");
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Can't get an instance of a SHA MessageDigest provider!");
        }
        byte[] digest = md.digest(bytes);
        StringBuffer sb = new StringBuffer(digest.length * 2);
        for (int i = 0; i < 6; ++i) {
            int d0 = digest[i * 3] & 0xFF;
            int d1 = digest[i * 3 + 1] & 0xFF;
            int d2 = digest[i * 3 + 2] & 0xFF;
            sb.append(BASE_64_TABLE[d0 >> 2]);
            sb.append(BASE_64_TABLE[(d0 << 4 | d1 >> 4) & 0x3F]);
            sb.append(BASE_64_TABLE[(d1 << 2 | d2 >> 6) & 0x3F]);
            sb.append(BASE_64_TABLE[d2 & 0x3F]);
        }
        int d0 = digest[18] & 0xFF;
        int d1 = digest[19] & 0xFF;
        sb.append(BASE_64_TABLE[d0 >> 2]);
        sb.append(BASE_64_TABLE[(d0 << 4 | d1 >> 4) & 0x3F]);
        sb.append(BASE_64_TABLE[d1 << 2 & 0x3F]);
        return sb.toString();
    }
}

