/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.dmt;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.osgi.service.dmt.DmtIllegalStateException;

public final class DmtData {
    public static final int FORMAT_INTEGER = 1;
    public static final int FORMAT_FLOAT = 2;
    public static final int FORMAT_STRING = 4;
    public static final int FORMAT_BOOLEAN = 8;
    public static final int FORMAT_DATE = 16;
    public static final int FORMAT_TIME = 32;
    public static final int FORMAT_BINARY = 64;
    public static final int FORMAT_BASE64 = 128;
    public static final int FORMAT_XML = 256;
    public static final int FORMAT_NULL = 512;
    public static final int FORMAT_NODE = 1024;
    public static final int FORMAT_RAW_STRING = 2048;
    public static final int FORMAT_RAW_BINARY = 4096;
    public static final int FORMAT_LONG = 8192;
    public static final int FORMAT_DATE_TIME = 16384;
    private static final Map FORMAT_NAMES = new HashMap();
    public static final DmtData NULL_VALUE;
    public static final DmtData TRUE_VALUE;
    public static final DmtData FALSE_VALUE;
    private final int format;
    private final Object value;
    private String formatName;
    private static char[] hex;

    private DmtData() {
        this(null, 512, null);
    }

    public DmtData(String string) {
        this(string, 4, null);
    }

    public DmtData(Date date) {
        if (date == null) {
            throw new NullPointerException("The date argument is null.");
        }
        this.format = 16384;
        this.value = date;
    }

    public DmtData(Object complex) {
        if (complex == null) {
            throw new NullPointerException("Complex data argument is null.");
        }
        this.format = 1024;
        this.value = complex;
    }

    public DmtData(String value, int format) {
        this(value, format, null);
        if (format == 4 || format == 256 || format == 16 || format == 32) {
            return;
        }
        throw new IllegalArgumentException("Wrong format for DmtData(String,int), format must be one of FORMAT_STRING, FORMAT_XML, FORMAT_DATE, or FORMAT_TIME");
    }

    public DmtData(int integer) {
        this(new Integer(integer), 1, null);
    }

    public DmtData(float flt) {
        this(new Float(flt), 2, null);
    }

    public DmtData(long lng) {
        this(new Long(lng), 8192, null);
    }

    public DmtData(boolean bool) {
        this(bool, 8, null);
    }

    public DmtData(byte[] bytes) {
        this(bytes, 64, null);
    }

    public DmtData(byte[] bytes, boolean base64) {
        this(bytes, base64 ? 128 : 64, null);
    }

    public DmtData(byte[] bytes, int format) {
        this(bytes, format, null);
        if (format == 64 || format == 128) {
            return;
        }
        throw new IllegalArgumentException("Invalid format for DmtDate(byte[],format), only FORMAT_BINARY and FORMAT_BASE64 are allowed");
    }

    public DmtData(String formatName, String data) {
        this(data.toString(), 2048, formatName.toString());
    }

    private DmtData(Object value, int format, String formatName) {
        this.value = value;
        this.format = format;
        this.formatName = formatName;
        this.validate();
    }

    public DmtData(String formatName, byte[] data) {
        this(data, 4096, formatName);
        if (formatName == null) {
            throw new NullPointerException("Format name argument is null.");
        }
    }

    private void validate() {
        Class c;
        switch (this.format) {
            case 1: {
                c = Integer.class;
                break;
            }
            case 2: {
                c = Float.class;
                break;
            }
            case 32: {
                DmtData.checkTimeFormat((String)this.value);
                c = String.class;
                break;
            }
            case 16: {
                DmtData.checkDateFormat((String)this.value);
                c = String.class;
                break;
            }
            case 4: 
            case 256: {
                c = String.class;
                if (this.value != null) break;
                return;
            }
            case 2048: {
                c = String.class;
                break;
            }
            case 8: {
                c = Boolean.class;
                break;
            }
            case 64: 
            case 128: 
            case 4096: {
                if (this.value != null) {
                    c = byte[].class;
                    break;
                }
                throw new NullPointerException("The bytes argument is null.");
            }
            case 512: {
                if (this.value != null) {
                    throw new IllegalArgumentException("Format is null but value is not ");
                }
                return;
            }
            case 1024: {
                c = Object.class;
                break;
            }
            case 8192: {
                c = Long.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid format number for DmtData " + this.format);
            }
        }
        if (!c.isInstance(this.value)) {
            throw new IllegalArgumentException("Invalid type type for DmtData, expected " + c.getClass() + " but have " + this.value.getClass());
        }
    }

    public String getString() {
        if (this.format == 4) {
            return (String)this.value;
        }
        throw new DmtIllegalStateException("DmtData value is not string.");
    }

    public String getDate() {
        if (this.format == 16) {
            return (String)this.value;
        }
        throw new DmtIllegalStateException("DmtData value is not date.");
    }

    public String getTime() {
        if (this.format == 32) {
            return (String)this.value;
        }
        throw new DmtIllegalStateException("DmtData value is not time.");
    }

    public Date getDateTime() {
        if (this.format == 16384) {
            return (Date)this.value;
        }
        throw new DmtIllegalStateException("DmtData value is not dateTime.");
    }

    public String getXml() {
        if (this.format == 256) {
            return (String)this.value;
        }
        throw new DmtIllegalStateException("DmtData value is not XML.");
    }

    public int getInt() {
        if (this.format == 1) {
            return (Integer)this.value;
        }
        throw new DmtIllegalStateException("DmtData value is not integer.");
    }

    public long getLong() {
        if (this.format == 8192) {
            return (Long)this.value;
        }
        throw new DmtIllegalStateException("DmtData value is not long.");
    }

    public float getFloat() {
        if (this.format == 2) {
            return ((Float)this.value).floatValue();
        }
        throw new DmtIllegalStateException("DmtData value is not float.");
    }

    public boolean getBoolean() {
        if (this.format == 8) {
            return (Boolean)this.value;
        }
        throw new DmtIllegalStateException("DmtData value is not boolean.");
    }

    public byte[] getBinary() {
        if (this.format == 64) {
            return this.copyBytes();
        }
        throw new DmtIllegalStateException("DmtData value is not a byte array.");
    }

    private byte[] copyBytes() {
        byte[] bytes = (byte[])this.value;
        byte[] bytesCopy = new byte[bytes.length];
        System.arraycopy(bytes, 0, bytesCopy, 0, bytes.length);
        return bytesCopy;
    }

    public byte[] getRawBinary() {
        if (this.format == 4096) {
            return this.copyBytes();
        }
        throw new DmtIllegalStateException("DmtData value is not in raw binary format.");
    }

    public String getRawString() {
        if (this.format == 2048) {
            return (String)this.value;
        }
        throw new DmtIllegalStateException("DmtData value is not in raw string format.");
    }

    public byte[] getBase64() {
        if (this.format == 128) {
            return this.copyBytes();
        }
        throw new DmtIllegalStateException("DmtData value is not in base 64 format.");
    }

    public Object getNode() {
        if (this.format == 1024) {
            return this.value;
        }
        throw new DmtIllegalStateException("DmtData does not contain interior node data.");
    }

    public int getFormat() {
        return this.format;
    }

    public String getFormatName() {
        if (this.formatName == null) {
            return DmtData.getFormatName(this.format);
        }
        return this.formatName;
    }

    public int getSize() {
        switch (this.format) {
            case 4: 
            case 16: 
            case 32: 
            case 256: 
            case 2048: {
                if (this.value != null) {
                    return ((String)this.value).length();
                }
                return 0;
            }
            case 64: 
            case 128: 
            case 4096: {
                return ((byte[])this.value).length;
            }
            case 1: 
            case 2: {
                return 4;
            }
            case 8: {
                return 1;
            }
            case 1024: {
                return -1;
            }
            case 8192: 
            case 16384: {
                return 8;
            }
            case 512: {
                return 0;
            }
        }
        return 0;
    }

    public String toString() {
        switch (this.format) {
            case 4: 
            case 16: 
            case 32: 
            case 256: 
            case 2048: {
                if (this.value != null) {
                    return (String)this.value;
                }
                return "";
            }
            case 1: 
            case 2: 
            case 8: 
            case 1024: 
            case 8192: {
                return this.value.toString();
            }
            case 64: 
            case 128: 
            case 4096: {
                return DmtData.getHexDump((byte[])this.value);
            }
            case 512: {
                return "null";
            }
            case 16384: {
                SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:SS'Z'");
                sf.setTimeZone(TimeZone.getTimeZone("UTC"));
                return sf.format(this.value);
            }
        }
        throw new IllegalStateException("Invalid format " + this.format);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DmtData)) {
            return false;
        }
        DmtData other = (DmtData)obj;
        if (this.format != other.format) {
            return false;
        }
        if (this.formatName != null && !this.formatName.equals(other.formatName)) {
            return false;
        }
        if (this.value == null) {
            return other.value == null;
        }
        if (this.value.equals(other.value)) {
            return true;
        }
        switch (this.format) {
            case 64: 
            case 128: 
            case 4096: {
                return Arrays.equals((byte[])this.value, (byte[])other.value);
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.value == null) {
            return 42;
        }
        return this.value.hashCode();
    }

    private static void checkDateFormat(String value) {
        if (value.length() != 8) {
            throw new IllegalArgumentException("Date string '" + value + "' does not follow the format 'CCYYMMDD'.");
        }
        int year = DmtData.checkNumber(value, "Date", 0, 4, 0, 9999);
        int month = DmtData.checkNumber(value, "Date", 4, 2, 1, 12);
        int day = DmtData.checkNumber(value, "Date", 6, 2, 1, 31);
        if ((month == 4 || month == 6 || month == 9 || month == 11) && day == 31) {
            throw new IllegalArgumentException("Date string '" + value + "' contains an invalid date.");
        }
        if (month == 2 && day > 28 && (day != 29 || year % 4 != 0 || year % 100 == 0 && year % 400 != 0)) {
            throw new IllegalArgumentException("Date string '" + value + "' contains an invalid date.");
        }
    }

    private static void checkTimeFormat(String value) {
        if (value.length() > 0 && value.charAt(value.length() - 1) == 'Z') {
            value = value.substring(0, value.length() - 1);
        }
        if (value.length() != 6) {
            throw new IllegalArgumentException("Time string '" + value + "' does not follow the format 'hhmmss' or 'hhmmssZ'.");
        }
        DmtData.checkNumber(value, "Time", 0, 2, 0, 24);
        DmtData.checkNumber(value, "Time", 2, 2, 0, 59);
        DmtData.checkNumber(value, "Time", 4, 2, 0, 59);
        if (value.startsWith("24") && !value.startsWith("240000")) {
            throw new IllegalArgumentException("Time string is out of range.");
        }
    }

    private static int checkNumber(String value, String name, int from, int length, int min, int max) {
        int number;
        String part = value.substring(from, from + length);
        try {
            number = Integer.parseInt(part);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(name + " string '" + value + "' contains a non-numeric part.");
        }
        if (number < min || number > max) {
            throw new IllegalArgumentException("A segment of the " + name + " string '" + value + "' is out of range.");
        }
        return number;
    }

    private static String getHexDump(byte[] bytes) {
        if (bytes.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        String del = "";
        for (int i = 0; i < bytes.length; ++i) {
            DmtData.appendHexByte(buf.append(del), bytes[i]);
            del = " ";
        }
        return buf.toString();
    }

    private static void appendHexByte(StringBuffer buf, byte b) {
        buf.append(hex[(b & 0xF0) >> 4]).append(hex[b & 0xF]);
    }

    private static String getFormatName(int format) {
        return (String)FORMAT_NAMES.get(new Integer(format));
    }

    static {
        FORMAT_NAMES.put(new Integer(128), "base64");
        FORMAT_NAMES.put(new Integer(64), "binary");
        FORMAT_NAMES.put(new Integer(8), "boolean");
        FORMAT_NAMES.put(new Integer(16), "date");
        FORMAT_NAMES.put(new Integer(2), "float");
        FORMAT_NAMES.put(new Integer(1), "integer");
        FORMAT_NAMES.put(new Integer(1024), "NODE");
        FORMAT_NAMES.put(new Integer(512), "null");
        FORMAT_NAMES.put(new Integer(4), "string");
        FORMAT_NAMES.put(new Integer(32), "time");
        FORMAT_NAMES.put(new Integer(256), "xml");
        FORMAT_NAMES.put(new Integer(8192), "long");
        FORMAT_NAMES.put(new Integer(16384), "dateTime");
        NULL_VALUE = new DmtData();
        TRUE_VALUE = new DmtData(true);
        FALSE_VALUE = new DmtData(false);
        hex = "0123456789ABCDEF".toCharArray();
    }
}

