/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.osgi.httpservice;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.glassfish.grizzly.osgi.httpservice.OSGiHandler;
import org.glassfish.grizzly.osgi.httpservice.OSGiServletContext;
import org.glassfish.grizzly.osgi.httpservice.util.Logger;
import org.glassfish.grizzly.servlet.FilterChainFactory;
import org.glassfish.grizzly.servlet.ServletConfigImpl;
import org.glassfish.grizzly.servlet.ServletHandler;
import org.glassfish.grizzly.servlet.WebappContext;
import org.osgi.service.http.HttpContext;

public class OSGiServletHandler
extends ServletHandler
implements OSGiHandler {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private HttpContext httpContext;
    private final Logger logger;
    private String servletPath;

    public OSGiServletHandler(Servlet servlet, HttpContext httpContext, OSGiServletContext servletContext, HashMap<String, String> servletInitParams, Logger logger) {
        super(OSGiServletHandler.createServletConfig(servletContext, servletInitParams));
        this.servletInstance = servlet;
        this.httpContext = httpContext;
        this.logger = logger;
    }

    private OSGiServletHandler(ServletConfigImpl servletConfig, Logger logger) {
        super(servletConfig);
        this.logger = logger;
    }

    public OSGiServletHandler newServletHandler(Servlet servlet) {
        OSGiServletHandler servletHandler = new OSGiServletHandler(this.getServletConfig(), this.logger);
        servletHandler.setServletInstance(servlet);
        servletHandler.setServletPath(this.getServletPath());
        servletHandler.setFilterChainFactory(this.filterChainFactory);
        servletHandler.httpContext = this.httpContext;
        return servletHandler;
    }

    public void startServlet() throws ServletException {
        this.configureServletEnv();
        this.servletInstance.init(this.getServletConfig());
    }

    @Override
    public ReentrantReadWriteLock.ReadLock getProcessingLock() {
        return this.lock.readLock();
    }

    @Override
    public ReentrantReadWriteLock.WriteLock getRemovalLock() {
        return this.lock.writeLock();
    }

    protected void setServletPath(String path) {
        this.servletPath = path;
    }

    protected String getServletPath() {
        return this.servletPath;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    @Override
    protected void setFilterChainFactory(FilterChainFactory filterChainFactory) {
        super.setFilterChainFactory(filterChainFactory);
    }

    private static ServletConfigImpl createServletConfig(OSGiServletContext ctx, Map<String, String> params) {
        OSGiServletConfig config = new OSGiServletConfig(ctx);
        config.setInitParameters(params);
        return config;
    }

    private static final class OSGiServletConfig
    extends ServletConfigImpl {
        protected OSGiServletConfig(WebappContext servletContextImpl) {
            super(servletContextImpl);
        }

        @Override
        protected void setInitParameters(Map<String, String> parameters) {
            super.setInitParameters(parameters);
        }
    }
}

