/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.servlet;

import java.io.IOException;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import org.glassfish.grizzly.ReadHandler;
import org.glassfish.grizzly.http.io.NIOInputStream;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.servlet.AsyncContextImpl;
import org.glassfish.grizzly.servlet.HttpServletRequestImpl;

public class ServletInputStreamImpl
extends ServletInputStream {
    private final HttpServletRequestImpl servletRequest;
    private NIOInputStream inputStream;
    private ReadHandler readHandler = null;
    private boolean hasSetReadListener = false;
    private boolean prevIsReady = true;
    private static final ThreadLocal<Boolean> IS_READY_SCOPE = new ThreadLocal();

    protected ServletInputStreamImpl(HttpServletRequestImpl servletRequest) {
        this.servletRequest = servletRequest;
    }

    public void initialize() throws IOException {
        this.inputStream = this.servletRequest.getRequest().createInputStream();
    }

    @Override
    public int read() throws IOException {
        if (!this.prevIsReady) {
            throw new IllegalStateException(LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_NON_BLOCKING_ERROR());
        }
        return this.inputStream.read();
    }

    @Override
    public int available() throws IOException {
        if (!this.prevIsReady) {
            return 0;
        }
        return this.inputStream.available();
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (!this.prevIsReady) {
            throw new IllegalStateException(LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_NON_BLOCKING_ERROR());
        }
        return this.inputStream.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.prevIsReady) {
            throw new IllegalStateException(LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_NON_BLOCKING_ERROR());
        }
        return this.inputStream.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.inputStream.skip(n);
    }

    @Override
    public void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.inputStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    void recycle() {
        this.inputStream = null;
        this.prevIsReady = true;
        this.hasSetReadListener = false;
        this.readHandler = null;
    }

    @Override
    public boolean isFinished() {
        return this.inputStream.isFinished();
    }

    @Override
    public boolean isReady() {
        if (!this.hasSetReadListener) {
            throw new IllegalStateException(LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_INPUTSTREAM_ISREADY_ERROR());
        }
        if (!this.prevIsReady) {
            return false;
        }
        boolean result = this.inputStream.isReady();
        if (!result) {
            if (this.hasSetReadListener) {
                this.prevIsReady = false;
                IS_READY_SCOPE.set(Boolean.TRUE);
                try {
                    this.inputStream.notifyAvailable(this.readHandler);
                }
                finally {
                    IS_READY_SCOPE.remove();
                }
            } else {
                this.prevIsReady = true;
            }
        }
        return result;
    }

    @Override
    public void setReadListener(ReadListener readListener) {
        if (this.hasSetReadListener) {
            throw new IllegalStateException("The ReadListener has already been set");
        }
        if (!this.servletRequest.isAsyncStarted() && !this.servletRequest.isUpgrade()) {
            throw new IllegalStateException(LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_INPUTSTREAM_SETREADLISTENER_ERROR());
        }
        this.readHandler = new ReadHandlerImpl(readListener);
        this.hasSetReadListener = true;
    }

    class ReadHandlerImpl
    implements ReadHandler {
        private ReadListener readListener = null;

        private ReadHandlerImpl(ReadListener listener) {
            this.readListener = listener;
        }

        @Override
        public void onDataAvailable() throws Exception {
            if (!Boolean.TRUE.equals(IS_READY_SCOPE.get())) {
                this.invokeReadPossibleCallback();
            } else {
                AsyncContextImpl.pool.execute(new Runnable(){

                    @Override
                    public void run() {
                        ReadHandlerImpl.this.invokeReadPossibleCallback();
                    }
                });
            }
        }

        @Override
        public void onAllDataRead() throws Exception {
            if (!Boolean.TRUE.equals(IS_READY_SCOPE.get())) {
                this.invokeAllDataReadCallback();
            } else {
                AsyncContextImpl.pool.execute(new Runnable(){

                    @Override
                    public void run() {
                        ReadHandlerImpl.this.invokeAllDataReadCallback();
                    }
                });
            }
        }

        @Override
        public void onError(final Throwable t) {
            if (!Boolean.TRUE.equals(IS_READY_SCOPE.get())) {
                this.readListener.onError(t);
            } else {
                AsyncContextImpl.pool.execute(new Runnable(){

                    @Override
                    public void run() {
                        ReadHandlerImpl.this.readListener.onError(t);
                    }
                });
            }
        }

        private void invokeReadPossibleCallback() {
            ServletInputStreamImpl.this.prevIsReady = true;
            try {
                this.readListener.onDataAvailable();
            }
            catch (Throwable t) {
                this.readListener.onError(t);
            }
        }

        private void invokeAllDataReadCallback() {
            ServletInputStreamImpl.this.prevIsReady = true;
            try {
                this.readListener.onAllDataRead();
            }
            catch (Throwable t) {
                this.readListener.onError(t);
            }
        }
    }
}

