/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.nio.channels.DatagramChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.ProcessorSelector;
import org.glassfish.grizzly.nio.transport.UDPNIOConnection;
import org.glassfish.grizzly.nio.transport.UDPNIOTransport;

public class UDPNIOServerConnection
extends UDPNIOConnection {
    private static final Logger LOGGER = Grizzly.logger(UDPNIOServerConnection.class);

    public UDPNIOServerConnection(UDPNIOTransport transport, DatagramChannel channel) {
        super(transport, channel);
    }

    @Override
    public Processor getProcessor() {
        if (this.processor == null) {
            return this.transport.getProcessor();
        }
        return this.processor;
    }

    @Override
    public ProcessorSelector getProcessorSelector() {
        if (this.processorSelector == null) {
            return this.transport.getProcessorSelector();
        }
        return this.processorSelector;
    }

    @Override
    public void close(CompletionHandler<Connection> completionHandler) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("UDPNIOServerConnection might be only closed by calling unbind().");
        }
        if (completionHandler != null) {
            completionHandler.completed(this);
        }
    }

    public void unbind(CompletionHandler<Connection> completionHandler) {
        super.close(completionHandler);
    }

    @Override
    protected void preClose() {
        try {
            ((UDPNIOTransport)this.transport).unbind(this);
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Exception occurred, when unbind connection: " + this, e);
        }
        super.preClose();
    }
}

