/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ConnectionProbe;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.SelectorRunner;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;

public class TCPNIOConnection
extends NIOConnection {
    private static final Logger LOGGER = Grizzly.logger(TCPNIOConnection.class);
    private SocketAddress localSocketAddress;
    private SocketAddress peerSocketAddress;
    private final AtomicReference<CompletionHandler<Connection>> connectHandlerRef = new AtomicReference();

    public TCPNIOConnection(TCPNIOTransport transport, SelectableChannel channel) {
        super(transport);
        this.channel = channel;
        this.resetProperties();
    }

    @Override
    protected void setSelectionKey(SelectionKey selectionKey) {
        super.setSelectionKey(selectionKey);
    }

    @Override
    protected void setSelectorRunner(SelectorRunner selectorRunner) {
        super.setSelectorRunner(selectorRunner);
    }

    @Override
    protected void preClose() {
        this.checkConnectFailed(null);
        this.transport.fireIOEvent(IOEvent.CLOSED, this, null);
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.peerSocketAddress;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.localSocketAddress;
    }

    protected final void resetProperties() {
        if (this.channel != null) {
            this.setReadBufferSize(this.transport.getReadBufferSize());
            this.setWriteBufferSize(this.transport.getWriteBufferSize());
            int transportMaxAsyncWriteQueueSize = ((TCPNIOTransport)this.transport).getAsyncQueueIO().getWriter().getMaxPendingBytesPerConnection();
            this.setMaxAsyncWriteQueueSize(transportMaxAsyncWriteQueueSize == -2 ? this.getWriteBufferSize() * 4 : transportMaxAsyncWriteQueueSize);
            if (this.channel instanceof SocketChannel) {
                this.localSocketAddress = ((SocketChannel)this.channel).socket().getLocalSocketAddress();
                this.peerSocketAddress = ((SocketChannel)this.channel).socket().getRemoteSocketAddress();
            } else if (this.channel instanceof ServerSocketChannel) {
                this.localSocketAddress = ((ServerSocketChannel)this.channel).socket().getLocalSocketAddress();
                this.peerSocketAddress = null;
            }
        }
    }

    @Override
    public void setReadBufferSize(int readBufferSize) {
        Socket socket = ((SocketChannel)this.channel).socket();
        try {
            int socketReadBufferSize = socket.getReceiveBufferSize();
            if (readBufferSize != -1) {
                if (readBufferSize > socketReadBufferSize) {
                    socket.setReceiveBufferSize(readBufferSize);
                }
                super.setReadBufferSize(readBufferSize);
            } else {
                super.setReadBufferSize(socketReadBufferSize);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error setting read buffer size", e);
        }
    }

    @Override
    public void setWriteBufferSize(int writeBufferSize) {
        Socket socket = ((SocketChannel)this.channel).socket();
        try {
            int socketWriteBufferSize = socket.getSendBufferSize();
            if (writeBufferSize != -1) {
                if (writeBufferSize > socketWriteBufferSize) {
                    socket.setSendBufferSize(writeBufferSize);
                }
                super.setWriteBufferSize(writeBufferSize);
            } else {
                super.setWriteBufferSize(socketWriteBufferSize);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error setting write buffer size", e);
        }
    }

    protected final void setConnectCompletionHandler(CompletionHandler<Connection> connectHandler) {
        this.connectHandlerRef.set(connectHandler);
    }

    protected final void onConnect() throws IOException {
        CompletionHandler localConnectHandler = this.connectHandlerRef.getAndSet(null);
        if (localConnectHandler != null) {
            try {
                localConnectHandler.completed(this);
            }
            catch (Exception e) {
                throw new IOException("Connect exception", e);
            }
        }
        TCPNIOConnection.notifyProbesConnect(this);
    }

    protected final void checkConnectFailed(Throwable failure) {
        CompletionHandler localConnectHandler = this.connectHandlerRef.getAndSet(null);
        if (localConnectHandler != null) {
            if (failure == null) {
                failure = new IOException("closed");
            }
            localConnectHandler.failed(failure);
        }
    }

    @Override
    protected void close0(CompletionHandler<Connection> completionHandler, boolean isClosedLocally) {
        super.close0(completionHandler, isClosedLocally);
    }

    protected final void onRead(Buffer data, int size) {
        if (size > 0) {
            TCPNIOConnection.notifyProbesRead(this, data, size);
        }
        this.checkEmptyRead(size);
    }

    protected final void onWrite(Buffer data, long size) {
        TCPNIOConnection.notifyProbesWrite(this, data, size);
    }

    void setMonitoringProbes(ConnectionProbe[] monitoringProbes) {
        this.monitoringConfig.addProbes(monitoringProbes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TCPNIOConnection");
        sb.append("{localSocketAddress=").append(this.localSocketAddress);
        sb.append(", peerSocketAddress=").append(this.peerSocketAddress);
        sb.append('}');
        return sb.toString();
    }
}

