/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.uacl;

import java.io.Serializable;
import java.security.Principal;
import java.security.acl.AclEntry;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Vector;

class AclEntryImpl
implements AclEntry,
Serializable {
    private static final long serialVersionUID = -2167701162058432944L;
    private int securityLevel = -1;
    private Principal princ = null;
    private boolean neg = false;
    private Vector permList = null;
    private Vector commList = null;

    private AclEntryImpl(AclEntryImpl i) {
        this.setPrincipal(i.getPrincipal());
        this.setSecurityLevel(i.getSecurityLevel());
        this.permList = new Vector();
        this.commList = new Vector();
        Enumeration en = i.contextNames();
        while (en.hasMoreElements()) {
            this.addContextName((String)en.nextElement());
        }
        en = i.permissions();
        while (en.hasMoreElements()) {
            this.addPermission((Permission)en.nextElement());
        }
        if (i.isNegative()) {
            this.setNegativePermissions();
        }
    }

    public AclEntryImpl() {
        this.princ = null;
        this.permList = new Vector();
        this.commList = new Vector();
    }

    public AclEntryImpl(Principal p) {
        this.princ = p;
        this.permList = new Vector();
        this.commList = new Vector();
    }

    public Object clone() {
        AclEntryImpl i = new AclEntryImpl(this);
        return i;
    }

    public boolean isNegative() {
        return this.neg;
    }

    public boolean addPermission(Permission perm) {
        if (this.permList.contains(perm)) {
            return false;
        }
        this.permList.addElement(perm);
        return true;
    }

    public boolean removePermission(Permission perm) {
        if (!this.permList.contains(perm)) {
            return false;
        }
        this.permList.removeElement(perm);
        return true;
    }

    public boolean checkPermission(Permission perm) {
        return this.permList.contains(perm);
    }

    public Enumeration permissions() {
        return this.permList.elements();
    }

    public void setNegativePermissions() {
        this.neg = true;
    }

    public Principal getPrincipal() {
        return this.princ;
    }

    public boolean setPrincipal(Principal p) {
        if (this.princ != null) {
            return false;
        }
        this.princ = p;
        return true;
    }

    public String toString() {
        return "AclEntry:" + ((Object)this.princ).toString();
    }

    public Enumeration contextNames() {
        return this.commList.elements();
    }

    public boolean addContextName(String comm) {
        if (this.commList.contains(comm)) {
            return false;
        }
        this.commList.addElement(comm);
        return true;
    }

    public boolean removeContextName(String comm) {
        if (!this.commList.contains(comm)) {
            return false;
        }
        this.commList.removeElement(comm);
        return true;
    }

    public boolean checkContextName(String comm) {
        return this.commList.contains(comm);
    }

    public boolean checkSecurityLevel(int securityLevel) {
        return this.securityLevel == securityLevel;
    }

    public int getSecurityLevel() {
        return this.securityLevel;
    }

    public void setSecurityLevel(int sec) {
        this.securityLevel = sec;
    }
}

