/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.manager;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.manager.SnmpQManager;
import com.sun.management.snmp.manager.SnmpRequest;

class SnmpTimerServer
extends Thread {
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpTimerServer");
    boolean isBeingDestroyed = false;
    String dbgTag = "SnmpTimerServer";
    SnmpQManager snmpq = null;
    private SnmpRequest req = null;

    public SnmpTimerServer(ThreadGroup grp, SnmpQManager q) {
        super(grp, "SnmpTimerServer");
        this.setName(this.dbgTag);
        this.snmpq = q;
        this.start();
    }

    public synchronized void stopTimerServer() {
        if (this.isAlive()) {
            this.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void run() {
        Thread.currentThread().setPriority(5);
        if (logger.finerOn()) {
            logger.finer("run", "Timer Thread started");
        }
        while (true) {
            try {
                do {
                    if (logger.finerOn()) {
                        logger.finer("run", "Blocking for requests");
                    }
                    if (this.req == null) {
                        this.req = this.snmpq.getTimeoutRequests();
                    }
                    if (this.req != null && this.req.inProgress()) {
                        if (logger.finerOn()) {
                            logger.finer("run", "Handle Timeout Request " + this.req.getRequestId());
                        }
                        this.req.action();
                        this.req = null;
                    }
                    if (this.req == null || !this.req.isAborted()) continue;
                    this.req = null;
                } while (!this.isBeingDestroyed);
            }
            catch (Exception e) {
                if (!logger.finestOn()) continue;
                logger.finest("run", e.toString());
                continue;
            }
            catch (ThreadDeath d) {
                if (logger.finestOn()) {
                    logger.finest("run", "Timer server unexpectedly shutting down");
                    logger.finest("run", d);
                }
                throw d;
            }
            catch (OutOfMemoryError ome) {
                if (logger.finestOn()) {
                    logger.finest("run", "Received OutOfMemory");
                }
                SnmpTimerServer.yield();
                continue;
            }
            catch (Error err) {
                if (!logger.finestOn()) continue;
                logger.finest("run", "Received Internal error");
                logger.finest("run", err);
                continue;
            }
            break;
        }
    }
}

