/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.agent;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpEngineId;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpPduPacket;
import com.sun.management.snmp.SnmpScopedPduPacket;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.agent.SnmpMibRequest;
import com.sun.management.snmp.agent.SnmpProxy;
import com.sun.management.snmp.manager.SnmpParams;
import com.sun.management.snmp.manager.SnmpPeer;
import com.sun.management.snmp.manager.SnmpV3Parameters;

public abstract class SnmpV3Proxy
extends SnmpProxy {
    String dbgTag = "SnmpV3Proxy";
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.proxy", "SnmpV3Proxy");

    public SnmpV3Proxy(SnmpEngine engine, SnmpPeer peer, String rootOid, String name) throws SnmpStatusException {
        super(engine, peer, rootOid, name);
    }

    public abstract SnmpEngineId getEngineId();

    protected abstract SnmpParams createParameters(SnmpPdu var1) throws SnmpStatusException;

    protected SnmpParams translateParameters(SnmpMibRequest req) throws SnmpStatusException {
        SnmpPdu pdu;
        if (logger.finestOn()) {
            logger.finest("translateParameters", " Mib request :" + req);
        }
        if ((pdu = req.getPdu()) == null) {
            return this.createParameters(null);
        }
        SnmpV3Parameters params = (SnmpV3Parameters)this.createParameters(pdu);
        byte[] contextName = null;
        int msgFlags = 0;
        byte[] contextEngineId = this.getEngineId().getBytes();
        params.setContextEngineId(contextEngineId);
        if (logger.finestOn()) {
            logger.finest("translateParameters", " Snmp version :" + pdu.version);
        }
        switch (pdu.version) {
            case 0: 
            case 1: {
                int contextIndex;
                SnmpPduPacket pack = (SnmpPduPacket)pdu;
                String community = new String(pack.community);
                if (logger.finestOn()) {
                    logger.finest("translateParameters", " Community :" + community);
                }
                if ((contextIndex = community.indexOf(64)) != -1) {
                    contextName = community.substring(contextIndex + 1).getBytes();
                }
                msgFlags = 0;
                break;
            }
            case 3: {
                SnmpScopedPduPacket pack = (SnmpScopedPduPacket)pdu;
                contextName = pack.contextName;
                msgFlags = pack.msgFlags;
                params.setMsgMaxSize(pack.msgMaxSize);
                if (!logger.finestOn()) break;
                logger.finest("translateParameters", " msgMaxSize :" + pack.msgMaxSize);
            }
        }
        if (logger.finestOn()) {
            logger.finest("translateParameters", " contextName :" + contextName);
            logger.finest("translateParameters", " msgFlags :" + msgFlags);
        }
        params.setSecurityLevel(msgFlags);
        params.setContextName(contextName);
        if (logger.finestOn()) {
            logger.finest("translateParameters", "Returned parameters : " + params);
        }
        return params;
    }
}

