/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk;

import com.sun.jdmk.ModifiableClassLoaderRepository;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.loading.ClassLoaderRepository;

class CompatibleClassLoaderRepositorySupport
implements ModifiableClassLoaderRepository {
    private final MBeanServer inner;
    private static final String unsupported = "Operation not supported in this implementation";

    public CompatibleClassLoaderRepositorySupport(MBeanServer inner) {
        if (inner == null) {
            throw new IllegalArgumentException("inner MBeanServer is null");
        }
        this.inner = inner;
    }

    public void addClassLoader(ClassLoader loader) {
        ClassLoaderRepository clr = this.inner.getClassLoaderRepository();
        if (!(clr instanceof ModifiableClassLoaderRepository)) {
            throw new UnsupportedOperationException(unsupported);
        }
        ((ModifiableClassLoaderRepository)clr).addClassLoader(loader);
    }

    public void removeClassLoader(ClassLoader loader) {
        ClassLoaderRepository clr = this.inner.getClassLoaderRepository();
        if (!(clr instanceof ModifiableClassLoaderRepository)) {
            throw new UnsupportedOperationException(unsupported);
        }
        ((ModifiableClassLoaderRepository)clr).removeClassLoader(loader);
    }

    public void addClassLoader(ObjectName name, ClassLoader loader) {
        ClassLoaderRepository clr = this.inner.getClassLoaderRepository();
        if (!(clr instanceof ModifiableClassLoaderRepository)) {
            throw new UnsupportedOperationException(unsupported);
        }
        ((ModifiableClassLoaderRepository)clr).addClassLoader(name, loader);
    }

    public void removeClassLoader(ObjectName name) {
        ClassLoaderRepository clr = this.inner.getClassLoaderRepository();
        if (!(clr instanceof ModifiableClassLoaderRepository)) {
            throw new UnsupportedOperationException(unsupported);
        }
        ((ModifiableClassLoaderRepository)clr).removeClassLoader(name);
    }

    public ClassLoader getClassLoader(ObjectName name) {
        try {
            return this.inner.getClassLoader(name);
        }
        catch (InstanceNotFoundException e) {
            return null;
        }
    }

    public final Class loadClass(String className) throws ClassNotFoundException {
        ClassLoaderRepository clr = this.inner.getClassLoaderRepository();
        if (clr == null) {
            throw new UnsupportedOperationException(unsupported);
        }
        return clr.loadClass(className);
    }

    public final Class loadClassWithout(ClassLoader loader, String className) throws ClassNotFoundException {
        ClassLoaderRepository clr = this.inner.getClassLoaderRepository();
        if (clr == null) {
            throw new UnsupportedOperationException(unsupported);
        }
        return clr.loadClassWithout(loader, className);
    }

    public final Class loadClassBefore(ClassLoader loader, String className) throws ClassNotFoundException {
        ClassLoaderRepository clr = this.inner.getClassLoaderRepository();
        if (clr == null) {
            throw new UnsupportedOperationException(unsupported);
        }
        return clr.loadClassBefore(loader, className);
    }
}

