/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.external.amx;

import javax.management.ObjectName;

public final class AMXGlassfish {
    public static final String DEFAULT_JMX_DOMAIN = "amx";
    public static final AMXGlassfish DEFAULT = new AMXGlassfish("amx");
    private final String mJMXDomain;
    private final ObjectName mDomainRoot;

    public AMXGlassfish(String jmxDomain) {
        this.mJMXDomain = jmxDomain;
        this.mDomainRoot = this.newObjectName("", "domain-root", null);
    }

    public String amxJMXDomain() {
        return this.mJMXDomain;
    }

    public String amxSupportDomain() {
        return this.amxJMXDomain() + "-support";
    }

    public String dasName() {
        return "server";
    }

    public String dasConfig() {
        return this.dasName() + "-config";
    }

    public ObjectName domainRoot() {
        return this.mDomainRoot;
    }

    public ObjectName monitoringRoot() {
        return this.newObjectName("/", "mon", null);
    }

    public ObjectName serverMon(String serverName) {
        return this.newObjectName("/mon", "server-mon", serverName);
    }

    public ObjectName newObjectName(String pp, String type, String name) {
        String props = AMXGlassfish.prop("pp", pp) + "," + AMXGlassfish.prop("type", type);
        if (name != null) {
            props = props + "," + AMXGlassfish.prop("name", name);
        }
        return this.newObjectName(props);
    }

    public ObjectName newObjectName(String s) {
        String name = s;
        if (!name.startsWith(this.amxJMXDomain())) {
            name = this.amxJMXDomain() + ":" + name;
        }
        try {
            return new ObjectName(name);
        }
        catch (Exception e) {
            throw new RuntimeException("bad ObjectName: " + name, e);
        }
    }

    private static String prop(String key, String value) {
        return key + "=" + value;
    }
}

