/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.util.Result;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.admin.AdminAdapter;
import com.sun.enterprise.v3.admin.adapter.AdminConsoleAdapter;
import com.sun.enterprise.v3.services.impl.GrizzlyProxy;
import com.sun.enterprise.v3.services.impl.NetworkProxy;
import com.sun.enterprise.v3.services.impl.VirtualHostMapper;
import com.sun.grizzly.Controller;
import com.sun.grizzly.tcp.Adapter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.FutureProvider;
import org.glassfish.api.Startup;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.api.container.RequestDispatcher;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.flashlight.provider.ProbeProviderFactory;
import org.glassfish.kernel.admin.monitor.ThreadPoolProbeProvider;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class GrizzlyService
implements Startup,
RequestDispatcher,
PostConstruct,
PreDestroy,
FutureProvider<Result<Thread>> {
    public static final int ALL_PORTS = Integer.MAX_VALUE;
    static final ThreadPoolProbeProvider NO_OP_THREADPOOL_PROBE_PROVIDER = (ThreadPoolProbeProvider)Proxy.newProxyInstance(ThreadPoolProbeProvider.class.getClassLoader(), new Class[]{ThreadPoolProbeProvider.class}, (InvocationHandler)new NoopInvocationHandler());
    @Inject(name="server-config")
    Config config;
    @Inject
    Logger logger;
    @Inject
    Habitat habitat;
    @Inject
    ProbeProviderFactory probeProviderFactory;
    List<NetworkProxy> proxies = new ArrayList<NetworkProxy>();
    List<Future<Result<Thread>>> futures;
    private final Controller controller = new Controller();
    Collection<String> hosts = new ArrayList<String>();
    private ThreadPoolProbeProvider threadPoolProbeProvider;

    public void addNetworkProxy(NetworkProxy proxy) {
        this.proxies.add(proxy);
    }

    public void removeNetworkProxy(int port) {
        NetworkProxy proxy = null;
        for (NetworkProxy p : this.proxies) {
            if (p.getPort() != port) continue;
            proxy = p;
        }
        if (proxy != null) {
            proxy.stop();
            proxy.destroy();
            this.proxies.remove(proxy);
        }
    }

    public Controller getController() {
        return this.controller;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Habitat getHabitat() {
        return this.habitat;
    }

    public ThreadPoolProbeProvider getThreadPoolProbeProvider() {
        return this.threadPoolProbeProvider;
    }

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    public void postConstruct() {
        HttpService httpService = this.config.getHttpService();
        try {
            this.createProbeProviders();
            this.futures = new ArrayList<Future<Result<Thread>>>();
            for (HttpListener listener : httpService.getHttpListener()) {
                String jkEnabled = listener.getPropertyValue("jkEnabled");
                if (jkEnabled != null && ConfigBeansUtilities.toBoolean((String)jkEnabled)) continue;
                if (!Boolean.valueOf(listener.getEnabled()).booleanValue()) {
                    this.logger.info("Network listener " + listener.getId() + " on port " + listener.getPort() + " disabled per domain.xml");
                    continue;
                }
                this.futures.add(this.createNetworkProxy(listener, httpService));
            }
            this.registerNetworkProxy();
        }
        catch (RuntimeException e) {
            this.logger.log(Level.SEVERE, "Unable to start v3. Closing all ports", e);
            for (NetworkProxy proxy : this.proxies) {
                try {
                    proxy.stop();
                }
                catch (Exception proxyStopException) {
                    this.logger.log(Level.SEVERE, "Exception closing port: " + proxy.getPort(), proxyStopException);
                }
            }
            throw e;
        }
    }

    public List<Future<Result<Thread>>> getFutures() {
        return this.futures;
    }

    private void createProbeProviders() {
        try {
            this.threadPoolProbeProvider = (ThreadPoolProbeProvider)this.probeProviderFactory.getProbeProvider("core", "threadpool", null, ThreadPoolProbeProvider.class);
            if (this.threadPoolProbeProvider == null) {
                this.logger.log(Level.WARNING, "Unable to create probe provider for interface " + ThreadPoolProbeProvider.class.getName() + ", using no-op provider");
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Unable to create probe provider for interface " + ThreadPoolProbeProvider.class.getName(), e);
        }
        if (this.threadPoolProbeProvider == null) {
            this.threadPoolProbeProvider = NO_OP_THREADPOOL_PROBE_PROVIDER;
        }
    }

    public synchronized Future<Result<Thread>> createNetworkProxy(HttpListener listener, HttpService httpService) {
        GrizzlyProxy proxy = new GrizzlyProxy(this, listener, httpService);
        proxy.setVsMapper(new VirtualHostMapper(this.logger, listener));
        for (VirtualServer vs : httpService.getVirtualServer()) {
            List vsListeners = StringUtils.parseStringList((String)vs.getHttpListeners(), (String)" ,");
            if (vsListeners != null && vsListeners.size() != 0 && !vsListeners.contains(listener.getId())) continue;
            proxy.getVsMapper().addVirtualServer(vs);
            if (this.hosts.contains(vs.getId())) continue;
            this.hosts.add(vs.getId());
        }
        Future<Result<Thread>> future = proxy.start();
        this.proxies.add(proxy);
        return future;
    }

    public void registerNetworkProxy() {
        for (org.glassfish.api.container.Adapter subAdapter : this.habitat.getAllByContract(org.glassfish.api.container.Adapter.class)) {
            try {
                if (subAdapter instanceof AdminAdapter) {
                    AdminAdapter aa = (AdminAdapter)subAdapter;
                    if (aa.isRegistered()) continue;
                    this.registerAdminAdapter(aa);
                    aa.setRegistered(true);
                    continue;
                }
                if (subAdapter instanceof AdminConsoleAdapter) {
                    AdminConsoleAdapter aca = (AdminConsoleAdapter)subAdapter;
                    if (aca.isRegistered()) continue;
                    this.registerAdminConsoleAdapter(aca);
                    aca.setRegistered(true);
                    continue;
                }
                this.registerEndpoint(subAdapter.getContextRoot(), this.hosts, (Adapter)subAdapter, null);
            }
            catch (EndpointRegistrationException e) {
                this.logger.log(Level.WARNING, "GrizzlyService endpoint registration problem", e);
            }
        }
    }

    public void preDestroy() {
        for (NetworkProxy proxy : this.proxies) {
            proxy.stop();
        }
    }

    public void registerEndpoint(String contextRoot, Adapter endpointAdapter, ApplicationContainer container) throws EndpointRegistrationException {
        this.registerEndpoint(contextRoot, this.hosts, endpointAdapter, container);
    }

    public void registerEndpoint(String contextRoot, Collection<String> vsServers, Adapter endpointAdapter, ApplicationContainer container) throws EndpointRegistrationException {
        this.registerEndpoint(contextRoot, Integer.MAX_VALUE, vsServers, endpointAdapter, container);
    }

    public void registerEndpoint(String contextRoot, int port, Collection<String> vsServers, Adapter endpointAdapter, ApplicationContainer container) throws EndpointRegistrationException {
        for (NetworkProxy proxy : this.proxies) {
            if (port != Integer.MAX_VALUE && proxy.getPort() != port) continue;
            proxy.registerEndpoint(contextRoot, vsServers, endpointAdapter, container);
        }
    }

    public void unregisterEndpoint(String contextRoot) throws EndpointRegistrationException {
        this.unregisterEndpoint(contextRoot, null);
    }

    public void unregisterEndpoint(String contextRoot, ApplicationContainer app) throws EndpointRegistrationException {
        for (NetworkProxy proxy : this.proxies) {
            proxy.unregisterEndpoint(contextRoot, app);
        }
    }

    private void registerAdminAdapter(AdminAdapter aa) throws EndpointRegistrationException {
        int port = aa.getListenPort();
        List<String> vs = aa.getVirtualServers();
        String cr = aa.getContextRoot();
        this.registerEndpoint(cr, port, vs, (Adapter)aa, null);
    }

    private void registerAdminConsoleAdapter(AdminConsoleAdapter aca) throws EndpointRegistrationException {
        int port = aca.getListenPort();
        List<String> vs = aca.getVirtualServers();
        String cr = aca.getContextRoot();
        this.registerEndpoint(cr, port, vs, (Adapter)aca, null);
    }

    public static class NoopInvocationHandler
    implements InvocationHandler {
        public Object invoke(Object proxy, Method method, Object[] args) {
            return null;
        }
    }
}

