/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.iiop;

import org.glassfish.rmic.iiop.BatchEnvironment;
import org.glassfish.rmic.iiop.ContextElement;
import org.glassfish.rmic.iiop.Type;
import org.glassfish.rmic.iiop.TypeContext;
import org.glassfish.rmic.tools.java.CompilerError;

public class ContextStack {
    public static final int TOP = 1;
    public static final int METHOD = 2;
    public static final int METHOD_RETURN = 3;
    public static final int METHOD_ARGUMENT = 4;
    public static final int METHOD_EXCEPTION = 5;
    public static final int MEMBER = 6;
    public static final int MEMBER_CONSTANT = 7;
    public static final int MEMBER_STATIC = 8;
    public static final int MEMBER_TRANSIENT = 9;
    public static final int IMPLEMENTS = 10;
    public static final int EXTENDS = 11;
    private static final String[] CODE_NAMES = new String[]{"UNKNOWN ", "Top level type ", "Method ", "Return parameter ", "Parameter ", "Exception ", "Member ", "Constant member ", "Static member ", "Transient member ", "Implements ", "Extends "};
    private int currentIndex = -1;
    private int maxIndex = 100;
    private TypeContext[] stack = new TypeContext[this.maxIndex];
    private int newCode = 1;
    private BatchEnvironment env = null;
    private boolean trace = false;
    private TypeContext tempContext = new TypeContext();
    private static final String TRACE_INDENT = "   ";

    public ContextStack(BatchEnvironment env) {
        this.env = env;
        env.contextStack = this;
    }

    public boolean anyErrors() {
        return this.env.nerrors > 0;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public boolean isTraceOn() {
        return this.trace;
    }

    public BatchEnvironment getEnv() {
        return this.env;
    }

    public void setNewContextCode(int code) {
        this.newCode = code;
    }

    public int getCurrentContextCode() {
        return this.newCode;
    }

    final void traceCallStack() {
        if (this.trace) {
            ContextStack.dumpCallStack();
        }
    }

    public static final void dumpCallStack() {
        new Error().printStackTrace(System.out);
    }

    private final void tracePrint(String text, boolean line) {
        int length = text.length() + this.currentIndex * TRACE_INDENT.length();
        StringBuffer buffer = new StringBuffer(length);
        for (int i = 0; i < this.currentIndex; ++i) {
            buffer.append(TRACE_INDENT);
        }
        buffer.append(text);
        if (line) {
            buffer.append("\n");
        }
        System.out.print(buffer.toString());
    }

    final void trace(String text) {
        if (this.trace) {
            this.tracePrint(text, false);
        }
    }

    final void traceln(String text) {
        if (this.trace) {
            this.tracePrint(text, true);
        }
    }

    final void traceExistingType(Type type) {
        if (this.trace) {
            this.tempContext.set(this.newCode, type);
            this.traceln(this.toResultString(this.tempContext, true, true));
        }
    }

    public TypeContext push(ContextElement element) {
        TypeContext it;
        ++this.currentIndex;
        if (this.currentIndex == this.maxIndex) {
            int newMax = this.maxIndex * 2;
            TypeContext[] newStack = new TypeContext[newMax];
            System.arraycopy(this.stack, 0, newStack, 0, this.maxIndex);
            this.maxIndex = newMax;
            this.stack = newStack;
        }
        if ((it = this.stack[this.currentIndex]) == null) {
            this.stack[this.currentIndex] = it = new TypeContext();
        }
        it.set(this.newCode, element);
        this.traceln(this.toTrialString(it));
        return it;
    }

    public TypeContext pop(boolean wasValid) {
        if (this.currentIndex < 0) {
            throw new CompilerError("Nothing on stack!");
        }
        this.newCode = this.stack[this.currentIndex].getCode();
        this.traceln(this.toResultString(this.stack[this.currentIndex], wasValid, false));
        Type last = this.stack[this.currentIndex].getCandidateType();
        if (last != null) {
            if (wasValid) {
                last.setStatus(1);
            } else {
                last.setStatus(2);
            }
        }
        --this.currentIndex;
        if (this.currentIndex < 0) {
            if (wasValid) {
                Type.updateAllInvalidTypes(this);
            }
            return null;
        }
        return this.stack[this.currentIndex];
    }

    public int size() {
        return this.currentIndex + 1;
    }

    public TypeContext getContext(int index) {
        if (this.currentIndex < index) {
            throw new Error("Index out of range");
        }
        return this.stack[index];
    }

    public TypeContext getContext() {
        if (this.currentIndex < 0) {
            throw new Error("Nothing on stack!");
        }
        return this.stack[this.currentIndex];
    }

    public boolean isParentAValue() {
        if (this.currentIndex > 0) {
            return this.stack[this.currentIndex - 1].isValue();
        }
        return false;
    }

    public TypeContext getParentContext() {
        if (this.currentIndex > 0) {
            return this.stack[this.currentIndex - 1];
        }
        return null;
    }

    public String getContextCodeString() {
        if (this.currentIndex >= 0) {
            return CODE_NAMES[this.newCode];
        }
        return CODE_NAMES[0];
    }

    public static String getContextCodeString(int contextCode) {
        return CODE_NAMES[contextCode];
    }

    private String toTrialString(TypeContext it) {
        int code = it.getCode();
        if (code != 2 && code != 6) {
            return it.toString() + " (trying " + it.getTypeDescription() + ")";
        }
        return it.toString();
    }

    private String toResultString(TypeContext it, boolean result, boolean preExisting) {
        int code = it.getCode();
        if (code != 2 && code != 6) {
            if (result) {
                String str = it.toString() + " --> " + it.getTypeDescription();
                if (preExisting) {
                    return str + " [Previously mapped]";
                }
                return str;
            }
        } else if (result) {
            return it.toString() + " --> [Mapped]";
        }
        return it.toString() + " [Did not map]";
    }

    public void clear() {
        for (int i = 0; i < this.stack.length; ++i) {
            if (this.stack[i] == null) continue;
            this.stack[i].destroy();
        }
    }
}

