/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.iiop;

import org.glassfish.rmic.iiop.ContextStack;
import org.glassfish.rmic.iiop.IDLNames;
import org.glassfish.rmic.iiop.Null;
import org.glassfish.rmic.iiop.Type;
import org.glassfish.rmic.tools.java.CompilerError;
import org.glassfish.rmic.tools.java.Identifier;

public class PrimitiveType
extends Type {
    public static PrimitiveType forPrimitive(org.glassfish.rmic.tools.java.Type type, ContextStack stack) {
        int typeCode;
        if (stack.anyErrors()) {
            return null;
        }
        Type existing = PrimitiveType.getType(type, stack);
        if (existing != null) {
            if (!(existing instanceof PrimitiveType)) {
                return null;
            }
            return (PrimitiveType)existing;
        }
        switch (type.getTypeCode()) {
            case 11: {
                typeCode = 1;
                break;
            }
            case 0: {
                typeCode = 2;
                break;
            }
            case 1: {
                typeCode = 4;
                break;
            }
            case 2: {
                typeCode = 8;
                break;
            }
            case 3: {
                typeCode = 16;
                break;
            }
            case 4: {
                typeCode = 32;
                break;
            }
            case 5: {
                typeCode = 64;
                break;
            }
            case 6: {
                typeCode = 128;
                break;
            }
            case 7: {
                typeCode = 256;
                break;
            }
            default: {
                return null;
            }
        }
        PrimitiveType it = new PrimitiveType(stack, typeCode);
        PrimitiveType.putType(type, (Type)it, stack);
        stack.push(it);
        stack.pop(true);
        return it;
    }

    @Override
    public String getSignature() {
        switch (this.getTypeCode()) {
            case 1: {
                return "V";
            }
            case 2: {
                return "Z";
            }
            case 4: {
                return "B";
            }
            case 8: {
                return "C";
            }
            case 16: {
                return "S";
            }
            case 32: {
                return "I";
            }
            case 64: {
                return "J";
            }
            case 128: {
                return "F";
            }
            case 256: {
                return "D";
            }
        }
        return null;
    }

    @Override
    public String getTypeDescription() {
        return "Primitive";
    }

    @Override
    public String getQualifiedIDLName(boolean global) {
        return super.getQualifiedIDLName(false);
    }

    @Override
    protected Class loadClass() {
        switch (this.getTypeCode()) {
            case 1: {
                return Null.class;
            }
            case 2: {
                return Boolean.TYPE;
            }
            case 4: {
                return Byte.TYPE;
            }
            case 8: {
                return Character.TYPE;
            }
            case 16: {
                return Short.TYPE;
            }
            case 32: {
                return Integer.TYPE;
            }
            case 64: {
                return Long.TYPE;
            }
            case 128: {
                return Float.TYPE;
            }
            case 256: {
                return Double.TYPE;
            }
        }
        throw new CompilerError("Not a primitive type");
    }

    private PrimitiveType(ContextStack stack, int typeCode) {
        super(stack, typeCode | 0x1000000);
        String idlName = IDLNames.getTypeName(typeCode, false);
        Identifier id = null;
        switch (typeCode) {
            case 1: {
                id = idVoid;
                break;
            }
            case 2: {
                id = idBoolean;
                break;
            }
            case 4: {
                id = idByte;
                break;
            }
            case 8: {
                id = idChar;
                break;
            }
            case 16: {
                id = idShort;
                break;
            }
            case 32: {
                id = idInt;
                break;
            }
            case 64: {
                id = idLong;
                break;
            }
            case 128: {
                id = idFloat;
                break;
            }
            case 256: {
                id = idDouble;
                break;
            }
            default: {
                throw new CompilerError("Not a primitive type");
            }
        }
        this.setNames(id, null, idlName);
        this.setRepositoryID();
    }
}

