/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.java;

import java.util.Hashtable;
import org.glassfish.rmic.TypeCode;
import org.glassfish.rmic.tools.java.ArrayType;
import org.glassfish.rmic.tools.java.ClassType;
import org.glassfish.rmic.tools.java.CompilerError;
import org.glassfish.rmic.tools.java.Constants;
import org.glassfish.rmic.tools.java.Identifier;
import org.glassfish.rmic.tools.java.MethodType;

public class Type
implements Constants {
    private static final Hashtable<String, Type> typeHash = new Hashtable(231);
    private TypeCode typeCode;
    protected String typeSig;
    public static final Type[] noArgs = new Type[0];
    public static final Type tError = new Type(TypeCode.ERROR, "?");
    public static final Type tPackage = new Type(TypeCode.ERROR, ".");
    public static final Type tNull = new Type(TypeCode.NULL, "*");
    public static final Type tVoid = new Type(TypeCode.VOID, "V");
    public static final Type tBoolean = new Type(TypeCode.BOOLEAN, "Z");
    public static final Type tByte = new Type(TypeCode.BYTE, "B");
    public static final Type tChar = new Type(TypeCode.CHAR, "C");
    public static final Type tShort = new Type(TypeCode.SHORT, "S");
    public static final Type tInt = new Type(TypeCode.INT, "I");
    public static final Type tFloat = new Type(TypeCode.FLOAT, "F");
    public static final Type tLong = new Type(TypeCode.LONG, "J");
    public static final Type tDouble = new Type(TypeCode.DOUBLE, "D");
    public static final Type tObject = Type.tClass(idJavaLangObject);
    public static final Type tClassDesc = Type.tClass(idJavaLangClass);
    public static final Type tString = Type.tClass(idJavaLangString);
    public static final Type tCloneable = Type.tClass(idJavaLangCloneable);
    public static final Type tSerializable = Type.tClass(idJavaIoSerializable);

    protected Type(TypeCode tc, String typeSig) {
        this.typeCode = tc;
        this.typeSig = typeSig;
        typeHash.put(typeSig, this);
    }

    public final String getTypeSignature() {
        return this.typeSig;
    }

    public final int getTypeCode() {
        return this.typeCode.tcCode();
    }

    public final int getTypeMask() {
        return 1 << this.typeCode.tcCode();
    }

    public final boolean isType(int tc) {
        return this.typeCode.tcCode() == tc;
    }

    public boolean isVoidArray() {
        if (!this.isType(9)) {
            return false;
        }
        Type type = this;
        while (type.isType(9)) {
            type = type.getElementType();
        }
        return type.isType(11);
    }

    public final boolean inMask(int tm) {
        return (1 << this.typeCode.tcCode() & tm) != 0;
    }

    public static synchronized Type tArray(Type elem) {
        String sig = "[" + elem.getTypeSignature();
        Type t = typeHash.get(sig);
        if (t == null) {
            t = new ArrayType(sig, elem);
        }
        return t;
    }

    public Type getElementType() {
        throw new CompilerError("getElementType");
    }

    public int getArrayDimension() {
        return 0;
    }

    public static synchronized Type tClass(Identifier className) {
        if (className.isInner()) {
            Type t = Type.tClass(Type.mangleInnerType(className));
            if (t.getClassName() != className) {
                Type.changeClassName(t.getClassName(), className);
            }
            return t;
        }
        if (className.typeObject != null) {
            return className.typeObject;
        }
        String sig = "L" + className.toString().replace('.', '/') + ";";
        Type t = typeHash.get(sig);
        if (t == null) {
            t = new ClassType(sig, className);
        }
        className.typeObject = t;
        return t;
    }

    public Identifier getClassName() {
        throw new CompilerError("getClassName:" + this);
    }

    public static Identifier mangleInnerType(Identifier className) {
        if (!className.isInner()) {
            return className;
        }
        Identifier mname = Identifier.lookup(className.getFlatName().toString().replace('.', '$'));
        if (mname.isInner()) {
            throw new CompilerError("mangle " + mname);
        }
        return Identifier.lookup(className.getQualifier(), mname);
    }

    private static void changeClassName(Identifier oldName, Identifier newName) {
        ((ClassType)Type.tClass((Identifier)oldName)).className = newName;
    }

    public static synchronized Type tMethod(Type ret) {
        return Type.tMethod(ret, noArgs);
    }

    public static synchronized Type tMethod(Type returnType, Type[] argTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (Type argType : argTypes) {
            sb.append(argType.getTypeSignature());
        }
        sb.append(")");
        sb.append(returnType.getTypeSignature());
        String sig = sb.toString();
        Type t = typeHash.get(sig);
        if (t == null) {
            t = new MethodType(sig, returnType, argTypes);
        }
        return t;
    }

    public Type getReturnType() {
        throw new CompilerError("getReturnType");
    }

    public Type[] getArgumentTypes() {
        throw new CompilerError("getArgumentTypes");
    }

    public static synchronized Type tType(String sig) {
        Type t = typeHash.get(sig);
        if (t != null) {
            return t;
        }
        switch (sig.charAt(0)) {
            case '[': {
                return Type.tArray(Type.tType(sig.substring(1)));
            }
            case 'L': {
                return Type.tClass(Identifier.lookup(sig.substring(1, sig.length() - 1).replace('/', '.')));
            }
            case '(': {
                Type[] argv = new Type[8];
                int argc = 0;
                int i = 1;
                while (sig.charAt(i) != ')') {
                    int j = i;
                    while (sig.charAt(j) == '[') {
                        ++j;
                    }
                    if (sig.charAt(j++) == 'L') {
                        while (sig.charAt(j++) != ';') {
                        }
                    }
                    if (argc == argv.length) {
                        Type[] newargv = new Type[argc * 2];
                        System.arraycopy(argv, 0, newargv, 0, argc);
                        argv = newargv;
                    }
                    argv[argc++] = Type.tType(sig.substring(i, j));
                    i = j;
                }
                Type[] argtypes = new Type[argc];
                System.arraycopy(argv, 0, argtypes, 0, argc);
                return Type.tMethod(Type.tType(sig.substring(i + 1)), argtypes);
            }
        }
        throw new CompilerError("invalid TypeSignature:" + sig);
    }

    public boolean equalArguments(Type t) {
        return false;
    }

    public int stackSize() {
        switch (this.typeCode.tcCode()) {
            case 11: 
            case 13: {
                return 0;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: {
                return 1;
            }
            case 5: 
            case 7: {
                return 2;
            }
        }
        throw new CompilerError("stackSize " + this.toString());
    }

    public int getTypeCodeOffset() {
        switch (this.typeCode.tcCode()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return 0;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 2;
            }
            case 7: {
                return 3;
            }
            case 8: 
            case 9: 
            case 10: {
                return 4;
            }
        }
        throw new CompilerError("invalid typecode: " + (Object)((Object)this.typeCode));
    }

    public String typeString(String id, boolean abbrev, boolean ret) {
        String s = null;
        switch (this.typeCode.tcCode()) {
            case 8: {
                s = "null";
                break;
            }
            case 11: {
                s = "void";
                break;
            }
            case 0: {
                s = "boolean";
                break;
            }
            case 1: {
                s = "byte";
                break;
            }
            case 2: {
                s = "char";
                break;
            }
            case 3: {
                s = "short";
                break;
            }
            case 4: {
                s = "int";
                break;
            }
            case 5: {
                s = "long";
                break;
            }
            case 6: {
                s = "float";
                break;
            }
            case 7: {
                s = "double";
                break;
            }
            case 13: {
                s = "<error>";
                if (this != tPackage) break;
                s = "<package>";
                break;
            }
            default: {
                s = "unknown";
            }
        }
        return id.length() > 0 ? s + " " + id : s;
    }

    public String typeString(String id) {
        return this.typeString(id, false, true);
    }

    public String toString() {
        return this.typeString("", false, true);
    }

    public String toStringValue(Object value) {
        return this.typeCode.toValueString(value);
    }
}

