/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.iiop;

import com.sun.corba.ee.impl.util.RepositoryId;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import org.glassfish.rmic.IndentingWriter;
import org.glassfish.rmic.Names;
import org.glassfish.rmic.iiop.BatchEnvironment;
import org.glassfish.rmic.iiop.Constants;
import org.glassfish.rmic.iiop.ContextElement;
import org.glassfish.rmic.iiop.ContextStack;
import org.glassfish.rmic.iiop.IDLNames;
import org.glassfish.rmic.tools.java.ClassNotFound;
import org.glassfish.rmic.tools.java.Identifier;

public abstract class Type
implements Constants,
ContextElement,
Cloneable {
    private int typeCode;
    private int fullTypeCode;
    private Identifier id;
    private String name;
    private String packageName;
    private String qualifiedName;
    private String idlName;
    private String[] idlModuleNames;
    private String qualifiedIDLName;
    private String repositoryID;
    private Class ourClass;
    private int status = 0;
    protected BatchEnvironment env;
    protected ContextStack stack;
    protected boolean destroyed = false;

    public String getName() {
        return this.name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public abstract String getSignature();

    public String getIDLName() {
        return this.idlName;
    }

    public String[] getIDLModuleNames() {
        return this.idlModuleNames;
    }

    public String getQualifiedIDLName(boolean global) {
        if (global && this.getIDLModuleNames().length > 0) {
            return "::" + this.qualifiedIDLName;
        }
        return this.qualifiedIDLName;
    }

    public Identifier getIdentifier() {
        return this.id;
    }

    public String getRepositoryID() {
        return this.repositoryID;
    }

    public String getBoxedRepositoryID() {
        return RepositoryId.createForJavaType((Class)this.ourClass);
    }

    public Class getClassInstance() {
        if (this.ourClass == null) {
            this.initClass();
        }
        return this.ourClass;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public BatchEnvironment getEnv() {
        return this.env;
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    public int getFullTypeCode() {
        return this.fullTypeCode;
    }

    public int getTypeCodeModifiers() {
        return this.fullTypeCode & 0xFF000000;
    }

    public boolean isType(int typeCodeMask) {
        return (this.fullTypeCode & typeCodeMask) == typeCodeMask;
    }

    public boolean typeMatches(int typeCodeMask) {
        return (this.fullTypeCode & typeCodeMask) > 0;
    }

    public int getRootTypeCode() {
        if (this.isArray()) {
            return this.getElementType().getFullTypeCode();
        }
        return this.fullTypeCode;
    }

    public boolean isInterface() {
        return (this.fullTypeCode & 0x8000000) == 0x8000000;
    }

    public boolean isClass() {
        return (this.fullTypeCode & 0x4000000) == 0x4000000;
    }

    public boolean isInner() {
        return (this.fullTypeCode & Integer.MIN_VALUE) == Integer.MIN_VALUE;
    }

    public boolean isSpecialInterface() {
        return (this.fullTypeCode & 0x20000000) == 0x20000000;
    }

    public boolean isSpecialClass() {
        return (this.fullTypeCode & 0x10000000) == 0x10000000;
    }

    public boolean isCompound() {
        return (this.fullTypeCode & 0x2000000) == 0x2000000;
    }

    public boolean isPrimitive() {
        return (this.fullTypeCode & 0x1000000) == 0x1000000;
    }

    public boolean isArray() {
        return (this.fullTypeCode & 0x40000) == 262144;
    }

    public boolean isConforming() {
        return (this.fullTypeCode & 0x40000000) == 0x40000000;
    }

    public String toString() {
        return this.getQualifiedName();
    }

    public Type getElementType() {
        return null;
    }

    public int getArrayDimension() {
        return 0;
    }

    public String getArrayBrackets() {
        return "";
    }

    public boolean equals(Object obj) {
        String us = this.toString();
        String them = ((Type)obj).toString();
        return us.equals(them);
    }

    public Type[] collectMatching(int typeCodeFilter) {
        return this.collectMatching(typeCodeFilter, new HashSet(this.env.allTypes.size()));
    }

    public Type[] collectMatching(int typeCodeFilter, HashSet alreadyChecked) {
        Vector matching = new Vector();
        this.addTypes(typeCodeFilter, alreadyChecked, matching);
        Object[] result = new Type[matching.size()];
        matching.copyInto(result);
        return result;
    }

    public abstract String getTypeDescription();

    public String getTypeName(boolean useQualifiedNames, boolean useIDLNames, boolean globalIDLNames) {
        if (useIDLNames) {
            if (useQualifiedNames) {
                return this.getQualifiedIDLName(globalIDLNames);
            }
            return this.getIDLName();
        }
        if (useQualifiedNames) {
            return this.getQualifiedName();
        }
        return this.getName();
    }

    public void print(IndentingWriter writer, int typeCodeFilter, boolean useQualifiedNames, boolean useIDLNames, boolean globalIDLNames) throws IOException {
        Type[] theTypes = this.collectMatching(typeCodeFilter);
        Type.print(writer, theTypes, useQualifiedNames, useIDLNames, globalIDLNames);
    }

    public static void print(IndentingWriter writer, Type[] theTypes, boolean useQualifiedNames, boolean useIDLNames, boolean globalIDLNames) throws IOException {
        for (int i = 0; i < theTypes.length; ++i) {
            theTypes[i].println(writer, useQualifiedNames, useIDLNames, globalIDLNames);
        }
    }

    public void print(IndentingWriter writer, boolean useQualifiedNames, boolean useIDLNames, boolean globalIDLNames) throws IOException {
        this.printTypeName(writer, useQualifiedNames, useIDLNames, globalIDLNames);
    }

    public void println(IndentingWriter writer, boolean useQualifiedNames, boolean useIDLNames, boolean globalIDLNames) throws IOException {
        this.print(writer, useQualifiedNames, useIDLNames, globalIDLNames);
        writer.pln();
    }

    public void printTypeName(IndentingWriter writer, boolean useQualifiedNames, boolean useIDLNames, boolean globalIDLNames) throws IOException {
        writer.p(this.getTypeName(useQualifiedNames, useIDLNames, globalIDLNames));
    }

    @Override
    public String getElementName() {
        return this.getQualifiedName();
    }

    protected void printPackageOpen(IndentingWriter writer, boolean useIDLNames) throws IOException {
        if (useIDLNames) {
            String[] moduleNames = this.getIDLModuleNames();
            for (int i = 0; i < moduleNames.length; ++i) {
                writer.plnI("module " + moduleNames[i] + " {");
            }
        } else {
            String packageName = this.getPackageName();
            if (packageName != null) {
                writer.pln("package " + packageName + ";");
            }
        }
    }

    protected static Type getType(org.glassfish.rmic.tools.java.Type key, ContextStack stack) {
        return Type.getType(key.toString(), stack);
    }

    protected static Type getType(String key, ContextStack stack) {
        Type result = (Type)stack.getEnv().allTypes.get(key);
        if (result != null) {
            stack.traceExistingType(result);
        }
        return result;
    }

    protected static void removeType(String key, ContextStack stack) {
        Type value = (Type)stack.getEnv().allTypes.remove(key);
        stack.getEnv().invalidTypes.put(value, key);
    }

    protected static void removeType(org.glassfish.rmic.tools.java.Type key, ContextStack stack) {
        String theKey = key.toString();
        Type old = (Type)stack.getEnv().allTypes.remove(theKey);
        Type.putInvalidType(old, theKey, stack);
    }

    protected static void putType(org.glassfish.rmic.tools.java.Type key, Type value, ContextStack stack) {
        stack.getEnv().allTypes.put(key.toString(), value);
    }

    protected static void putType(String key, Type value, ContextStack stack) {
        stack.getEnv().allTypes.put(key, value);
    }

    protected static void putInvalidType(Type key, String value, ContextStack stack) {
        stack.getEnv().invalidTypes.put(key, value);
    }

    public void removeInvalidTypes() {
        if (this.env.invalidTypes.size() > 0) {
            this.env.invalidTypes.clear();
        }
    }

    protected static void updateAllInvalidTypes(ContextStack stack) {
        BatchEnvironment env = stack.getEnv();
        if (env.invalidTypes.size() > 0) {
            Enumeration e = env.allTypes.elements();
            while (e.hasMoreElements()) {
                Type it = (Type)e.nextElement();
                it.swapInvalidTypes();
            }
            env.invalidTypes.clear();
        }
    }

    protected int countTypes() {
        return this.env.allTypes.size();
    }

    void resetTypes() {
        this.env.reset();
    }

    protected void destroy() {
        if (!this.destroyed) {
            this.id = null;
            this.name = null;
            this.packageName = null;
            this.qualifiedName = null;
            this.idlName = null;
            this.idlModuleNames = null;
            this.qualifiedIDLName = null;
            this.repositoryID = null;
            this.ourClass = null;
            this.env = null;
            this.stack = null;
            this.destroyed = true;
        }
    }

    protected void swapInvalidTypes() {
    }

    protected Type getValidType(Type invalidType) {
        if (invalidType.getStatus() == 1) {
            return invalidType;
        }
        String key = (String)this.env.invalidTypes.get(invalidType);
        Type result = null;
        if (key != null) {
            result = (Type)this.env.allTypes.get(key);
        }
        if (result == null) {
            throw new Error("Failed to find valid type to swap for " + invalidType + " mis-identified as " + invalidType.getTypeDescription());
        }
        return result;
    }

    protected void printPackageClose(IndentingWriter writer, boolean useIDLNames) throws IOException {
        if (useIDLNames) {
            String[] moduleNames = this.getIDLModuleNames();
            for (int i = 0; i < moduleNames.length; ++i) {
                writer.pOln("};");
            }
        }
    }

    protected Type(ContextStack stack, int fullTypeCode) {
        this.env = stack.getEnv();
        this.stack = stack;
        this.fullTypeCode = fullTypeCode;
        this.typeCode = fullTypeCode & 0xFFFFFF;
    }

    protected void setTypeCode(int fullTypeCode) {
        this.fullTypeCode = fullTypeCode;
        this.typeCode = fullTypeCode & 0xFFFFFF;
    }

    protected void setNames(Identifier id, String[] idlModuleNames, String idlName) {
        this.id = id;
        this.name = Names.mangleClass(id).getName().toString();
        this.packageName = null;
        if (id.isQualified()) {
            this.packageName = id.getQualifier().toString();
            this.qualifiedName = this.packageName + "." + this.name;
        } else {
            this.qualifiedName = this.name;
        }
        this.setIDLNames(idlModuleNames, idlName);
    }

    protected void setIDLNames(String[] idlModuleNames, String idlName) {
        this.idlName = idlName;
        this.idlModuleNames = idlModuleNames != null ? idlModuleNames : new String[0];
        this.qualifiedIDLName = IDLNames.getQualifiedName(idlModuleNames, idlName);
    }

    protected static void classNotFound(ContextStack stack, ClassNotFound e) {
        Type.classNotFound(false, stack, e);
    }

    protected static void classNotFound(boolean quiet, ContextStack stack, ClassNotFound e) {
        if (!quiet) {
            stack.getEnv().error(0L, "rmic.class.not.found", e.name);
        }
        stack.traceCallStack();
    }

    protected static boolean failedConstraint(int constraintNum, boolean quiet, ContextStack stack, Object arg0, Object arg1, Object arg2) {
        String message = "rmic.iiop.constraint." + constraintNum;
        if (!quiet) {
            stack.getEnv().error(0L, message, arg0 != null ? arg0.toString() : null, arg1 != null ? arg1.toString() : null, arg2 != null ? arg2.toString() : null);
        } else {
            String error = stack.getEnv().errorString(message, arg0, arg1, arg2);
            stack.traceln(error);
        }
        return false;
    }

    protected static boolean failedConstraint(int constraintNum, boolean quiet, ContextStack stack, Object arg0, Object arg1) {
        return Type.failedConstraint(constraintNum, quiet, stack, arg0, arg1, null);
    }

    protected static boolean failedConstraint(int constraintNum, boolean quiet, ContextStack stack, Object arg0) {
        return Type.failedConstraint(constraintNum, quiet, stack, arg0, null, null);
    }

    protected static boolean failedConstraint(int constraintNum, boolean quiet, ContextStack stack) {
        return Type.failedConstraint(constraintNum, quiet, stack, null, null, null);
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("clone failed");
        }
    }

    protected boolean addTypes(int typeCodeFilter, HashSet checked, Vector matching) {
        boolean result;
        if (checked.contains(this)) {
            result = false;
        } else {
            checked.add(this);
            if (this.typeMatches(typeCodeFilter)) {
                matching.addElement(this);
            }
            result = true;
        }
        return result;
    }

    protected abstract Class loadClass();

    private boolean initClass() {
        if (this.ourClass == null) {
            this.ourClass = this.loadClass();
            if (this.ourClass == null) {
                Type.failedConstraint(27, false, this.stack, this.getQualifiedName());
                return false;
            }
        }
        return true;
    }

    protected boolean setRepositoryID() {
        if (!this.initClass()) {
            return false;
        }
        this.repositoryID = RepositoryId.createForAnyType((Class)this.ourClass);
        return true;
    }

    private Type() {
    }
}

