/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.process;

import com.sun.enterprise.universal.StringUtils;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.OS;
import java.io.File;
import java.lang.management.ManagementFactory;

public final class ProcessUtils {
    private static final int pid;
    private static final String[] paths;

    private ProcessUtils() {
    }

    public static File getExe(String name) {
        for (String path : paths) {
            File f = new File(path + "/" + name);
            if (!f.canExecute()) continue;
            return SmartFile.sanitize(f);
        }
        return null;
    }

    public static final int getPid() {
        return pid;
    }

    static {
        int tempPid = -1;
        try {
            String pids = ManagementFactory.getRuntimeMXBean().getName();
            int index = -1;
            if (StringUtils.ok(pids) && (index = pids.indexOf(64)) >= 0) {
                tempPid = Integer.parseInt(pids.substring(0, index));
            }
        }
        catch (Exception e) {
            tempPid = -1;
        }
        pid = tempPid;
        String tempPaths = null;
        if (OS.isWindows()) {
            tempPaths = System.getenv("Path");
            if (!StringUtils.ok(tempPaths)) {
                tempPaths = System.getenv("PATH");
            }
        } else {
            tempPaths = System.getenv("PATH");
        }
        paths = StringUtils.ok(tempPaths) ? tempPaths.split(File.pathSeparator) : new String[0];
    }
}

