/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.engine;

import java.security.AccessController;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.MessageInterpolator;
import org.hibernate.validator.util.GetClassLoader;
import org.hibernate.validator.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceBundleMessageInterpolator
implements MessageInterpolator {
    private static final String DEFAULT_VALIDATION_MESSAGES = "org.hibernate.validator.ValidationMessages";
    private static final String USER_VALIDATION_MESSAGES = "ValidationMessages";
    private static final Logger log = LoggerFactory.make();
    private static final Pattern messageParameterPattern = Pattern.compile("(\\{[^\\}]+?\\})");
    private final Locale defaultLocale;
    private final Map<Locale, ResourceBundle> userBundlesMap = new ConcurrentHashMap<Locale, ResourceBundle>();
    private final Map<Locale, ResourceBundle> defaultBundlesMap = new ConcurrentHashMap<Locale, ResourceBundle>();
    private final Map<LocalisedMessage, String> resolvedMessages = new WeakHashMap<LocalisedMessage, String>();

    public ResourceBundleMessageInterpolator() {
        this(null);
    }

    public ResourceBundleMessageInterpolator(ResourceBundle resourceBundle) {
        this.defaultLocale = Locale.getDefault();
        if (resourceBundle == null) {
            ResourceBundle bundle = this.getFileBasedResourceBundle(this.defaultLocale);
            if (bundle != null) {
                this.userBundlesMap.put(this.defaultLocale, bundle);
            }
        } else {
            this.userBundlesMap.put(this.defaultLocale, resourceBundle);
        }
        this.defaultBundlesMap.put(this.defaultLocale, ResourceBundle.getBundle(DEFAULT_VALIDATION_MESSAGES, this.defaultLocale));
    }

    @Override
    public String interpolate(String message, MessageInterpolator.Context context) {
        return this.interpolateMessage(message, context.getConstraintDescriptor().getAttributes(), this.defaultLocale);
    }

    @Override
    public String interpolate(String message, MessageInterpolator.Context context, Locale locale) {
        return this.interpolateMessage(message, context.getConstraintDescriptor().getAttributes(), locale);
    }

    private String interpolateMessage(String message, Map<String, Object> annotationParameters, Locale locale) {
        LocalisedMessage localisedMessage = new LocalisedMessage(message, locale);
        String resolvedMessage = this.resolvedMessages.get(localisedMessage);
        if (resolvedMessage == null) {
            ResourceBundle userResourceBundle = this.findUserResourceBundle(locale);
            ResourceBundle defaultResourceBundle = this.findDefaultResourceBundle(locale);
            resolvedMessage = message;
            boolean evaluatedDefaultBundleOnce = false;
            while (true) {
                String userBundleResolvedMessage = this.replaceVariables(resolvedMessage, userResourceBundle, locale, true);
                if (evaluatedDefaultBundleOnce && !this.hasReplacementTakenPlace(userBundleResolvedMessage, resolvedMessage)) break;
                resolvedMessage = this.replaceVariables(userBundleResolvedMessage, defaultResourceBundle, locale, false);
                evaluatedDefaultBundleOnce = true;
                this.resolvedMessages.put(localisedMessage, resolvedMessage);
            }
        }
        resolvedMessage = this.replaceAnnotationAttributes(resolvedMessage, annotationParameters);
        resolvedMessage = resolvedMessage.replace("\\{", "{");
        resolvedMessage = resolvedMessage.replace("\\}", "}");
        resolvedMessage = resolvedMessage.replace("\\\\", "\\");
        return resolvedMessage;
    }

    private boolean hasReplacementTakenPlace(String origMessage, String newMessage) {
        return !origMessage.equals(newMessage);
    }

    private ResourceBundle getFileBasedResourceBundle(Locale locale) {
        ClassLoader classLoader;
        ResourceBundle rb = null;
        boolean isSecured = System.getSecurityManager() != null;
        GetClassLoader action = GetClassLoader.fromContext();
        ClassLoader classLoader2 = classLoader = isSecured ? AccessController.doPrivileged(action) : action.run();
        if (classLoader != null) {
            rb = this.loadBundle(classLoader, locale, "ValidationMessages not found by thread local classloader");
        }
        if (rb == null) {
            action = GetClassLoader.fromClass(ResourceBundleMessageInterpolator.class);
            classLoader = isSecured ? AccessController.doPrivileged(action) : action.run();
            rb = this.loadBundle(classLoader, locale, "ValidationMessages not found by validator classloader");
        }
        if (log.isDebugEnabled()) {
            if (rb != null) {
                log.debug("ValidationMessages found");
            } else {
                log.debug("ValidationMessages not found. Delegating to org.hibernate.validator.ValidationMessages");
            }
        }
        return rb;
    }

    private ResourceBundle loadBundle(ClassLoader classLoader, Locale locale, String message) {
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle(USER_VALIDATION_MESSAGES, locale, classLoader);
        }
        catch (MissingResourceException e) {
            log.trace(message);
        }
        return rb;
    }

    private String replaceVariables(String message, ResourceBundle bundle, Locale locale, boolean recurse) {
        Matcher matcher = messageParameterPattern.matcher(message);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String parameter = matcher.group(1);
            String resolvedParameterValue = this.resolveParameter(parameter, bundle, locale, recurse);
            matcher.appendReplacement(sb, this.escapeMetaCharacters(resolvedParameterValue));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String replaceAnnotationAttributes(String message, Map<String, Object> annotationParameters) {
        Matcher matcher = messageParameterPattern.matcher(message);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String parameter = matcher.group(1);
            Object variable = annotationParameters.get(this.removeCurlyBrace(parameter));
            String resolvedParameterValue = variable != null ? this.escapeMetaCharacters(variable.toString()) : parameter;
            matcher.appendReplacement(sb, resolvedParameterValue);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String resolveParameter(String parameterName, ResourceBundle bundle, Locale locale, boolean recurse) {
        String parameterValue;
        try {
            if (bundle != null) {
                parameterValue = bundle.getString(this.removeCurlyBrace(parameterName));
                if (recurse) {
                    parameterValue = this.replaceVariables(parameterValue, bundle, locale, recurse);
                }
            } else {
                parameterValue = parameterName;
            }
        }
        catch (MissingResourceException e) {
            parameterValue = parameterName;
        }
        return parameterValue;
    }

    private String removeCurlyBrace(String parameter) {
        return parameter.substring(1, parameter.length() - 1);
    }

    private ResourceBundle findDefaultResourceBundle(Locale locale) {
        if (this.defaultBundlesMap.containsKey(locale)) {
            return this.defaultBundlesMap.get(locale);
        }
        ResourceBundle bundle = ResourceBundle.getBundle(DEFAULT_VALIDATION_MESSAGES, locale);
        this.defaultBundlesMap.put(locale, bundle);
        return bundle;
    }

    private ResourceBundle findUserResourceBundle(Locale locale) {
        if (this.userBundlesMap.containsKey(locale)) {
            return this.userBundlesMap.get(locale);
        }
        ResourceBundle bundle = this.getFileBasedResourceBundle(locale);
        if (bundle != null) {
            this.userBundlesMap.put(locale, bundle);
        }
        return bundle;
    }

    private String escapeMetaCharacters(String s) {
        String escapedString = s.replace("\\", "\\\\");
        escapedString = escapedString.replace("$", "\\$");
        return escapedString;
    }

    private static class LocalisedMessage {
        private final String message;
        private final Locale locale;

        LocalisedMessage(String message, Locale locale) {
            this.message = message;
            this.locale = locale;
        }

        public String getMessage() {
            return this.message;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocalisedMessage that = (LocalisedMessage)o;
            if (this.locale != null ? !this.locale.equals(that.locale) : that.locale != null) {
                return false;
            }
            return !(this.message != null ? !this.message.equals(that.message) : that.message != null);
        }

        public int hashCode() {
            int result = this.message != null ? this.message.hashCode() : 0;
            result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
            return result;
        }
    }
}

