/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api.models;

import java.io.Serializable;
import java.util.List;
import org.gitlab4j.api.models.AccessLevel;
import org.gitlab4j.api.models.Visibility;
import org.gitlab4j.models.Constants;
import org.gitlab4j.models.GitLabForm;
import org.gitlab4j.models.utils.JacksonJson;

public class SharedGroupsFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<Long> skipGroups;
    private String search;
    private Constants.GroupOrderBy orderBy;
    private Constants.SortOrder sort;
    private Visibility visibility;
    private AccessLevel minAccessLevel;
    private Boolean withCustomAttributes;

    public SharedGroupsFilter withSkipGroups(List<Long> skipGroups) {
        this.skipGroups = skipGroups;
        return this;
    }

    public SharedGroupsFilter withSearch(String search) {
        this.search = search;
        return this;
    }

    public SharedGroupsFilter withOrderBy(Constants.GroupOrderBy orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public SharedGroupsFilter withSortOder(Constants.SortOrder sort) {
        this.sort = sort;
        return this;
    }

    public SharedGroupsFilter withVisibility(Visibility visibility) {
        this.visibility = visibility;
        return this;
    }

    public SharedGroupsFilter withMinAccessLevel(AccessLevel minAccessLevel) {
        this.minAccessLevel = minAccessLevel;
        return this;
    }

    public SharedGroupsFilter withCustomAttributes(Boolean withCustomAttributes) {
        this.withCustomAttributes = withCustomAttributes;
        return this;
    }

    public GitLabForm getQueryParams() {
        return new GitLabForm().withParam("skip_groups", this.skipGroups).withParam("search", this.search).withParam("order_by", (Object)this.orderBy).withParam("sort", (Object)this.sort).withParam("visibility", (Object)this.visibility).withParam("simple", this.minAccessLevel).withParam("with_custom_attributes", this.withCustomAttributes);
    }

    public String toString() {
        return JacksonJson.toJsonString(this);
    }
}

