/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Base64;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.utils.JacksonJson;

public class RepositoryFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String fileName;
    private String filePath;
    private Integer size;
    private Constants.Encoding encoding;
    private String content;
    private String contentSha256;
    private String ref;
    private String blobId;
    private String commitId;
    private String lastCommitId;

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public Constants.Encoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Constants.Encoding encoding) {
        this.encoding = encoding;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContentSha256() {
        return this.contentSha256;
    }

    public void setContentSha256(String contentSha256) {
        this.contentSha256 = contentSha256;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getBlobId() {
        return this.blobId;
    }

    public void setBlobId(String blobId) {
        this.blobId = blobId;
    }

    public String getCommitId() {
        return this.commitId;
    }

    public void setCommitId(String commitId) {
        this.commitId = commitId;
    }

    public String getLastCommitId() {
        return this.lastCommitId;
    }

    public void setLastCommitId(String lastCommitId) {
        this.lastCommitId = lastCommitId;
    }

    @JsonIgnore
    public String getDecodedContentAsString() {
        if (this.content == null) {
            return null;
        }
        if (Constants.Encoding.BASE64.equals((Object)this.encoding)) {
            return new String(Base64.getDecoder().decode(this.content));
        }
        return this.content;
    }

    @JsonIgnore
    public byte[] getDecodedContentAsBytes() {
        if (this.content == null) {
            return null;
        }
        if (this.encoding == Constants.Encoding.BASE64) {
            return Base64.getDecoder().decode(this.content);
        }
        return this.content.getBytes();
    }

    @JsonIgnore
    public void encodeAndSetContent(String content) {
        this.encodeAndSetContent(content != null ? content.getBytes() : null);
    }

    @JsonIgnore
    public void encodeAndSetContent(byte[] byteContent) {
        if (byteContent == null) {
            this.content = null;
            return;
        }
        this.content = Base64.getEncoder().encodeToString(byteContent);
        this.encoding = Constants.Encoding.BASE64;
    }

    public String toString() {
        return JacksonJson.toJsonString(this);
    }
}

