/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Comment;
import org.gitlab4j.api.models.Commit;
import org.gitlab4j.api.models.CommitAction;
import org.gitlab4j.api.models.CommitPayload;
import org.gitlab4j.api.models.CommitRef;
import org.gitlab4j.api.models.CommitStatus;
import org.gitlab4j.api.models.CommitStatusFilter;
import org.gitlab4j.api.models.Diff;
import org.gitlab4j.api.models.GpgSignature;
import org.gitlab4j.api.models.MergeRequest;
import org.gitlab4j.api.utils.ISO8601;

public class CommitsApi
extends AbstractApi {
    public CommitsApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Commit> getCommits(Object projectIdOrPath) throws GitLabApiException {
        return this.getCommits(projectIdOrPath, null, null, null, null, true, null, null, this.getDefaultPerPage()).all();
    }

    @Deprecated
    public List<Commit> getCommits(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        return this.getCommits(projectIdOrPath, null, null, null, page, perPage);
    }

    public Pager<Commit> getCommits(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return this.getCommits(projectIdOrPath, null, null, null, null, true, null, null, itemsPerPage);
    }

    public Stream<Commit> getCommitStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getCommits(projectIdOrPath, null, null, null, null, true, null, null, this.getDefaultPerPage()).stream();
    }

    public List<Commit> getCommits(Object projectIdOrPath, String ref, Date since, Date until, String path) throws GitLabApiException {
        return this.getCommits(projectIdOrPath, ref, since, until, path, null, null, null, this.getDefaultPerPage()).all();
    }

    public List<Commit> getCommits(Object projectIdOrPath, String ref, String path) throws GitLabApiException {
        return this.getCommits(projectIdOrPath, ref, null, null, path, null, null, null, this.getDefaultPerPage()).all();
    }

    public List<Commit> getCommits(Object projectIdOrPath, String ref, Date since, Date until) throws GitLabApiException {
        return this.getCommits(projectIdOrPath, ref, since, until, null, null, null, null, this.getDefaultPerPage()).all();
    }

    @Deprecated
    public List<Commit> getCommits(Object projectIdOrPath, String ref, Date since, Date until, int page, int perPage) throws GitLabApiException {
        return this.getCommits(projectIdOrPath, ref, since, until, null, page, perPage);
    }

    public Stream<Commit> getCommitsStream(Object projectIdOrPath, String ref, Date since, Date until) throws GitLabApiException {
        return this.getCommits(projectIdOrPath, ref, since, until, null, null, null, null, this.getDefaultPerPage()).stream();
    }

    public Stream<Commit> getCommitsStream(Object projectIdOrPath, String ref, Date since, Date until, String path) throws GitLabApiException {
        return this.getCommits(projectIdOrPath, ref, since, until, path, null, null, null, this.getDefaultPerPage()).stream();
    }

    @Deprecated
    public List<Commit> getCommits(Object projectIdOrPath, String ref, Date since, Date until, String path, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("ref_name", ref).withParam("since", ISO8601.toString(since, false)).withParam("until", ISO8601.toString(until, false)).withParam("path", path == null ? null : this.urlEncode(path)).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "commits");
        return (List)response.readEntity((GenericType)new GenericType<List<Commit>>(){});
    }

    public Pager<Commit> getCommits(Object projectIdOrPath, String ref, Date since, Date until, int itemsPerPage) throws GitLabApiException {
        return this.getCommits(projectIdOrPath, ref, since, until, null, null, null, null, itemsPerPage);
    }

    public Pager<Commit> getCommits(Object projectIdOrPath, String ref, Date since, Date until, String path, int itemsPerPage) throws GitLabApiException {
        return this.getCommits(projectIdOrPath, ref, since, until, path, null, null, null, itemsPerPage);
    }

    public List<Commit> getCommits(Object projectIdOrPath, String ref, Date since, Date until, String path, Boolean all, Boolean withStats, Boolean firstParent) throws GitLabApiException {
        return this.getCommits(projectIdOrPath, ref, since, until, path, all, withStats, firstParent, this.getDefaultPerPage()).all();
    }

    public Pager<Commit> getCommits(Object projectIdOrPath, String ref, Date since, Date until, String path, Boolean all, Boolean withStats, Boolean firstParent, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("ref_name", ref).withParam("since", ISO8601.toString(since, false)).withParam("until", ISO8601.toString(until, false)).withParam("path", path == null ? null : this.urlEncode(path)).withParam("all", all).withParam("with_stats", withStats).withParam("first_parent", firstParent);
        return new Pager<Commit>(this, Commit.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "commits");
    }

    public Stream<Commit> getCommitsStream(Object projectIdOrPath, String ref, Date since, Date until, String path, Boolean all, Boolean withStats, Boolean firstParent) throws GitLabApiException {
        return this.getCommits(projectIdOrPath, ref, since, until, path, all, withStats, firstParent, this.getDefaultPerPage()).stream();
    }

    public Commit getCommit(Object projectIdOrPath, String sha) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "commits", this.urlEncode(sha));
        return (Commit)response.readEntity(Commit.class);
    }

    public Optional<Commit> getOptionalCommit(Object projectIdOrPath, String sha) {
        try {
            return Optional.ofNullable(this.getCommit(projectIdOrPath, sha));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public List<CommitRef> getCommitRefs(Object projectIdOrPath, String sha) throws GitLabApiException {
        return this.getCommitRefs(projectIdOrPath, sha, CommitRef.RefType.ALL, this.getDefaultPerPage()).all();
    }

    public Pager<CommitRef> getCommitRefs(Object projectIdOrPath, String sha, int itemsPerPage) throws GitLabApiException {
        return this.getCommitRefs(projectIdOrPath, sha, CommitRef.RefType.ALL, itemsPerPage);
    }

    public Stream<CommitRef> getCommitRefsStream(Object projectIdOrPath, String sha) throws GitLabApiException {
        return this.getCommitRefs(projectIdOrPath, sha, CommitRef.RefType.ALL, this.getDefaultPerPage()).stream();
    }

    public List<CommitRef> getCommitRefs(Object projectIdOrPath, String sha, CommitRef.RefType refType) throws GitLabApiException {
        return this.getCommitRefs(projectIdOrPath, sha, refType, this.getDefaultPerPage()).all();
    }

    public Pager<CommitRef> getCommitRefs(Object projectIdOrPath, String sha, CommitRef.RefType refType, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm form = new GitLabApiForm().withParam("type", (Object)refType);
        return new Pager<CommitRef>(this, CommitRef.class, itemsPerPage, (MultivaluedMap<String, String>)form.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "commits", this.urlEncode(sha), "refs");
    }

    public Stream<CommitRef> getCommitRefsStream(Object projectIdOrPath, String sha, CommitRef.RefType refType) throws GitLabApiException {
        return this.getCommitRefs(projectIdOrPath, sha, refType, this.getDefaultPerPage()).stream();
    }

    public List<CommitStatus> getCommitStatuses(Object projectIdOrPath, String sha, CommitStatusFilter filter) throws GitLabApiException {
        return this.getCommitStatuses(projectIdOrPath, sha, filter, this.getDefaultPerPage()).all();
    }

    public List<CommitStatus> getCommitStatuses(Object projectIdOrPath, String sha, CommitStatusFilter filter, int page, int perPage) throws GitLabApiException {
        if (projectIdOrPath == null) {
            throw new RuntimeException("projectIdOrPath cannot be null");
        }
        if (sha == null || sha.trim().isEmpty()) {
            throw new RuntimeException("sha cannot be null");
        }
        MultivaluedMap queryParams = filter != null ? filter.getQueryParams(page, perPage).asMap() : this.getPageQueryParams(page, perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)queryParams, "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "commits", sha, "statuses");
        return (List)response.readEntity((GenericType)new GenericType<List<CommitStatus>>(){});
    }

    public Pager<CommitStatus> getCommitStatuses(Object projectIdOrPath, String sha, CommitStatusFilter filter, int itemsPerPage) throws GitLabApiException {
        if (projectIdOrPath == null) {
            throw new RuntimeException("projectIdOrPath cannot be null");
        }
        if (sha == null || sha.trim().isEmpty()) {
            throw new RuntimeException("sha cannot be null");
        }
        MultivaluedMap queryParams = filter != null ? filter.getQueryParams().asMap() : null;
        return new Pager<CommitStatus>(this, CommitStatus.class, itemsPerPage, (MultivaluedMap<String, String>)queryParams, "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "commits", sha, "statuses");
    }

    public Stream<CommitStatus> getCommitStatusesStream(Object projectIdOrPath, String sha, CommitStatusFilter filter) throws GitLabApiException {
        return this.getCommitStatuses(projectIdOrPath, sha, filter, this.getDefaultPerPage()).stream();
    }

    public CommitStatus addCommitStatus(Object projectIdOrPath, String sha, Constants.CommitBuildState state, CommitStatus status) throws GitLabApiException {
        if (projectIdOrPath == null) {
            throw new RuntimeException("projectIdOrPath cannot be null");
        }
        if (sha == null || sha.trim().isEmpty()) {
            throw new RuntimeException("sha cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("state", (Object)state, true);
        if (status != null) {
            formData.withParam("ref", status.getRef()).withParam("name", status.getName()).withParam("target_url", status.getTargetUrl()).withParam("description", status.getDescription()).withParam("coverage", status.getCoverage()).withParam("pipeline_id", status.getPipelineId());
        }
        Response response = this.post(Response.Status.OK, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "statuses", sha});
        return (CommitStatus)response.readEntity(CommitStatus.class);
    }

    public List<Diff> getDiff(Object projectIdOrPath, String sha) throws GitLabApiException {
        return this.getDiff(projectIdOrPath, sha, this.getDefaultPerPage()).all();
    }

    public Pager<Diff> getDiff(Object projectIdOrPath, String sha, int itemsPerPage) throws GitLabApiException {
        if (projectIdOrPath == null) {
            throw new RuntimeException("projectIdOrPath cannot be null");
        }
        if (sha == null || sha.trim().isEmpty()) {
            throw new RuntimeException("sha cannot be null");
        }
        return new Pager<Diff>(this, Diff.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "commits", sha, "diff");
    }

    public Stream<Diff> getDiffStream(Object projectIdOrPath, String sha) throws GitLabApiException {
        return this.getDiff(projectIdOrPath, sha, this.getDefaultPerPage()).stream();
    }

    public List<Comment> getComments(Object projectIdOrPath, String sha) throws GitLabApiException {
        return this.getComments(projectIdOrPath, sha, this.getDefaultPerPage()).all();
    }

    public Pager<Comment> getComments(Object projectIdOrPath, String sha, int itemsPerPage) throws GitLabApiException {
        return new Pager<Comment>(this, Comment.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "commits", sha, "comments");
    }

    public Stream<Comment> getCommentsStream(Object projectIdOrPath, String sha) throws GitLabApiException {
        return this.getComments(projectIdOrPath, sha, this.getDefaultPerPage()).stream();
    }

    public Comment addComment(Object projectIdOrPath, String sha, String note, String path, Integer line, Constants.LineType lineType) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("note", note, true).withParam("path", path).withParam("line", line).withParam("line_type", (Object)lineType);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "commits", sha, "comments"});
        return (Comment)response.readEntity(Comment.class);
    }

    public Comment addComment(Object projectIdOrPath, String sha, String note) throws GitLabApiException {
        return this.addComment(projectIdOrPath, sha, note, null, null, null);
    }

    public Commit createCommit(Object projectIdOrPath, String branch, String commitMessage, String startBranch, String authorEmail, String authorName, CommitAction action) throws GitLabApiException {
        if (action == null) {
            throw new GitLabApiException("action cannot be null or empty.");
        }
        return this.createCommit(projectIdOrPath, branch, commitMessage, startBranch, authorEmail, authorName, Arrays.asList(action));
    }

    public Commit createCommit(Object projectIdOrPath, String branch, String commitMessage, String startBranch, String authorEmail, String authorName, List<CommitAction> actions) throws GitLabApiException {
        CommitPayload payload = new CommitPayload().withBranch(branch).withStartBranch(startBranch).withCommitMessage(commitMessage).withAuthorEmail(authorEmail).withAuthorName(authorName).withActions(actions);
        return this.createCommit(projectIdOrPath, payload);
    }

    public Commit createCommit(Object projectIdOrPath, CommitPayload payload) throws GitLabApiException {
        List<CommitAction> actions = payload.getActions();
        if (actions == null || actions.isEmpty()) {
            throw new GitLabApiException("actions cannot be null or empty.");
        }
        for (CommitAction action : actions) {
            String content;
            CommitAction.Action actionType = action.getAction();
            if (actionType != CommitAction.Action.CREATE && actionType != CommitAction.Action.UPDATE || (content = action.getContent()) != null) continue;
            throw new GitLabApiException("Content cannot be null for create or update actions.");
        }
        if (payload.getStartProject() != null) {
            payload.setStartProject(this.getProjectIdOrPath(payload.getStartProject()));
        }
        Response response = this.post(Response.Status.CREATED, payload, "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "commits");
        return (Commit)response.readEntity(Commit.class);
    }

    public Commit revertCommit(Object projectIdOrPath, String sha, String branch) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("branch", branch, true);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "commits", sha, "revert"});
        return (Commit)response.readEntity(Commit.class);
    }

    public Commit cherryPickCommit(Object projectIdOrPath, String sha, String branch) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("branch", branch, true);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "commits", sha, "cherry_pick"});
        return (Commit)response.readEntity(Commit.class);
    }

    public List<MergeRequest> getMergeRequests(Object projectIdOrPath, String sha) throws GitLabApiException {
        return this.getMergeRequests(projectIdOrPath, sha, this.getDefaultPerPage()).all();
    }

    public Pager<MergeRequest> getMergeRequests(Object projectIdOrPath, String sha, int itemsPerPage) throws GitLabApiException {
        return new Pager<MergeRequest>(this, MergeRequest.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "commits", this.urlEncode(sha), "merge_requests");
    }

    public Stream<MergeRequest> getMergeRequestsStream(Object projectIdOrPath, String sha) throws GitLabApiException {
        return this.getMergeRequests(projectIdOrPath, sha, this.getDefaultPerPage()).stream();
    }

    public GpgSignature getGpgSignature(Object projectIdOrPath, String sha) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "commits", this.urlEncode(sha), "signature");
        return (GpgSignature)response.readEntity(GpgSignature.class);
    }

    public Optional<GpgSignature> getOptionalGpgSignature(Object projectIdOrPath, String sha) {
        try {
            return Optional.ofNullable(this.getGpgSignature(projectIdOrPath, sha));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }
}

