/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiClient;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.models.Group;
import org.gitlab4j.api.models.Label;
import org.gitlab4j.api.models.Project;
import org.gitlab4j.api.models.User;
import org.gitlab4j.api.utils.UrlEncoder;

public abstract class AbstractApi
implements Constants {
    protected final GitLabApi gitLabApi;

    public AbstractApi(GitLabApi gitLabApi) {
        this.gitLabApi = gitLabApi;
    }

    public Object getProjectIdOrPath(Object obj) throws GitLabApiException {
        if (obj == null) {
            throw new RuntimeException("Cannot determine ID or path from null object");
        }
        if (obj instanceof Long) {
            return obj;
        }
        if (obj instanceof String) {
            return this.urlEncode(((String)obj).trim());
        }
        if (obj instanceof Project) {
            Long id = ((Project)obj).getId();
            if (id != null && id > 0L) {
                return id;
            }
            String path = ((Project)obj).getPathWithNamespace();
            if (path != null && path.trim().length() > 0) {
                return this.urlEncode(path.trim());
            }
            throw new RuntimeException("Cannot determine ID or path from provided Project instance");
        }
        throw new RuntimeException("Cannot determine ID or path from provided " + obj.getClass().getSimpleName() + " instance, must be Long, String, or a Project instance");
    }

    public Object getGroupIdOrPath(Object obj) throws GitLabApiException {
        if (obj == null) {
            throw new RuntimeException("Cannot determine ID or path from null object");
        }
        if (obj instanceof Long) {
            return obj;
        }
        if (obj instanceof String) {
            return this.urlEncode(((String)obj).trim());
        }
        if (obj instanceof Group) {
            Long id = ((Group)obj).getId();
            if (id != null && id > 0L) {
                return id;
            }
            String path = ((Group)obj).getFullPath();
            if (path != null && path.trim().length() > 0) {
                return this.urlEncode(path.trim());
            }
            throw new RuntimeException("Cannot determine ID or path from provided Group instance");
        }
        throw new RuntimeException("Cannot determine ID or path from provided " + obj.getClass().getSimpleName() + " instance, must be Long, String, or a Group instance");
    }

    public Object getUserIdOrUsername(Object obj) throws GitLabApiException {
        if (obj == null) {
            throw new RuntimeException("Cannot determine ID or username from null object");
        }
        if (obj instanceof Long) {
            return obj;
        }
        if (obj instanceof String) {
            return this.urlEncode(((String)obj).trim());
        }
        if (obj instanceof User) {
            Long id = ((User)obj).getId();
            if (id != null && id > 0L) {
                return id;
            }
            String username = ((User)obj).getUsername();
            if (username != null && username.trim().length() > 0) {
                return this.urlEncode(username.trim());
            }
            throw new RuntimeException("Cannot determine ID or username from provided User instance");
        }
        throw new RuntimeException("Cannot determine ID or username from provided " + obj.getClass().getSimpleName() + " instance, must be Long, String, or a User instance");
    }

    public Object getLabelIdOrName(Object obj) throws GitLabApiException {
        if (obj == null) {
            throw new RuntimeException("Cannot determine ID or name from null object");
        }
        if (obj instanceof Long) {
            return obj;
        }
        if (obj instanceof String) {
            return this.urlEncode(((String)obj).trim());
        }
        if (obj instanceof Label) {
            Long id = ((Label)obj).getId();
            if (id != null && id > 0L) {
                return id;
            }
            String name = ((Label)obj).getName();
            if (name != null && name.trim().length() > 0) {
                return this.urlEncode(name.trim());
            }
            throw new RuntimeException("Cannot determine ID or name from provided Label instance");
        }
        throw new RuntimeException("Cannot determine ID or name from provided " + obj.getClass().getSimpleName() + " instance, must be Long, String, or a Label instance");
    }

    protected GitLabApi.ApiVersion getApiVersion() {
        return this.gitLabApi.getApiVersion();
    }

    protected boolean isApiVersion(GitLabApi.ApiVersion apiVersion) {
        return this.gitLabApi.getApiVersion() == apiVersion;
    }

    protected int getDefaultPerPage() {
        return this.gitLabApi.getDefaultPerPage();
    }

    protected GitLabApiClient getApiClient() {
        return this.gitLabApi.getApiClient();
    }

    protected String urlEncode(String s) throws GitLabApiException {
        return UrlEncoder.urlEncode(s);
    }

    protected Response get(Response.Status expectedStatus, MultivaluedMap<String, String> queryParams, Object ... pathArgs) throws GitLabApiException {
        try {
            return this.validate(this.getApiClient().get(queryParams, pathArgs), expectedStatus);
        }
        catch (Exception e) {
            throw this.handle(e);
        }
    }

    protected Response getWithAccepts(Response.Status expectedStatus, MultivaluedMap<String, String> queryParams, String accepts, Object ... pathArgs) throws GitLabApiException {
        try {
            return this.validate(this.getApiClient().getWithAccepts(queryParams, accepts, pathArgs), expectedStatus);
        }
        catch (Exception e) {
            throw this.handle(e);
        }
    }

    protected Response get(Response.Status expectedStatus, MultivaluedMap<String, String> queryParams, URL url) throws GitLabApiException {
        try {
            return this.validate(this.getApiClient().get(queryParams, url), expectedStatus);
        }
        catch (Exception e) {
            throw this.handle(e);
        }
    }

    protected Response head(Response.Status expectedStatus, MultivaluedMap<String, String> queryParams, Object ... pathArgs) throws GitLabApiException {
        try {
            return this.validate(this.getApiClient().head(queryParams, pathArgs), expectedStatus);
        }
        catch (Exception e) {
            throw this.handle(e);
        }
    }

    protected Response patch(Response.Status expectedStatus, MultivaluedMap<String, String> queryParams, Object ... pathArgs) throws GitLabApiException {
        try {
            return this.validate(this.getApiClient().patch(queryParams, pathArgs), expectedStatus);
        }
        catch (Exception e) {
            throw this.handle(e);
        }
    }

    protected Response patch(Response.Status expectedStatus, MultivaluedMap<String, String> queryParams, URL url) throws GitLabApiException {
        try {
            return this.validate(this.getApiClient().patch(queryParams, url), expectedStatus);
        }
        catch (Exception e) {
            throw this.handle(e);
        }
    }

    protected Response post(Response.Status expectedStatus, Form formData, Object ... pathArgs) throws GitLabApiException {
        try {
            return this.validate(this.getApiClient().post(formData, pathArgs), expectedStatus);
        }
        catch (Exception e) {
            throw this.handle(e);
        }
    }

    protected Response post(Response.Status expectedStatus, Object payload, Object ... pathArgs) throws GitLabApiException {
        try {
            return this.validate(this.getApiClient().post(payload, pathArgs), expectedStatus);
        }
        catch (Exception e) {
            throw this.handle(e);
        }
    }

    protected Response post(Response.Status expectedStatus, StreamingOutput stream, String mediaType, Object ... pathArgs) throws GitLabApiException {
        try {
            return this.validate(this.getApiClient().post(stream, mediaType, pathArgs), expectedStatus);
        }
        catch (Exception e) {
            throw this.handle(e);
        }
    }

    protected Response post(Response.Status expectedStatus, MultivaluedMap<String, String> queryParams, Object ... pathArgs) throws GitLabApiException {
        try {
            return this.validate(this.getApiClient().post(queryParams, pathArgs), expectedStatus);
        }
        catch (Exception e) {
            throw this.handle(e);
        }
    }

    protected Response post(Response.Status expectedStatus, Form formData, URL url) throws GitLabApiException {
        try {
            return this.validate(this.getApiClient().post(formData, url), expectedStatus);
        }
        catch (Exception e) {
            throw this.handle(e);
        }
    }

    protected Response upload(Response.Status expectedStatus, String name, File fileToUpload, String mediaType, Object ... pathArgs) throws GitLabApiException {
        try {
            return this.validate(this.getApiClient().upload(name, fileToUpload, mediaType, pathArgs), expectedStatus);
        }
        catch (Exception e) {
            throw this.handle(e);
        }
    }

    protected Response upload(Response.Status expectedStatus, String name, InputStream inputStream, String filename, String mediaType, Object ... pathArgs) throws GitLabApiException {
        try {
            return this.validate(this.getApiClient().upload(name, inputStream, filename, mediaType, pathArgs), expectedStatus);
        }
        catch (Exception e) {
            throw this.handle(e);
        }
    }

    protected Response upload(Response.Status expectedStatus, String name, File fileToUpload, String mediaType, URL url) throws GitLabApiException {
        try {
            return this.validate(this.getApiClient().upload(name, fileToUpload, mediaType, url), expectedStatus);
        }
        catch (Exception e) {
            throw this.handle(e);
        }
    }

    protected Response upload(Response.Status expectedStatus, String name, File fileToUpload, String mediaType, Form formData, URL url) throws GitLabApiException {
        try {
            return this.validate(this.getApiClient().upload(name, fileToUpload, mediaType, formData, url), expectedStatus);
        }
        catch (Exception e) {
            throw this.handle(e);
        }
    }

    protected Response put(Response.Status expectedStatus, MultivaluedMap<String, String> queryParams, Object ... pathArgs) throws GitLabApiException {
        try {
            return this.validate(this.getApiClient().put(queryParams, pathArgs), expectedStatus);
        }
        catch (Exception e) {
            throw this.handle(e);
        }
    }

    protected Response put(Response.Status expectedStatus, MultivaluedMap<String, String> queryParams, URL url) throws GitLabApiException {
        try {
            return this.validate(this.getApiClient().put(queryParams, url), expectedStatus);
        }
        catch (Exception e) {
            throw this.handle(e);
        }
    }

    protected Response put(Response.Status expectedStatus, Object payload, Object ... pathArgs) throws GitLabApiException {
        try {
            return this.validate(this.getApiClient().put(payload, pathArgs), expectedStatus);
        }
        catch (Exception e) {
            throw this.handle(e);
        }
    }

    protected Response putWithFormData(Response.Status expectedStatus, Form formData, Object ... pathArgs) throws GitLabApiException {
        try {
            return this.validate(this.getApiClient().put(formData, pathArgs), expectedStatus);
        }
        catch (Exception e) {
            throw this.handle(e);
        }
    }

    protected Response putUpload(Response.Status expectedStatus, String name, File fileToUpload, Object ... pathArgs) throws GitLabApiException {
        try {
            return this.validate(this.getApiClient().putUpload(name, fileToUpload, pathArgs), expectedStatus);
        }
        catch (Exception e) {
            throw this.handle(e);
        }
    }

    protected Response putUpload(Response.Status expectedStatus, String name, File fileToUpload, URL url) throws GitLabApiException {
        try {
            return this.validate(this.getApiClient().putUpload(name, fileToUpload, url), expectedStatus);
        }
        catch (Exception e) {
            throw this.handle(e);
        }
    }

    protected Response delete(Response.Status expectedStatus, MultivaluedMap<String, String> queryParams, Object ... pathArgs) throws GitLabApiException {
        try {
            return this.validate(this.getApiClient().delete(queryParams, pathArgs), expectedStatus);
        }
        catch (Exception e) {
            throw this.handle(e);
        }
    }

    protected Response delete(Response.Status expectedStatus, MultivaluedMap<String, String> queryParams, URL url) throws GitLabApiException {
        try {
            return this.validate(this.getApiClient().delete(queryParams, url), expectedStatus);
        }
        catch (Exception e) {
            throw this.handle(e);
        }
    }

    protected void addFormParam(Form formData, String name, Object value) throws IllegalArgumentException {
        this.addFormParam(formData, name, value, false);
    }

    protected void addFormParam(Form formData, String name, Object value, boolean required) throws IllegalArgumentException {
        if (value == null) {
            if (required) {
                throw new IllegalArgumentException(name + " cannot be empty or null");
            }
            return;
        }
        String stringValue = value.toString();
        if (required && stringValue.trim().length() == 0) {
            throw new IllegalArgumentException(name + " cannot be empty or null");
        }
        formData.param(name, stringValue);
    }

    protected Response validate(Response response, Response.Status expected) throws GitLabApiException {
        int expectedResponseCode;
        int responseCode = response.getStatus();
        if (responseCode != (expectedResponseCode = expected.getStatusCode()) && (expectedResponseCode > 204 || responseCode > 204 || expectedResponseCode < 200 || responseCode < 200)) {
            throw new GitLabApiException(response);
        }
        if (!this.getApiClient().validateSecretToken(response)) {
            throw new GitLabApiException((Exception)new NotAuthorizedException((Object)"Invalid secret token in response.", new Object[0]));
        }
        return response;
    }

    protected GitLabApiException handle(Exception thrown) {
        if (thrown instanceof GitLabApiException) {
            return (GitLabApiException)thrown;
        }
        return new GitLabApiException(thrown);
    }

    protected MultivaluedMap<String, String> getPerPageQueryParam(int perPage) {
        return new GitLabApiForm().withParam("per_page", perPage).asMap();
    }

    protected MultivaluedMap<String, String> getPageQueryParams(int page, int perPage) {
        return new GitLabApiForm().withParam("page", page).withParam("per_page", perPage).asMap();
    }

    protected MultivaluedMap<String, String> getPageQueryParams(int page, int perPage, boolean customAttributesEnabled) {
        GitLabApiForm form = new GitLabApiForm().withParam("page", page).withParam("per_page", perPage);
        if (customAttributesEnabled) {
            return form.withParam("with_custom_attributes", true).asMap();
        }
        return form.asMap();
    }

    protected MultivaluedMap<String, String> getDefaultPerPageParam() {
        return new GitLabApiForm().withParam("per_page", this.getDefaultPerPage()).asMap();
    }

    protected MultivaluedMap<String, String> getDefaultPerPageParam(boolean customAttributesEnabled) {
        GitLabApiForm form = new GitLabApiForm().withParam("per_page", this.getDefaultPerPage());
        if (customAttributesEnabled) {
            return form.withParam("with_custom_attributes", true).asMap();
        }
        return form.asMap();
    }
}

