/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Date;
import java.util.Map;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.models.ExportStatus;
import org.gitlab4j.api.models.ImportStatus;
import org.gitlab4j.api.models.Project;

public class ImportExportApi
extends AbstractApi {
    public ImportExportApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public void scheduleExport(Object projectIdOrPath) throws GitLabApiException {
        this.scheduleExport(projectIdOrPath, null, null, null, null);
    }

    public void scheduleExport(Object projectIdOrPath, String description) throws GitLabApiException {
        this.scheduleExport(projectIdOrPath, description, null, null, null);
    }

    public void scheduleExport(Object projectIdOrPath, String description, Map<String, String> upload, String uploadUrl, String uploadHttpMethod) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("description", description).withParam("upload", upload).withParam("upload[url]", uploadUrl).withParam("upload[http_method]", uploadHttpMethod);
        this.post(Response.Status.ACCEPTED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "export"});
    }

    public ExportStatus getExportStatus(Object projectIdOrPath) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "export");
        return (ExportStatus)response.readEntity(ExportStatus.class);
    }

    public File downloadExport(Object projectIdOrPath, File directory) throws GitLabApiException {
        return this.downloadExport(projectIdOrPath, directory, null);
    }

    public File downloadExport(Object projectIdOrPath, File directory, String filename) throws GitLabApiException {
        Response response = this.getWithAccepts(Response.Status.OK, null, "*", "projects", this.getProjectIdOrPath(projectIdOrPath), "export", "download");
        if (directory == null) {
            directory = new File(System.getProperty("java.io.tmpdir"));
        }
        if (filename == null) {
            String disposition = response.getHeaderString("Content-Disposition");
            if (disposition == null) {
                Object name = null;
                if (projectIdOrPath instanceof Project) {
                    name = ((Project)projectIdOrPath).getPathWithNamespace().replace('/', '_');
                } else if (projectIdOrPath instanceof String) {
                    name = (String)projectIdOrPath;
                } else if (projectIdOrPath instanceof Integer) {
                    name = "projectid-" + projectIdOrPath;
                }
                String template = "%1$tY-%1$tm-%1$td_%1$tH-%1$tM-%1$tS_%2$s_export.tar.gz";
                filename = String.format("%1$tY-%1$tm-%1$td_%1$tH-%1$tM-%1$tS_%2$s_export.tar.gz", new Date(), name);
            } else {
                filename = disposition.replaceFirst("(?i)^.*filename=\"?([^\"]+)\"?.*$", "$1");
            }
        }
        try {
            File file = new File(directory, filename);
            InputStream in = (InputStream)response.readEntity(InputStream.class);
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return file;
        }
        catch (IOException ioe) {
            throw new GitLabApiException(ioe);
        }
    }

    public ImportStatus startImport(Object namespaceIdOrPath, File exportFile, String path, Boolean overwrite, Project overrideParams) throws GitLabApiException {
        URL url;
        try {
            url = this.getApiClient().getApiUrl("projects", "import");
        }
        catch (IOException ioe) {
            throw new GitLabApiException(ioe);
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("path", path, true).withParam("namespace", namespaceIdOrPath).withParam("overwrite", overwrite);
        if (overrideParams != null) {
            formData.withParam("default_branch", overrideParams.getDefaultBranch()).withParam("description", overrideParams.getDescription()).withParam("issues_enabled", overrideParams.getIssuesEnabled()).withParam("merge_method", overrideParams.getMergeMethod()).withParam("merge_requests_enabled", overrideParams.getMergeRequestsEnabled()).withParam("jobs_enabled", overrideParams.getJobsEnabled()).withParam("wiki_enabled", overrideParams.getWikiEnabled()).withParam("container_registry_enabled", overrideParams.getContainerRegistryEnabled()).withParam("snippets_enabled", overrideParams.getSnippetsEnabled()).withParam("shared_runners_enabled", overrideParams.getSharedRunnersEnabled()).withParam("public_jobs", overrideParams.getPublicJobs()).withParam("visibility_level", overrideParams.getVisibilityLevel()).withParam("only_allow_merge_if_pipeline_succeeds", overrideParams.getOnlyAllowMergeIfPipelineSucceeds()).withParam("only_allow_merge_if_all_discussions_are_resolved", overrideParams.getOnlyAllowMergeIfAllDiscussionsAreResolved()).withParam("lfs_enabled", overrideParams.getLfsEnabled()).withParam("request_access_enabled", overrideParams.getRequestAccessEnabled()).withParam("repository_storage", overrideParams.getRepositoryStorage()).withParam("approvals_before_merge", overrideParams.getApprovalsBeforeMerge()).withParam("printing_merge_request_link_enabled", overrideParams.getPrintingMergeRequestLinkEnabled()).withParam("resolve_outdated_diff_discussions", overrideParams.getResolveOutdatedDiffDiscussions()).withParam("initialize_with_readme", overrideParams.getInitializeWithReadme()).withParam("packages_enabled", overrideParams.getPackagesEnabled()).withParam("build_git_strategy", overrideParams.getBuildGitStrategy()).withParam("build_coverage_regex", overrideParams.getBuildCoverageRegex()).withParam("squash_option", overrideParams.getSquashOption()).withParam("name", overrideParams.getName());
        }
        Response response = this.upload(Response.Status.CREATED, "file", exportFile, null, formData, url);
        return (ImportStatus)response.readEntity(ImportStatus.class);
    }

    public ImportStatus getImportStatus(Object projectIdOrPath) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "import");
        return (ImportStatus)response.readEntity(ImportStatus.class);
    }
}

