/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Commit;
import org.gitlab4j.api.models.Diff;

public class CommitsApi
extends AbstractApi {
    public CommitsApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Commit> getCommits(int projectId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", projectId, "repository", "commits");
        return (List)response.readEntity((GenericType)new GenericType<List<Commit>>(){});
    }

    public List<Commit> getCommits(int projectId, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", projectId, "repository", "commits");
        return (List)response.readEntity((GenericType)new GenericType<List<Commit>>(){});
    }

    public Pager<Commit> getCommits(int projectId, int itemsPerPage) throws GitLabApiException {
        return new Pager<Commit>(this, Commit.class, itemsPerPage, null, "projects", projectId, "repository", "commits");
    }

    public Commit getCommit(int projectId, String sha) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", projectId, "repository", "commits", sha);
        return (Commit)response.readEntity(Commit.class);
    }

    public List<Diff> getDiff(int projectId, String sha) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "repository", "commits", sha, "diff");
        return (List)response.readEntity((GenericType)new GenericType<List<Diff>>(){});
    }

    public List<Diff> getDiff(String projectPath, String sha) throws GitLabApiException {
        try {
            projectPath = URLEncoder.encode(projectPath, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new GitLabApiException(uee);
        }
        Response response = this.get(Response.Status.OK, null, "projects", projectPath, "repository", "commits", sha, "diff");
        return (List)response.readEntity((GenericType)new GenericType<List<Diff>>(){});
    }
}

