/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api.utils;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;

public class JacksonJsonEnumHelper<E extends Enum<E>> {
    private Map<String, E> valuesMap = new HashMap<String, E>();
    private Map<E, String> namesMap = new HashMap<E, String>();

    public JacksonJsonEnumHelper(Class<E> enumType) {
        this(enumType, false);
    }

    public JacksonJsonEnumHelper(Class<E> enumType, boolean firstLetterCapitalized) {
        Enum[] enumArray = (Enum[])enumType.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum e = enumArray[n2];
            String name = e.name().toLowerCase();
            if (firstLetterCapitalized) {
                name = String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
            }
            this.valuesMap.put(name, e);
            this.namesMap.put(e, name);
            ++n2;
        }
    }

    public JacksonJsonEnumHelper(Class<E> enumType, boolean firstLetterCapitalized, boolean camelCased) {
        this(enumType, firstLetterCapitalized, camelCased, false);
    }

    public JacksonJsonEnumHelper(Class<E> enumType, boolean firstLetterCapitalized, boolean camelCased, boolean preserveUnderscores) {
        Enum[] enumArray = (Enum[])enumType.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum e = enumArray[n2];
            char[] chars = e.name().toLowerCase().toCharArray();
            StringBuilder nameBuf = new StringBuilder(chars.length);
            boolean nextCharIsCapitalized = firstLetterCapitalized;
            char[] cArray = chars;
            int n3 = chars.length;
            int n4 = 0;
            while (n4 < n3) {
                char ch = cArray[n4];
                if (ch == '_') {
                    if (preserveUnderscores) {
                        nameBuf.append(ch);
                    } else if (camelCased) {
                        nextCharIsCapitalized = true;
                    } else {
                        nameBuf.append(' ');
                    }
                } else if (nextCharIsCapitalized) {
                    nextCharIsCapitalized = false;
                    nameBuf.append(Character.toUpperCase(ch));
                } else {
                    nameBuf.append(ch);
                }
                ++n4;
            }
            String name = nameBuf.toString();
            this.valuesMap.put(name, e);
            this.namesMap.put(e, name);
            ++n2;
        }
    }

    public void addEnum(E e, String name) {
        this.valuesMap.put(name, e);
        this.namesMap.put(e, name);
    }

    @JsonCreator
    public E forValue(String value) {
        return (E)((Enum)this.valuesMap.get(value));
    }

    public String toString(E e) {
        return this.namesMap.get(e);
    }
}

