/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.CustomAttribute;
import org.gitlab4j.api.models.Email;
import org.gitlab4j.api.models.ImpersonationToken;
import org.gitlab4j.api.models.SshKey;
import org.gitlab4j.api.models.User;
import org.gitlab4j.api.utils.EmailChecker;

public class UserApi
extends AbstractApi {
    private boolean customAttributesEnabled = false;

    public UserApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public void enableCustomAttributes() {
        this.customAttributesEnabled = true;
    }

    public void disableCustomAttributes() {
        this.customAttributesEnabled = false;
    }

    public List<User> getUsers() throws GitLabApiException {
        String url = this.gitLabApi.getGitLabServerUrl();
        if (url.startsWith("https://gitlab.com")) {
            GitLabApi.getLogger().warning("Fetching all users from " + url + " may take many minutes to complete, use Pager<User> getUsers(int) instead.");
        }
        return this.getUsers(this.getDefaultPerPage()).all();
    }

    public List<User> getUsers(int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage, this.customAttributesEnabled), "users");
        return (List)response.readEntity((GenericType)new GenericType<List<User>>(){});
    }

    public Pager<User> getUsers(int itemsPerPage) throws GitLabApiException {
        return new Pager<User>(this, User.class, itemsPerPage, (MultivaluedMap<String, String>)this.createGitLabApiForm().asMap(), "users");
    }

    public Stream<User> getUsersStream() throws GitLabApiException {
        return this.getUsers(this.getDefaultPerPage()).stream();
    }

    public List<User> getActiveUsers() throws GitLabApiException {
        return this.getActiveUsers(this.getDefaultPerPage()).all();
    }

    public List<User> getActiveUsers(int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = this.createGitLabApiForm().withParam("active", true).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "users");
        return (List)response.readEntity((GenericType)new GenericType<List<User>>(){});
    }

    public Pager<User> getActiveUsers(int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = this.createGitLabApiForm().withParam("active", true);
        return new Pager<User>(this, User.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "users");
    }

    public Stream<User> getActiveUsersStream() throws GitLabApiException {
        return this.getActiveUsers(this.getDefaultPerPage()).stream();
    }

    public void blockUser(Integer userId) throws GitLabApiException {
        if (userId == null) {
            throw new RuntimeException("userId cannot be null");
        }
        if (this.isApiVersion(GitLabApi.ApiVersion.V3)) {
            this.put(Response.Status.CREATED, null, "users", userId, "block");
        } else {
            this.post(Response.Status.CREATED, (Form)null, new Object[]{"users", userId, "block"});
        }
    }

    public void unblockUser(Integer userId) throws GitLabApiException {
        if (userId == null) {
            throw new RuntimeException("userId cannot be null");
        }
        if (this.isApiVersion(GitLabApi.ApiVersion.V3)) {
            this.put(Response.Status.CREATED, null, "users", userId, "unblock");
        } else {
            this.post(Response.Status.CREATED, (Form)null, new Object[]{"users", userId, "unblock"});
        }
    }

    public List<User> getBlockedUsers() throws GitLabApiException {
        return this.getBlockedUsers(this.getDefaultPerPage()).all();
    }

    public List<User> getblockedUsers(int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = this.createGitLabApiForm().withParam("blocked", true).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "users");
        return (List)response.readEntity((GenericType)new GenericType<List<User>>(){});
    }

    public Pager<User> getBlockedUsers(int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = this.createGitLabApiForm().withParam("blocked", true);
        return new Pager<User>(this, User.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "users");
    }

    public Stream<User> getBlockedUsersStream() throws GitLabApiException {
        return this.getBlockedUsers(this.getDefaultPerPage()).stream();
    }

    public User getUser(Integer userId) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("with_custom_attributes", this.customAttributesEnabled);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "users", userId);
        return (User)response.readEntity(User.class);
    }

    public Optional<User> getOptionalUser(Integer userId) {
        try {
            return Optional.ofNullable(this.getUser(userId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public User getUser(String username) throws GitLabApiException {
        GitLabApiForm formData = this.createGitLabApiForm().withParam("username", username, true).withParam("page", 1).withParam("per_page", 1);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "users");
        List users = (List)response.readEntity((GenericType)new GenericType<List<User>>(){});
        return users.isEmpty() ? null : (User)users.get(0);
    }

    public Optional<User> getOptionalUser(String username) {
        try {
            return Optional.ofNullable(this.getUser(username));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public User getUserByEmail(String email) throws GitLabApiException {
        if (!EmailChecker.isValidEmail(email)) {
            throw new IllegalArgumentException("email is not valid");
        }
        List<User> users = this.findUsers(email, 1, 1);
        return users.isEmpty() ? null : users.get(0);
    }

    public Optional<User> getOptionalUserByEmail(String email) {
        try {
            return Optional.ofNullable(this.getUserByEmail(email));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public User getUserByExternalUid(String provider, String externalUid) throws GitLabApiException {
        GitLabApiForm formData = this.createGitLabApiForm().withParam("provider", provider, true).withParam("extern_uid", externalUid, true).withParam("page", 1).withParam("per_page", 1);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "users");
        List users = (List)response.readEntity((GenericType)new GenericType<List<User>>(){});
        return users.isEmpty() ? null : (User)users.get(0);
    }

    public Optional<User> getOptionalUserByExternalUid(String provider, String externalUid) {
        try {
            return Optional.ofNullable(this.getUserByExternalUid(provider, externalUid));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public List<User> findUsers(String emailOrUsername) throws GitLabApiException {
        return this.findUsers(emailOrUsername, this.getDefaultPerPage()).all();
    }

    public List<User> findUsers(String emailOrUsername, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = this.createGitLabApiForm().withParam("search", emailOrUsername, true).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "users");
        return (List)response.readEntity((GenericType)new GenericType<List<User>>(){});
    }

    public Pager<User> findUsers(String emailOrUsername, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = this.createGitLabApiForm().withParam("search", emailOrUsername, true);
        return new Pager<User>(this, User.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "users");
    }

    public Stream<User> findUsersStream(String emailOrUsername) throws GitLabApiException {
        return this.findUsers(emailOrUsername, this.getDefaultPerPage()).stream();
    }

    public User createUser(User user, CharSequence password, Integer projectsLimit) throws GitLabApiException {
        Form formData = this.userToForm(user, projectsLimit, password, null, true);
        Response response = this.post(Response.Status.CREATED, formData, new Object[]{"users"});
        return (User)response.readEntity(User.class);
    }

    public User createUser(User user, CharSequence password, boolean resetPassword) throws GitLabApiException {
        Form formData = this.userToForm(user, null, password, resetPassword, true);
        Response response = this.post(Response.Status.CREATED, formData, new Object[]{"users"});
        return (User)response.readEntity(User.class);
    }

    public User updateUser(User user, CharSequence password) throws GitLabApiException {
        Form form = this.userToForm(user, null, password, false, false);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)form.asMap(), new Object[]{"users", user.getId()});
        return (User)response.readEntity(User.class);
    }

    @Deprecated
    public User modifyUser(User user, CharSequence password, Integer projectsLimit) throws GitLabApiException {
        Form form = this.userToForm(user, projectsLimit, password, false, false);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)form.asMap(), new Object[]{"users", user.getId()});
        return (User)response.readEntity(User.class);
    }

    public void deleteUser(Object userIdOrUsername) throws GitLabApiException {
        this.deleteUser(userIdOrUsername, null);
    }

    public void deleteUser(Object userIdOrUsername, Boolean hardDelete) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("hard_delete ", hardDelete);
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, (MultivaluedMap<String, String>)formData.asMap(), "users", this.getUserIdOrUsername(userIdOrUsername));
    }

    public User getCurrentUser() throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "user");
        return (User)response.readEntity(User.class);
    }

    public List<SshKey> getSshKeys() throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "user", "keys");
        return (List)response.readEntity((GenericType)new GenericType<List<SshKey>>(){});
    }

    public List<SshKey> getSshKeys(Integer userId) throws GitLabApiException {
        if (userId == null) {
            throw new RuntimeException("userId cannot be null");
        }
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "users", userId, "keys");
        List keys = (List)response.readEntity((GenericType)new GenericType<List<SshKey>>(){});
        if (keys != null) {
            keys.forEach(key -> key.setUserId(userId));
        }
        return keys;
    }

    public SshKey getSshKey(Integer keyId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "user", "keys", keyId);
        return (SshKey)response.readEntity(SshKey.class);
    }

    public Optional<SshKey> getOptionalSshKey(Integer keyId) {
        try {
            return Optional.ofNullable(this.getSshKey(keyId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public SshKey addSshKey(String title, String key) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("title", title).withParam("key", key);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"user", "keys"});
        return (SshKey)response.readEntity(SshKey.class);
    }

    public SshKey addSshKey(Integer userId, String title, String key) throws GitLabApiException {
        if (userId == null) {
            throw new RuntimeException("userId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("title", title).withParam("key", key);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"users", userId, "keys"});
        SshKey sshKey = (SshKey)response.readEntity(SshKey.class);
        if (sshKey != null) {
            sshKey.setUserId(userId);
        }
        return sshKey;
    }

    public void deleteSshKey(Integer keyId) throws GitLabApiException {
        if (keyId == null) {
            throw new RuntimeException("keyId cannot be null");
        }
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "user", "keys", keyId);
    }

    public void deleteSshKey(Object userIdOrUsername, Integer keyId) throws GitLabApiException {
        if (keyId == null) {
            throw new RuntimeException("keyId cannot be null");
        }
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "users", this.getUserIdOrUsername(userIdOrUsername), "keys", keyId);
    }

    public List<ImpersonationToken> getImpersonationTokens(Object userIdOrUsername) throws GitLabApiException {
        return this.getImpersonationTokens(userIdOrUsername, null);
    }

    public List<ImpersonationToken> getImpersonationTokens(Object userIdOrUsername, Constants.ImpersonationState state) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("state", (Object)state).withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "users", this.getUserIdOrUsername(userIdOrUsername), "impersonation_tokens");
        return (List)response.readEntity((GenericType)new GenericType<List<ImpersonationToken>>(){});
    }

    public ImpersonationToken getImpersonationToken(Object userIdOrUsername, Integer tokenId) throws GitLabApiException {
        if (tokenId == null) {
            throw new RuntimeException("tokenId cannot be null");
        }
        Response response = this.get(Response.Status.OK, null, "users", this.getUserIdOrUsername(userIdOrUsername), "impersonation_tokens", tokenId);
        return (ImpersonationToken)response.readEntity(ImpersonationToken.class);
    }

    public Optional<ImpersonationToken> getOptionalImpersonationToken(Object userIdOrUsername, Integer tokenId) {
        try {
            return Optional.ofNullable(this.getImpersonationToken(userIdOrUsername, tokenId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public ImpersonationToken createImpersonationToken(Object userIdOrUsername, String name, Date expiresAt, ImpersonationToken.Scope[] scopes) throws GitLabApiException {
        if (scopes == null || scopes.length == 0) {
            throw new RuntimeException("scopes cannot be null or empty");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, true).withParam("expires_at", expiresAt);
        ImpersonationToken.Scope[] scopeArray = scopes;
        int n = scopes.length;
        int n2 = 0;
        while (n2 < n) {
            ImpersonationToken.Scope scope = scopeArray[n2];
            formData.withParam("scopes[]", scope.toString());
            ++n2;
        }
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"users", this.getUserIdOrUsername(userIdOrUsername), "impersonation_tokens"});
        return (ImpersonationToken)response.readEntity(ImpersonationToken.class);
    }

    public void revokeImpersonationToken(Object userIdOrUsername, Integer tokenId) throws GitLabApiException {
        if (tokenId == null) {
            throw new RuntimeException("tokenId cannot be null");
        }
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "users", this.getUserIdOrUsername(userIdOrUsername), "impersonation_tokens", tokenId);
    }

    Form userToForm(User user, Integer projectsLimit, CharSequence password, Boolean resetPassword, boolean create) {
        if (create && (password == null || password.toString().trim().isEmpty()) && !resetPassword.booleanValue()) {
            throw new IllegalArgumentException("either password or reset_password must be set");
        }
        projectsLimit = projectsLimit == null ? user.getProjectsLimit() : projectsLimit;
        String skipConfirmationFeildName = create ? "skip_confirmation" : "skip_reconfirmation";
        return new GitLabApiForm().withParam("email", user.getEmail(), create).withParam("password", password, false).withParam("reset_password", resetPassword, false).withParam("username", user.getUsername(), create).withParam("name", user.getName(), create).withParam("skype", user.getSkype(), false).withParam("linkedin", user.getLinkedin(), false).withParam("twitter", user.getTwitter(), false).withParam("website_url", user.getWebsiteUrl(), false).withParam("organization", user.getOrganization(), false).withParam("projects_limit", projectsLimit, false).withParam("extern_uid", user.getExternUid(), false).withParam("provider", user.getProvider(), false).withParam("bio", user.getBio(), false).withParam("location", user.getLocation(), false).withParam("admin", user.getIsAdmin(), false).withParam("theme_id", user.getThemeId(), false).withParam("color_scheme_id", user.getColorSchemeId(), false).withParam("can_create_group", user.getCanCreateGroup(), false).withParam(skipConfirmationFeildName, user.getSkipConfirmation(), false).withParam("external", user.getExternal(), false).withParam("shared_runners_minutes_limit", user.getSharedRunnersMinutesLimit(), false);
    }

    public CustomAttribute createCustomAttribute(Object userIdOrUsername, CustomAttribute customAttribute) throws GitLabApiException {
        if (Objects.isNull(customAttribute)) {
            throw new IllegalArgumentException("CustomAttributes can't be null");
        }
        return this.createCustomAttribute(userIdOrUsername, customAttribute.getKey(), customAttribute.getValue());
    }

    public CustomAttribute createCustomAttribute(Object userIdOrUsername, String key, String value) throws GitLabApiException {
        if (Objects.isNull(key) || key.trim().isEmpty()) {
            throw new IllegalArgumentException("Key can't be null or empty");
        }
        if (Objects.isNull(value) || value.trim().isEmpty()) {
            throw new IllegalArgumentException("Value can't be null or empty");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("value", value);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"users", this.getUserIdOrUsername(userIdOrUsername), "custom_attributes", key});
        return (CustomAttribute)response.readEntity(CustomAttribute.class);
    }

    public CustomAttribute changeCustomAttribute(Object userIdOrUsername, CustomAttribute customAttribute) throws GitLabApiException {
        if (Objects.isNull(customAttribute)) {
            throw new IllegalArgumentException("CustomAttributes can't be null");
        }
        return this.createCustomAttribute(userIdOrUsername, customAttribute.getKey(), customAttribute.getValue());
    }

    public CustomAttribute changeCustomAttribute(Object userIdOrUsername, String key, String value) throws GitLabApiException {
        return this.createCustomAttribute(userIdOrUsername, key, value);
    }

    public void deleteCustomAttribute(Object userIdOrUsername, CustomAttribute customAttribute) throws GitLabApiException {
        if (Objects.isNull(customAttribute)) {
            throw new IllegalArgumentException("customAttributes can't be null");
        }
        this.deleteCustomAttribute(userIdOrUsername, customAttribute.getKey());
    }

    public void deleteCustomAttribute(Object userIdOrUsername, String key) throws GitLabApiException {
        if (Objects.isNull(key) || key.trim().isEmpty()) {
            throw new IllegalArgumentException("Key can't be null or empty");
        }
        this.delete(Response.Status.OK, null, "users", this.getUserIdOrUsername(userIdOrUsername), "custom_attributes", key);
    }

    private GitLabApiForm createGitLabApiForm() {
        GitLabApiForm formData = new GitLabApiForm();
        return this.customAttributesEnabled ? formData.withParam("with_custom_attributes", true) : formData;
    }

    public User setUserAvatar(Object userIdOrUsername, File avatarFile) throws GitLabApiException {
        Response response = this.putUpload(Response.Status.OK, "avatar", avatarFile, "users", this.getUserIdOrUsername(userIdOrUsername));
        return (User)response.readEntity(User.class);
    }

    public List<Email> getEmails() throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "user", "emails");
        return (List)response.readEntity((GenericType)new GenericType<List<Email>>(){});
    }

    public List<Email> getEmails(Object userIdOrUsername) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "users", this.getUserIdOrUsername(userIdOrUsername), "emails");
        return (List)response.readEntity((GenericType)new GenericType<List<Email>>(){});
    }

    public Email addEmail(String email) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("email", email, true);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"user", "emails"});
        return (Email)response.readEntity(Email.class);
    }

    public Email getEmail(Long emailId) throws GitLabApiException {
        Response response = this.get(Response.Status.CREATED, null, "user", "emails", emailId);
        return (Email)response.readEntity(Email.class);
    }

    public Email addEmail(Object userIdOrUsername, String email, Boolean skipConfirmation) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("email", email, true).withParam("skip_confirmation ", skipConfirmation);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"users", this.getUserIdOrUsername(userIdOrUsername), "emails"});
        return (Email)response.readEntity(Email.class);
    }

    public void deleteEmail(Long emailId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "user", "emails", emailId);
    }

    public void deleteEmail(Object userIdOrUsername, Long emailId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "users", this.getUserIdOrUsername(userIdOrUsername), "emails", emailId);
    }
}

