/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.models.NotificationSettings;

public class NotificationSettingsApi
extends AbstractApi {
    public NotificationSettingsApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public NotificationSettings getGlobalNotificationSettings() throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "notification_settings");
        return (NotificationSettings)response.readEntity(NotificationSettings.class);
    }

    public NotificationSettings updateGlobalNotificationSettings(NotificationSettings settings) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("level", (Object)settings.getLevel()).withParam("email", settings.getEmail());
        NotificationSettings.Events events = settings.getEvents();
        if (events != null) {
            formData.withParam("new_note", events.getNewNote()).withParam("new_issuee", events.getNewIssue()).withParam("reopen_issuee", events.getReopenIssue()).withParam("close_issuee", events.getCloseIssue()).withParam("reassign_issuee", events.getReassignIssue()).withParam("new_merge_requeste", events.getNewMergeRequest()).withParam("reopen_merge_requeste", events.getReopenMergeRequest()).withParam("close_merge_requeste", events.getCloseMergeRequest()).withParam("reassign_merge_requeste", events.getReassignMergeRequest()).withParam("merge_merge_requeste", events.getMergeMergeRequest()).withParam("failed_pipelinee", events.getFailedPipeline()).withParam("success_pipelinee", events.getSuccessPipeline());
        }
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "notification_settings");
        return (NotificationSettings)response.readEntity(NotificationSettings.class);
    }

    public NotificationSettings getGroupNotificationSettings(int groupId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "groups", groupId, "notification_settings");
        return (NotificationSettings)response.readEntity(NotificationSettings.class);
    }

    public NotificationSettings updateGroupNotificationSettings(int groupId, NotificationSettings settings) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("level", (Object)settings.getLevel()).withParam("email", settings.getEmail());
        NotificationSettings.Events events = settings.getEvents();
        if (events != null) {
            formData.withParam("new_note", events.getNewNote()).withParam("new_issuee", events.getNewIssue()).withParam("reopen_issuee", events.getReopenIssue()).withParam("close_issuee", events.getCloseIssue()).withParam("reassign_issuee", events.getReassignIssue()).withParam("new_merge_requeste", events.getNewMergeRequest()).withParam("reopen_merge_requeste", events.getReopenMergeRequest()).withParam("close_merge_requeste", events.getCloseMergeRequest()).withParam("reassign_merge_requeste", events.getReassignMergeRequest()).withParam("merge_merge_requeste", events.getMergeMergeRequest()).withParam("failed_pipelinee", events.getFailedPipeline()).withParam("success_pipelinee", events.getSuccessPipeline());
        }
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "groups", groupId, "notification_settings");
        return (NotificationSettings)response.readEntity(NotificationSettings.class);
    }

    public NotificationSettings getProjectNotificationSettings(int projectId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "notification_settings");
        return (NotificationSettings)response.readEntity(NotificationSettings.class);
    }

    public NotificationSettings updateProjectNotificationSettings(int projectId, NotificationSettings settings) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("level", (Object)settings.getLevel()).withParam("email", settings.getEmail());
        NotificationSettings.Events events = settings.getEvents();
        if (events != null) {
            formData.withParam("new_note", events.getNewNote()).withParam("new_issuee", events.getNewIssue()).withParam("reopen_issuee", events.getReopenIssue()).withParam("close_issuee", events.getCloseIssue()).withParam("reassign_issuee", events.getReassignIssue()).withParam("new_merge_requeste", events.getNewMergeRequest()).withParam("reopen_merge_requeste", events.getReopenMergeRequest()).withParam("close_merge_requeste", events.getCloseMergeRequest()).withParam("reassign_merge_requeste", events.getReassignMergeRequest()).withParam("merge_merge_requeste", events.getMergeMergeRequest()).withParam("failed_pipelinee", events.getFailedPipeline()).withParam("success_pipelinee", events.getSuccessPipeline());
        }
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "notification_settings");
        return (NotificationSettings)response.readEntity(NotificationSettings.class);
    }
}

