/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import javax.ws.rs.core.Response;
import org.gitlab4j.api.models.ErrorMessage;

public class GitLabApiException
extends Exception {
    private static final long serialVersionUID = 1L;
    private Response.StatusType statusInfo;
    private int httpStatus;
    private String message;

    public GitLabApiException(Response response) {
        this.statusInfo = response.getStatusInfo();
        this.httpStatus = response.getStatus();
        if (response.hasEntity()) {
            try {
                ErrorMessage errorMessage = (ErrorMessage)response.readEntity(ErrorMessage.class);
                this.message = errorMessage.getMessage();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public GitLabApiException(Exception e) {
        super(e);
        this.message = e.getMessage();
    }

    @Override
    public final String getMessage() {
        return this.message != null ? this.message : this.getReason();
    }

    public final String getReason() {
        return this.statusInfo != null ? this.statusInfo.getReasonPhrase() : null;
    }

    public final int getHttpStatus() {
        return this.httpStatus;
    }
}

