/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.models.Event;
import org.gitlab4j.api.models.Member;
import org.gitlab4j.api.models.Project;
import org.gitlab4j.api.models.ProjectHook;
import org.glassfish.jersey.uri.UriComponent;

public class ProjectApi
extends AbstractApi {
    ProjectApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Project> getProjects() throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects");
        return (List)response.readEntity((GenericType)new GenericType<List<Project>>(){});
    }

    public List<Project> getAllProjects() throws GitLabApiException {
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)UriComponent.decodeQuery((String)"per_page=9999", (boolean)true), "projects", "all");
        return (List)response.readEntity((GenericType)new GenericType<List<Project>>(){});
    }

    public List<Project> getOwnedProjects() throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", "owned");
        return (List)response.readEntity((GenericType)new GenericType<List<Project>>(){});
    }

    public Project getProject(Integer projectId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", projectId);
        return (Project)response.readEntity(Project.class);
    }

    public Project getProject(String namespace, String project) throws GitLabApiException {
        if (namespace == null) {
            throw new RuntimeException("namespace cannot be null");
        }
        if (project == null) {
            throw new RuntimeException("project cannot be null");
        }
        String pid = null;
        try {
            pid = URLEncoder.encode(namespace + "/" + project, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new GitLabApiException(uee);
        }
        Response response = this.get(Response.Status.OK, null, "projects", pid);
        return (Project)response.readEntity(Project.class);
    }

    public Project createProject(Integer groupId, String projectName) throws GitLabApiException {
        Form formData = new Form();
        this.addFormParam(formData, "namespace_id", groupId);
        this.addFormParam(formData, "name", projectName, true);
        Response response = this.post(Response.Status.CREATED, formData, "projects");
        return (Project)response.readEntity(Project.class);
    }

    public Project createProject(Project project) throws GitLabApiException {
        return this.createProject(project, null);
    }

    public Project createProject(Project project, String importUrl) throws GitLabApiException {
        if (project == null) {
            return null;
        }
        String name = project.getName();
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        Form formData = new Form();
        if (project.getNamespace() != null) {
            this.addFormParam(formData, "namespace_id", project.getNamespace().getId());
        }
        this.addFormParam(formData, "name", name, true);
        this.addFormParam(formData, "description", project.getDescription());
        this.addFormParam(formData, "issues_enabled", project.getIssuesEnabled());
        this.addFormParam(formData, "wall_enabled", project.getWallEnabled());
        this.addFormParam(formData, "merge_requests_enabled", project.getMergeRequestsEnabled());
        this.addFormParam(formData, "wiki_enabled", project.getWikiEnabled());
        this.addFormParam(formData, "snippets_enabled", project.getSnippetsEnabled());
        this.addFormParam(formData, "public", project.getPublic());
        this.addFormParam(formData, "visibility_level", project.getVisibilityLevel());
        this.addFormParam(formData, "import_url", importUrl);
        Response response = this.post(Response.Status.CREATED, formData, "projects");
        return (Project)response.readEntity(Project.class);
    }

    public Project createProject(String name, Integer namespaceId, String description, Boolean issuesEnabled, Boolean wallEnabled, Boolean mergeRequestsEnabled, Boolean wikiEnabled, Boolean snippetsEnabled, Boolean publik, Integer visibilityLevel, String importUrl) throws GitLabApiException {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        Form formData = new Form();
        this.addFormParam(formData, "name", name, true);
        this.addFormParam(formData, "namespace_id", namespaceId);
        this.addFormParam(formData, "description", description);
        this.addFormParam(formData, "issues_enabled", issuesEnabled);
        this.addFormParam(formData, "wall_enabled", wallEnabled);
        this.addFormParam(formData, "merge_requests_enabled", mergeRequestsEnabled);
        this.addFormParam(formData, "wiki_enabled", wikiEnabled);
        this.addFormParam(formData, "snippets_enabled", snippetsEnabled);
        this.addFormParam(formData, "public", publik);
        this.addFormParam(formData, "visibility_level", visibilityLevel);
        this.addFormParam(formData, "import_url", importUrl);
        Response response = this.post(Response.Status.CREATED, formData, "projects");
        return (Project)response.readEntity(Project.class);
    }

    public void deleteProject(Integer projectId) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        this.delete(Response.Status.OK, null, "projects", projectId);
    }

    public void deleteProject(Project project) throws GitLabApiException {
        this.deleteProject(project.getId());
    }

    public List<Member> getMembers(Integer projectId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "members");
        return (List)response.readEntity((GenericType)new GenericType<List<Member>>(){});
    }

    public Member getMember(Integer projectId, Integer userId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "members", userId);
        return (Member)response.readEntity(Member.class);
    }

    public Member addMember(Integer projectId, Integer userId, Integer accessLevel) throws GitLabApiException {
        Form formData = new Form();
        formData.param("user_id", userId.toString());
        formData.param("access_level", accessLevel.toString());
        Response response = this.post(Response.Status.CREATED, formData, "projects", projectId, "members");
        return (Member)response.readEntity(Member.class);
    }

    public void removeMember(Integer projectId, Integer userId) throws GitLabApiException {
        this.delete(Response.Status.OK, null, "projects", projectId, "members", userId);
    }

    public List<Event> getProjectEvents(Integer projectId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "events");
        return (List)response.readEntity((GenericType)new GenericType<List<Event>>(){});
    }

    public List<ProjectHook> getHooks(Integer projectId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "hooks");
        return (List)response.readEntity((GenericType)new GenericType<List<ProjectHook>>(){});
    }

    public ProjectHook getHook(Integer projectId, Integer hookId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "hooks", hookId);
        return (ProjectHook)response.readEntity(ProjectHook.class);
    }

    public ProjectHook addHook(Project project, String url, boolean doPushEvents, boolean doIssuesEvents, boolean doMergeRequestsEvents) throws GitLabApiException {
        if (project == null) {
            return null;
        }
        return this.addHook(project.getId(), url, doPushEvents, doIssuesEvents, doMergeRequestsEvents);
    }

    public ProjectHook addHook(Integer projectId, String url, boolean doPushEvents, boolean doIssuesEvents, boolean doMergeRequestsEvents) throws GitLabApiException {
        Form formData = new Form();
        formData.param("url", url);
        formData.param("push_events", Boolean.toString(doPushEvents));
        formData.param("issues_enabled", Boolean.toString(doIssuesEvents));
        formData.param("merge_requests_events", Boolean.toString(doMergeRequestsEvents));
        Response response = this.post(Response.Status.CREATED, formData, "projects", projectId, "hooks");
        return (ProjectHook)response.readEntity(ProjectHook.class);
    }

    public void deleteHook(Integer projectId, Integer hookId) throws GitLabApiException {
        this.delete(Response.Status.OK, null, "projects", projectId, "hooks", hookId);
    }

    public void deleteHook(ProjectHook hook) throws GitLabApiException {
        this.deleteHook(hook.getProjectId(), hook.getId());
    }

    public ProjectHook modifyHook(ProjectHook hook) throws GitLabApiException {
        Form formData = new Form();
        formData.param("url", hook.getUrl());
        formData.param("push_events", hook.getPushEvents().toString());
        formData.param("issues_enabled", hook.getIssuesEvents().toString());
        formData.param("merge_requests_events", hook.getMergeRequestsEvents().toString());
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", hook.getProjectId(), "hooks", hook.getId());
        return (ProjectHook)response.readEntity(ProjectHook.class);
    }
}

