/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab.api;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.gitlab.api.AuthMethod;
import org.gitlab.api.Pagination;
import org.gitlab.api.TokenType;
import org.gitlab.api.http.GitlabHTTPRequestor;
import org.gitlab.api.http.Query;
import org.gitlab.api.models.CommitComment;
import org.gitlab.api.models.GitlabAccessLevel;
import org.gitlab.api.models.GitlabBranch;
import org.gitlab.api.models.GitlabBuild;
import org.gitlab.api.models.GitlabCommit;
import org.gitlab.api.models.GitlabCommitDiff;
import org.gitlab.api.models.GitlabCommitStatus;
import org.gitlab.api.models.GitlabGroup;
import org.gitlab.api.models.GitlabGroupMember;
import org.gitlab.api.models.GitlabIssue;
import org.gitlab.api.models.GitlabLabel;
import org.gitlab.api.models.GitlabMergeRequest;
import org.gitlab.api.models.GitlabMilestone;
import org.gitlab.api.models.GitlabNamespace;
import org.gitlab.api.models.GitlabNote;
import org.gitlab.api.models.GitlabProject;
import org.gitlab.api.models.GitlabProjectHook;
import org.gitlab.api.models.GitlabProjectMember;
import org.gitlab.api.models.GitlabRepositoryTree;
import org.gitlab.api.models.GitlabSSHKey;
import org.gitlab.api.models.GitlabSession;
import org.gitlab.api.models.GitlabSystemHook;
import org.gitlab.api.models.GitlabUser;

public class GitlabAPI {
    public static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final String API_NAMESPACE = "/api/v3";
    private static final String PARAM_SUDO = "sudo";
    private final String hostUrl;
    private final String apiToken;
    private final TokenType tokenType;
    private AuthMethod authMethod;
    private boolean ignoreCertificateErrors = false;
    private int requestTimeout = 0;

    private GitlabAPI(String hostUrl, String apiToken, TokenType tokenType, AuthMethod method) {
        this.hostUrl = hostUrl.endsWith("/") ? hostUrl.replaceAll("/$", "") : hostUrl;
        this.apiToken = apiToken;
        this.tokenType = tokenType;
        this.authMethod = method;
    }

    public static GitlabSession connect(String hostUrl, String username, String password) throws IOException {
        String tailUrl = "/session";
        GitlabAPI api = GitlabAPI.connect(hostUrl, null, null, null);
        return api.dispatch().with("login", username).with("password", password).to(tailUrl, GitlabSession.class);
    }

    public static GitlabAPI connect(String hostUrl, String apiToken) {
        return new GitlabAPI(hostUrl, apiToken, TokenType.PRIVATE_TOKEN, AuthMethod.HEADER);
    }

    public static GitlabAPI connect(String hostUrl, String apiToken, TokenType tokenType) {
        return new GitlabAPI(hostUrl, apiToken, tokenType, AuthMethod.HEADER);
    }

    public static GitlabAPI connect(String hostUrl, String apiToken, TokenType tokenType, AuthMethod method) {
        return new GitlabAPI(hostUrl, apiToken, tokenType, method);
    }

    public GitlabAPI ignoreCertificateErrors(boolean ignoreCertificateErrors) {
        this.ignoreCertificateErrors = ignoreCertificateErrors;
        return this;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public GitlabAPI setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public GitlabHTTPRequestor retrieve() {
        return new GitlabHTTPRequestor(this).authenticate(this.apiToken, this.tokenType, this.authMethod);
    }

    public GitlabHTTPRequestor dispatch() {
        return new GitlabHTTPRequestor(this).authenticate(this.apiToken, this.tokenType, this.authMethod).method("POST");
    }

    public boolean isIgnoreCertificateErrors() {
        return this.ignoreCertificateErrors;
    }

    public URL getAPIUrl(String tailAPIUrl) throws IOException {
        if (!tailAPIUrl.startsWith("/")) {
            tailAPIUrl = "/" + tailAPIUrl;
        }
        return new URL(this.hostUrl + API_NAMESPACE + tailAPIUrl);
    }

    public URL getUrl(String tailAPIUrl) throws IOException {
        if (!tailAPIUrl.startsWith("/")) {
            tailAPIUrl = "/" + tailAPIUrl;
        }
        return new URL(this.hostUrl + tailAPIUrl);
    }

    public List<GitlabUser> getUsers() throws IOException {
        String tailUrl = GitlabUser.URL;
        return this.retrieve().getAll(tailUrl, GitlabUser[].class);
    }

    public List<GitlabUser> findUsers(String emailOrUsername) throws IOException {
        List<GitlabUser> users = new ArrayList<GitlabUser>();
        if (emailOrUsername != null && !emailOrUsername.equals("")) {
            String tailUrl = GitlabUser.URL + "?search=" + emailOrUsername;
            GitlabUser[] response = this.retrieve().to(tailUrl, GitlabUser[].class);
            users = Arrays.asList(response);
        }
        return users;
    }

    public GitlabUser getUser() throws IOException {
        String tailUrl = GitlabUser.USER_URL;
        return this.retrieve().to(tailUrl, GitlabUser.class);
    }

    public GitlabUser getUser(Integer userId) throws IOException {
        String tailUrl = GitlabUser.URL + "/" + userId;
        return this.retrieve().to(tailUrl, GitlabUser.class);
    }

    public GitlabUser getUserViaSudo(String username) throws IOException {
        String tailUrl = GitlabUser.USER_URL + "?" + PARAM_SUDO + "=" + username;
        return this.retrieve().to(tailUrl, GitlabUser.class);
    }

    public GitlabUser createUser(String email, String password, String username, String fullName, String skypeId, String linkedIn, String twitter, String website_url, Integer projects_limit, String extern_uid, String extern_provider_name, String bio, Boolean isAdmin, Boolean can_create_group, Boolean skip_confirmation) throws IOException {
        Query query = new Query().append("email", email).appendIf("confirm", skip_confirmation == null ? null : Boolean.valueOf(skip_confirmation == false)).appendIf("password", password).appendIf("username", username).appendIf("name", fullName).appendIf("skype", skypeId).appendIf("linkedin", linkedIn).appendIf("twitter", twitter).appendIf("website_url", website_url).appendIf("projects_limit", projects_limit).appendIf("extern_uid", extern_uid).appendIf("provider", extern_provider_name).appendIf("bio", bio).appendIf("admin", isAdmin).appendIf("can_create_group", can_create_group);
        String tailUrl = GitlabUser.USERS_URL + query.toString();
        return this.dispatch().to(tailUrl, GitlabUser.class);
    }

    public GitlabUser updateUser(Integer targetUserId, String email, String password, String username, String fullName, String skypeId, String linkedIn, String twitter, String website_url, Integer projects_limit, String extern_uid, String extern_provider_name, String bio, Boolean isAdmin, Boolean can_create_group) throws IOException {
        Query query = new Query().append("email", email).appendIf("password", password).appendIf("username", username).appendIf("name", fullName).appendIf("skype", skypeId).appendIf("linkedin", linkedIn).appendIf("twitter", twitter).appendIf("website_url", website_url).appendIf("projects_limit", projects_limit).appendIf("extern_uid", extern_uid).appendIf("provider", extern_provider_name).appendIf("bio", bio).appendIf("admin", isAdmin).appendIf("can_create_group", can_create_group);
        String tailUrl = GitlabUser.USERS_URL + "/" + targetUserId + query.toString();
        return this.retrieve().method("PUT").to(tailUrl, GitlabUser.class);
    }

    public void blockUser(Integer targetUserId) throws IOException {
        String tailUrl = GitlabUser.USERS_URL + "/" + targetUserId + GitlabUser.BLOCK_URL;
        this.retrieve().method("PUT").to(tailUrl, Void.class);
    }

    public void unblockUser(Integer targetUserId) throws IOException {
        String tailUrl = GitlabUser.USERS_URL + "/" + targetUserId + GitlabUser.UNBLOCK_URL;
        this.retrieve().method("PUT").to(tailUrl, Void.class);
    }

    public GitlabSSHKey createSSHKey(Integer targetUserId, String title, String key) throws IOException {
        Query query = new Query().append("title", title).append("key", key);
        String tailUrl = GitlabUser.USERS_URL + "/" + targetUserId + GitlabSSHKey.KEYS_URL + query.toString();
        return this.dispatch().to(tailUrl, GitlabSSHKey.class);
    }

    public void deleteSSHKey(Integer targetUserId, Integer targetKeyId) throws IOException {
        String tailUrl = GitlabUser.USERS_URL + "/" + targetUserId + GitlabSSHKey.KEYS_URL + "/" + targetKeyId;
        this.retrieve().method("DELETE").to(tailUrl, Void.class);
    }

    public List<GitlabSSHKey> getSSHKeys(Integer targetUserId) throws IOException {
        String tailUrl = GitlabUser.USERS_URL + "/" + targetUserId + GitlabSSHKey.KEYS_URL;
        return Arrays.asList((Object[])this.retrieve().to(tailUrl, GitlabSSHKey[].class));
    }

    public GitlabSSHKey getSSHKey(Integer keyId) throws IOException {
        String tailUrl = GitlabSSHKey.KEYS_URL + "/" + keyId;
        return this.retrieve().to(tailUrl, GitlabSSHKey.class);
    }

    public void deleteUser(Integer targetUserId) throws IOException {
        String tailUrl = GitlabUser.USERS_URL + "/" + targetUserId;
        this.retrieve().method("DELETE").to(tailUrl, Void.class);
    }

    public GitlabGroup getGroup(Integer groupId) throws IOException {
        String tailUrl = "/groups/" + groupId;
        return this.retrieve().to(tailUrl, GitlabGroup.class);
    }

    public List<GitlabGroup> getGroups() throws IOException {
        String tailUrl = "/groups";
        return this.retrieve().getAll(tailUrl, GitlabGroup[].class);
    }

    public List<GitlabProject> getGroupProjects(GitlabGroup group) throws IOException {
        return this.getGroupProjects(group.getId());
    }

    public List<GitlabProject> getGroupProjects(Integer groupId) throws IOException {
        String tailUrl = "/groups/" + groupId + "/projects";
        return Arrays.asList((Object[])this.retrieve().to(tailUrl, GitlabProject[].class));
    }

    public List<GitlabGroupMember> getGroupMembers(GitlabGroup group) throws IOException {
        return this.getGroupMembers(group.getId());
    }

    public List<GitlabGroupMember> getGroupMembers(Integer groupId) throws IOException {
        String tailUrl = "/groups/" + groupId + "/members";
        return Arrays.asList((Object[])this.retrieve().to(tailUrl, GitlabGroupMember[].class));
    }

    public GitlabGroup createGroup(String name) throws IOException {
        return this.createGroup(name, name);
    }

    public GitlabGroup createGroup(String name, String path) throws IOException {
        return this.createGroup(name, path, null, null, null);
    }

    public GitlabGroup createGroupViaSudo(String name, String path, GitlabUser sudoUser) throws IOException {
        return this.createGroup(name, path, null, null, sudoUser);
    }

    public GitlabGroup createGroup(String name, String path, String ldapCn, GitlabAccessLevel ldapAccess) throws IOException {
        return this.createGroup(name, path, ldapCn, ldapAccess, null);
    }

    public GitlabGroup createGroup(String name, String path, String ldapCn, GitlabAccessLevel ldapAccess, GitlabUser sudoUser) throws IOException {
        Query query = new Query().append("name", name).append("path", path).appendIf("ldap_cn", ldapCn).appendIf("ldap_access", ldapAccess).appendIf(PARAM_SUDO, sudoUser != null ? sudoUser.getId() : null);
        String tailUrl = "/groups" + query.toString();
        return this.dispatch().to(tailUrl, GitlabGroup.class);
    }

    public GitlabGroupMember addGroupMember(GitlabGroup group, GitlabUser user, GitlabAccessLevel accessLevel) throws IOException {
        return this.addGroupMember(group.getId(), user.getId(), accessLevel);
    }

    public GitlabGroupMember addGroupMember(Integer groupId, Integer userId, GitlabAccessLevel accessLevel) throws IOException {
        Query query = new Query().appendIf("id", groupId).appendIf("user_id", userId).appendIf("access_level", accessLevel);
        String tailUrl = "/groups/" + groupId + "/members" + query.toString();
        return this.dispatch().to(tailUrl, GitlabGroupMember.class);
    }

    public void deleteGroupMember(GitlabGroup group, GitlabUser user) throws IOException {
        this.deleteGroupMember(group.getId(), user.getId());
    }

    public void deleteGroupMember(Integer groupId, Integer userId) throws IOException {
        String tailUrl = "/groups/" + groupId + "/" + "/members" + "/" + userId;
        this.retrieve().method("DELETE").to(tailUrl, Void.class);
    }

    public void deleteGroup(Integer groupId) throws IOException {
        String tailUrl = "/groups/" + groupId;
        this.retrieve().method("DELETE").to(tailUrl, Void.class);
    }

    public GitlabProject getProject(Serializable projectId) throws IOException {
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId);
        return this.retrieve().to(tailUrl, GitlabProject.class);
    }

    public List<GitlabProject> getProjects() throws IOException {
        String tailUrl = "/projects";
        return this.retrieve().getAll(tailUrl, GitlabProject[].class);
    }

    public List<GitlabProject> getProjectsViaSudo(GitlabUser user) throws IOException {
        Query query = new Query().appendIf(PARAM_SUDO, user.getId());
        String tailUrl = "/projects" + query.toString();
        return this.retrieve().getAll(tailUrl, GitlabProject[].class);
    }

    public List<GitlabProject> getAllProjects() throws IOException {
        String tailUrl = "/projects/all";
        return this.retrieve().getAll(tailUrl, GitlabProject[].class);
    }

    public List<GitlabBuild> getProjectBuilds(GitlabProject project) throws IOException {
        return this.getProjectBuilds(project.getId());
    }

    public List<GitlabBuild> getProjectBuilds(Integer projectId) throws IOException {
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/builds";
        return this.retrieve().getAll(tailUrl, GitlabBuild[].class);
    }

    public GitlabProject createProject(String name) throws IOException {
        return this.createProject(name, null, null, null, null, null, null, null, null, null, null);
    }

    public GitlabProject createProject(String name, Integer namespaceId, String description, Boolean issuesEnabled, Boolean wallEnabled, Boolean mergeRequestsEnabled, Boolean wikiEnabled, Boolean snippetsEnabled, Boolean publik, Integer visibilityLevel, String importUrl) throws IOException {
        Query query = new Query().append("name", name).appendIf("namespace_id", namespaceId).appendIf("description", description).appendIf("issues_enabled", issuesEnabled).appendIf("wall_enabled", wallEnabled).appendIf("merge_requests_enabled", mergeRequestsEnabled).appendIf("wiki_enabled", wikiEnabled).appendIf("snippets_enabled", snippetsEnabled).appendIf("public", publik).appendIf("visibility_level", visibilityLevel).appendIf("import_url", importUrl);
        String tailUrl = "/projects" + query.toString();
        return this.dispatch().to(tailUrl, GitlabProject.class);
    }

    public GitlabProject createUserProject(Integer userId, String name) throws IOException {
        return this.createUserProject(userId, name, null, null, null, null, null, null, null, null, null, null);
    }

    public GitlabProject createUserProject(Integer userId, String name, String description, String defaultBranch, Boolean issuesEnabled, Boolean wallEnabled, Boolean mergeRequestsEnabled, Boolean wikiEnabled, Boolean snippetsEnabled, Boolean publik, Integer visibilityLevel, String importUrl) throws IOException {
        Query query = new Query().append("name", name).appendIf("description", description).appendIf("default_branch", defaultBranch).appendIf("issues_enabled", issuesEnabled).appendIf("wall_enabled", wallEnabled).appendIf("merge_requests_enabled", mergeRequestsEnabled).appendIf("wiki_enabled", wikiEnabled).appendIf("snippets_enabled", snippetsEnabled).appendIf("public", publik).appendIf("visibility_level", visibilityLevel).appendIf("import_url", importUrl);
        String tailUrl = "/projects/user/" + userId + query.toString();
        return this.dispatch().to(tailUrl, GitlabProject.class);
    }

    public GitlabProject updateProject(Integer projectId, String name, String description, Boolean issuesEnabled, Boolean wallEnabled, Boolean mergeRequestsEnabled, Boolean wikiEnabled, Boolean snippetsEnabled, Boolean publik, Integer visibilityLevel) throws IOException {
        Query query = new Query().appendIf("name", name).appendIf("description", description).appendIf("issues_enabled", issuesEnabled).appendIf("wall_enabled", wallEnabled).appendIf("merge_requests_enabled", mergeRequestsEnabled).appendIf("wiki_enabled", wikiEnabled).appendIf("snippets_enabled", snippetsEnabled).appendIf("public", publik).appendIf("visibility_level", visibilityLevel);
        String tailUrl = "/projects/" + projectId + query.toString();
        return this.retrieve().method("PUT").to(tailUrl, GitlabProject.class);
    }

    public void deleteProject(Serializable projectId) throws IOException {
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId);
        this.retrieve().method("DELETE").to(tailUrl, null);
    }

    public List<GitlabMergeRequest> getOpenMergeRequests(Serializable projectId) throws IOException {
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/merge_requests" + "?state=opened";
        return this.retrieve().getAll(tailUrl, GitlabMergeRequest[].class);
    }

    public List<GitlabMergeRequest> getOpenMergeRequests(GitlabProject project) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/merge_requests" + "?state=opened";
        return this.retrieve().getAll(tailUrl, GitlabMergeRequest[].class);
    }

    public List<GitlabMergeRequest> getMergeRequests(Serializable projectId) throws IOException {
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/merge_requests";
        return this.retrieve().getAll(tailUrl, GitlabMergeRequest[].class);
    }

    public List<GitlabMergeRequest> getMergeRequests(GitlabProject project) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/merge_requests";
        return this.retrieve().getAll(tailUrl, GitlabMergeRequest[].class);
    }

    public List<GitlabMergeRequest> getAllMergeRequests(GitlabProject project) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/merge_requests";
        return this.retrieve().getAll(tailUrl, GitlabMergeRequest[].class);
    }

    public GitlabMergeRequest getMergeRequestByIid(Serializable projectId, Integer mergeRequestIid) throws IOException {
        Query query = new Query().append("iid", mergeRequestIid.toString());
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/merge_requests" + query.toString();
        List ls = this.retrieve().getAll(tailUrl, GitlabMergeRequest[].class);
        if (ls.size() == 0) {
            throw new FileNotFoundException();
        }
        return (GitlabMergeRequest)ls.get(0);
    }

    public GitlabMergeRequest getMergeRequestChanges(Serializable projectId, Integer mergeRequestId) throws IOException {
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/merge_request/" + mergeRequestId + "/changes";
        return this.retrieve().to(tailUrl, GitlabMergeRequest.class);
    }

    public GitlabMergeRequest getMergeRequest(GitlabProject project, Integer mergeRequestId) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/merge_request/" + mergeRequestId;
        return this.retrieve().to(tailUrl, GitlabMergeRequest.class);
    }

    public GitlabMergeRequest updateMergeRequest(Serializable projectId, Integer mergeRequestId, String targetBranch, Integer assigneeId, String title, String description, String stateEvent, String labels) throws IOException {
        Query query = new Query().appendIf("target_branch", targetBranch).appendIf("assignee_id", assigneeId).appendIf("title", title).appendIf("description", description).appendIf("state_event", stateEvent).appendIf("labels", labels);
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/merge_request/" + mergeRequestId + query.toString();
        return this.retrieve().method("PUT").to(tailUrl, GitlabMergeRequest.class);
    }

    public GitlabMergeRequest acceptMergeRequest(GitlabProject project, Integer mergeRequestId, String mergeCommitMessage) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/merge_request/" + mergeRequestId + "/merge";
        GitlabHTTPRequestor requestor = this.retrieve().method("PUT");
        requestor.with("id", project.getId());
        requestor.with("merge_request_id", mergeRequestId);
        if (mergeCommitMessage != null) {
            requestor.with("merge_commit_message", mergeCommitMessage);
        }
        return requestor.to(tailUrl, GitlabMergeRequest.class);
    }

    public GitlabNote getNote(GitlabMergeRequest mergeRequest, Integer noteId) throws IOException {
        String tailUrl = "/projects/" + mergeRequest.getProjectId() + "/merge_requests" + "/" + mergeRequest.getId() + "/notes" + "/" + noteId;
        return this.retrieve().to(tailUrl, GitlabNote.class);
    }

    public List<GitlabNote> getNotes(GitlabMergeRequest mergeRequest) throws IOException {
        String tailUrl = "/projects/" + mergeRequest.getProjectId() + "/merge_requests" + "/" + mergeRequest.getId() + "/notes";
        GitlabNote[] notes = this.retrieve().to(tailUrl, GitlabNote[].class);
        return Arrays.asList(notes);
    }

    public List<GitlabNote> getAllNotes(GitlabMergeRequest mergeRequest) throws IOException {
        String tailUrl = "/projects/" + mergeRequest.getProjectId() + "/merge_requests" + "/" + mergeRequest.getId() + "/notes";
        return this.retrieve().getAll(tailUrl, GitlabNote[].class);
    }

    public GitlabCommit getCommit(Serializable projectId, String commitHash) throws IOException {
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/repository/commits/" + commitHash;
        return this.retrieve().to(tailUrl, GitlabCommit.class);
    }

    public List<GitlabBuild> getCommitBuilds(GitlabProject projectId, String commitHash) throws IOException {
        return this.getCommitBuilds(projectId.getId(), commitHash);
    }

    public List<GitlabBuild> getCommitBuilds(Serializable projectId, String commitHash) throws IOException {
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/repository/commits/" + commitHash + "/builds";
        return this.retrieve().getAll(tailUrl, GitlabBuild[].class);
    }

    public List<GitlabCommit> getCommits(GitlabMergeRequest mergeRequest) throws IOException {
        return this.getCommits(mergeRequest, new Pagination());
    }

    public List<GitlabCommit> getCommits(GitlabMergeRequest mergeRequest, Pagination pagination) throws IOException {
        Integer projectId = mergeRequest.getSourceProjectId();
        if (projectId == null) {
            projectId = mergeRequest.getProjectId();
        }
        Query query = new Query().append("ref_name", mergeRequest.getSourceBranch());
        query.mergeWith(pagination.asQuery());
        String tailUrl = "/projects/" + projectId + "/repository" + "/commits" + query.toString();
        GitlabCommit[] commits = this.retrieve().to(tailUrl, GitlabCommit[].class);
        return Arrays.asList(commits);
    }

    public List<GitlabCommit> getLastCommits(Serializable projectId) throws IOException {
        return this.getCommits(projectId, null, null);
    }

    public List<GitlabCommit> getLastCommits(Serializable projectId, String branchOrTag) throws IOException {
        return this.getCommits(projectId, null, branchOrTag);
    }

    public List<GitlabCommit> getCommits(Serializable projectId, Pagination pagination, String branchOrTag) throws IOException {
        Query query = new Query();
        if (branchOrTag != null) {
            query.append("ref_name", branchOrTag);
        }
        if (pagination != null) {
            query.mergeWith(pagination.asQuery());
        }
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/repository" + "/commits" + query;
        GitlabCommit[] commits = this.retrieve().to(tailUrl, GitlabCommit[].class);
        return Arrays.asList(commits);
    }

    public List<GitlabCommit> getAllCommits(Serializable projectId) throws IOException {
        return this.getAllCommits(projectId, null, null);
    }

    public List<GitlabCommit> getAllCommits(Serializable projectId, String branchOrTag) throws IOException {
        return this.getAllCommits(projectId, null, branchOrTag);
    }

    public List<GitlabCommit> getAllCommits(Serializable projectId, Pagination pagination, String branchOrTag) throws IOException {
        Query query = new Query();
        if (branchOrTag != null) {
            query.append("ref_name", branchOrTag);
        }
        if (pagination != null) {
            query.mergeWith(pagination.asQuery());
        }
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/repository" + "/commits" + query;
        return this.retrieve().getAll(tailUrl, GitlabCommit[].class);
    }

    public List<GitlabCommitDiff> getCommitDiffs(Serializable projectId, String commitHash) throws IOException {
        return this.getCommitDiffs(projectId, commitHash, new Pagination());
    }

    public List<GitlabCommitDiff> getCommitDiffs(Serializable projectId, String commitHash, Pagination pagination) throws IOException {
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/repository/commits/" + commitHash + "/diff" + pagination;
        GitlabCommitDiff[] diffs = this.retrieve().to(tailUrl, GitlabCommitDiff[].class);
        return Arrays.asList(diffs);
    }

    public List<GitlabCommitStatus> getCommitStatuses(GitlabProject project, String commitHash) throws IOException {
        return this.getCommitStatuses(project, commitHash, new Pagination());
    }

    public List<GitlabCommitStatus> getCommitStatuses(GitlabProject project, String commitHash, Pagination pagination) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/repository" + "/commits" + "/" + commitHash + "/statuses" + pagination;
        GitlabCommitStatus[] statuses = this.retrieve().to(tailUrl, GitlabCommitStatus[].class);
        return Arrays.asList(statuses);
    }

    public GitlabCommitStatus createCommitStatus(GitlabProject project, String commitHash, String state, String ref, String name, String targetUrl, String description) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/statuses" + "/" + commitHash;
        return this.dispatch().with("state", state).with("ref", ref).with("name", name).with("target_url", targetUrl).with("description", description).to(tailUrl, GitlabCommitStatus.class);
    }

    public byte[] getRawFileContent(GitlabProject project, String sha, String filepath) throws IOException {
        Query query = new Query().append("filepath", filepath);
        String tailUrl = "/projects/" + project.getId() + "/repository/blobs/" + sha + query.toString();
        return this.retrieve().to(tailUrl, byte[].class);
    }

    public byte[] getRawBlobContent(GitlabProject project, String sha) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/repository/raw_blobs/" + sha;
        return this.retrieve().to(tailUrl, byte[].class);
    }

    public byte[] getFileArchive(GitlabProject project) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/repository/archive";
        return this.retrieve().to(tailUrl, byte[].class);
    }

    public List<GitlabRepositoryTree> getRepositoryTree(GitlabProject project, String path, String ref_name) throws IOException {
        Query query = new Query().appendIf("path", path).appendIf("ref_name", ref_name);
        String tailUrl = "/projects/" + project.getId() + "/repository" + GitlabRepositoryTree.URL + query.toString();
        GitlabRepositoryTree[] tree = this.retrieve().to(tailUrl, GitlabRepositoryTree[].class);
        return Arrays.asList(tree);
    }

    public GitlabNote updateNote(GitlabMergeRequest mergeRequest, Integer noteId, String body) throws IOException {
        Query query = new Query().appendIf("body", body);
        String tailUrl = "/projects/" + mergeRequest.getProjectId() + "/merge_requests" + "/" + mergeRequest.getId() + "/notes" + "/" + noteId + query.toString();
        return this.retrieve().method("PUT").to(tailUrl, GitlabNote.class);
    }

    public GitlabNote createNote(GitlabMergeRequest mergeRequest, String body) throws IOException {
        String tailUrl = "/projects/" + mergeRequest.getProjectId() + "/merge_requests" + "/" + mergeRequest.getId() + "/notes";
        return this.dispatch().with("body", body).to(tailUrl, GitlabNote.class);
    }

    public List<GitlabBranch> getBranches(Serializable projectId) throws IOException {
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/repository/branches/";
        GitlabBranch[] branches = this.retrieve().to(tailUrl, GitlabBranch[].class);
        return Arrays.asList(branches);
    }

    public List<GitlabBranch> getBranches(GitlabProject project) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/repository/branches/";
        GitlabBranch[] branches = this.retrieve().to(tailUrl, GitlabBranch[].class);
        return Arrays.asList(branches);
    }

    public void createBranch(GitlabProject project, String branchName, String ref) throws IOException {
        this.createBranch(project.getId(), branchName, ref);
    }

    public void createBranch(Serializable projectId, String branchName, String ref) throws IOException {
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/repository/branches/";
        this.dispatch().with("branch_name", branchName).with("ref", ref).to(tailUrl, Void.class);
    }

    public void deleteBranch(Serializable projectId, String branchName) throws IOException {
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/repository/branches/" + this.sanitizeBranch(branchName);
        this.retrieve().method("DELETE").to(tailUrl, Void.class);
    }

    public GitlabBranch getBranch(GitlabProject project, String branchName) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/repository/branches/" + this.sanitizeBranch(branchName);
        return this.retrieve().to(tailUrl, GitlabBranch.class);
    }

    public void protectBranch(GitlabProject project, String branchName) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/repository/branches/" + this.sanitizeBranch(branchName) + "/protect";
        this.retrieve().method("PUT").to(tailUrl, Void.class);
    }

    public void unprotectBranch(GitlabProject project, String branchName) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/repository/branches/" + this.sanitizeBranch(branchName) + "/unprotect";
        this.retrieve().method("PUT").to(tailUrl, Void.class);
    }

    public List<GitlabProjectHook> getProjectHooks(Serializable projectId) throws IOException {
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/hooks";
        GitlabProjectHook[] hooks = this.retrieve().to(tailUrl, GitlabProjectHook[].class);
        return Arrays.asList(hooks);
    }

    public List<GitlabProjectHook> getProjectHooks(GitlabProject project) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/hooks";
        GitlabProjectHook[] hooks = this.retrieve().to(tailUrl, GitlabProjectHook[].class);
        return Arrays.asList(hooks);
    }

    public GitlabProjectHook getProjectHook(GitlabProject project, String hookId) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/hooks" + "/" + hookId;
        return this.retrieve().to(tailUrl, GitlabProjectHook.class);
    }

    public GitlabProjectHook addProjectHook(GitlabProject project, String url) throws IOException {
        Query query = new Query().append("url", url);
        String tailUrl = "/projects/" + project.getId() + "/hooks" + query.toString();
        return this.dispatch().to(tailUrl, GitlabProjectHook.class);
    }

    public GitlabProjectHook addProjectHook(Serializable projectId, String url, boolean pushEvents, boolean issuesEvents, boolean mergeRequestEvents, boolean sslVerification) throws IOException {
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/hooks";
        return this.dispatch().with("url", url).with("push_events", pushEvents ? "true" : "false").with("issues_events", issuesEvents ? "true" : "false").with("merge_requests_events", mergeRequestEvents ? "true" : "false").with("enable_ssl_verification", sslVerification ? "true" : "false").to(tailUrl, GitlabProjectHook.class);
    }

    public GitlabProjectHook editProjectHook(GitlabProject project, String hookId, String url) throws IOException {
        Query query = new Query().append("url", url);
        String tailUrl = "/projects/" + project.getId() + "/hooks" + "/" + hookId + query.toString();
        return this.retrieve().method("PUT").to(tailUrl, GitlabProjectHook.class);
    }

    public void deleteProjectHook(GitlabProjectHook hook) throws IOException {
        String tailUrl = "/projects/" + hook.getProjectId() + "/hooks" + "/" + hook.getId();
        this.retrieve().method("DELETE").to(tailUrl, Void.class);
    }

    public void deleteProjectHook(GitlabProject project, String hookId) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/hooks" + "/" + hookId;
        this.retrieve().method("DELETE").to(tailUrl, Void.class);
    }

    public List<GitlabIssue> getIssues(GitlabProject project) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/issues";
        return this.retrieve().getAll(tailUrl, GitlabIssue[].class);
    }

    public GitlabIssue getIssue(Serializable projectId, Integer issueId) throws IOException {
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/issues" + "/" + issueId;
        return this.retrieve().to(tailUrl, GitlabIssue.class);
    }

    public GitlabIssue createIssue(int projectId, int assigneeId, int milestoneId, String labels, String description, String title) throws IOException {
        String tailUrl = "/projects/" + projectId + "/issues";
        GitlabHTTPRequestor requestor = this.dispatch();
        this.applyIssue(requestor, projectId, assigneeId, milestoneId, labels, description, title);
        return requestor.to(tailUrl, GitlabIssue.class);
    }

    public GitlabIssue editIssue(int projectId, int issueId, int assigneeId, int milestoneId, String labels, String description, String title, GitlabIssue.Action action) throws IOException {
        String tailUrl = "/projects/" + projectId + "/issues" + "/" + issueId;
        GitlabHTTPRequestor requestor = this.retrieve().method("PUT");
        this.applyIssue(requestor, projectId, assigneeId, milestoneId, labels, description, title);
        if (action != GitlabIssue.Action.LEAVE) {
            requestor.with("state_event", action.toString().toLowerCase());
        }
        return requestor.to(tailUrl, GitlabIssue.class);
    }

    private void applyIssue(GitlabHTTPRequestor requestor, int projectId, int assigneeId, int milestoneId, String labels, String description, String title) {
        requestor.with("title", title).with("description", description).with("labels", labels).with("milestone_id", milestoneId);
        if (assigneeId != 0) {
            requestor.with("assignee_id", assigneeId == -1 ? 0 : assigneeId);
        }
    }

    public List<GitlabNote> getNotes(GitlabIssue issue) throws IOException {
        String tailUrl = "/projects/" + issue.getProjectId() + "/issues" + "/" + issue.getId() + "/notes";
        return Arrays.asList((Object[])this.retrieve().to(tailUrl, GitlabNote[].class));
    }

    public GitlabNote createNote(Serializable projectId, Integer issueId, String message) throws IOException {
        String tailUrl = "/projects/" + projectId + "/issues" + "/" + issueId + "/notes";
        return this.dispatch().with("body", message).to(tailUrl, GitlabNote.class);
    }

    public GitlabNote createNote(GitlabIssue issue, String message) throws IOException {
        return this.createNote((Serializable)((Object)String.valueOf(issue.getProjectId())), issue.getId(), message);
    }

    public List<GitlabLabel> getLabels(Serializable projectId) throws IOException {
        String tailUrl = "/projects/" + projectId + "/labels";
        GitlabLabel[] labels = this.retrieve().to(tailUrl, GitlabLabel[].class);
        return Arrays.asList(labels);
    }

    public List<GitlabLabel> getLabels(GitlabProject project) throws IOException {
        return this.getLabels(project.getId());
    }

    public GitlabLabel createLabel(Serializable projectId, String name, String color) throws IOException {
        String tailUrl = "/projects/" + projectId + "/labels";
        return this.dispatch().with("name", name).with("color", color).to(tailUrl, GitlabLabel.class);
    }

    public GitlabLabel createLabel(Serializable projectId, GitlabLabel label) throws IOException {
        String name = label.getName();
        String color = label.getColor();
        return this.createLabel(projectId, name, color);
    }

    public void deleteLabel(Serializable projectId, String name) throws IOException {
        Query query = new Query();
        query.append("name", name);
        String tailUrl = "/projects/" + projectId + "/labels" + query.toString();
        this.retrieve().method("DELETE").to(tailUrl, Void.class);
    }

    public void deleteLabel(Serializable projectId, GitlabLabel label) throws IOException {
        this.deleteLabel(projectId, label.getName());
    }

    public GitlabLabel updateLabel(Serializable projectId, String name, String newName, String newColor) throws IOException {
        String tailUrl = "/projects/" + projectId + "/labels";
        GitlabHTTPRequestor requestor = this.retrieve().method("PUT");
        requestor.with("name", name);
        if (newName != null) {
            requestor.with("new_name", newName);
        }
        if (newColor != null) {
            requestor = requestor.with("color", newColor);
        }
        return requestor.to(tailUrl, GitlabLabel.class);
    }

    public List<GitlabMilestone> getMilestones(GitlabProject project) throws IOException {
        return this.getMilestones((Serializable)((Object)String.valueOf(project.getId())));
    }

    public List<GitlabMilestone> getMilestones(Serializable projectId) throws IOException {
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/milestones";
        return Arrays.asList((Object[])this.retrieve().to(tailUrl, GitlabMilestone[].class));
    }

    public GitlabMilestone createMilestone(Serializable projectId, String title, String description, Date dueDate) throws IOException {
        String tailUrl = "/projects/" + projectId + "/milestones";
        GitlabHTTPRequestor requestor = this.dispatch().with("title", title);
        if (description != null) {
            requestor = requestor.with("description", description);
        }
        if (dueDate != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            String formatted = formatter.format(dueDate);
            requestor = requestor.with("due_date", formatted);
        }
        return requestor.to(tailUrl, GitlabMilestone.class);
    }

    public GitlabMilestone createMilestone(Serializable projectId, GitlabMilestone milestone) throws IOException {
        String title = milestone.getTitle();
        String description = milestone.getDescription();
        Date dateDue = milestone.getDueDate();
        return this.createMilestone(projectId, title, description, dateDue);
    }

    public GitlabMilestone updateMilestone(Serializable projectId, int milestoneId, String title, String description, Date dueDate, String stateEvent) throws IOException {
        String tailUrl = "/projects/" + projectId + "/milestones" + "/" + milestoneId;
        GitlabHTTPRequestor requestor = this.retrieve().method("PUT");
        if (title != null) {
            requestor.with("title", title);
        }
        if (description != null) {
            requestor = requestor.with("description", description);
        }
        if (dueDate != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            String formatted = formatter.format(dueDate);
            requestor = requestor.with("due_date", formatted);
        }
        if (stateEvent != null) {
            requestor.with("state_event", stateEvent);
        }
        return requestor.to(tailUrl, GitlabMilestone.class);
    }

    public GitlabMilestone updateMilestone(Serializable projectId, GitlabMilestone edited, String stateEvent) throws IOException {
        return this.updateMilestone(projectId, edited.getId(), edited.getTitle(), edited.getDescription(), edited.getDueDate(), stateEvent);
    }

    public GitlabMilestone updateMilestone(GitlabMilestone edited, String stateEvent) throws IOException {
        return this.updateMilestone(Integer.valueOf(edited.getProjectId()), edited, stateEvent);
    }

    public GitlabProjectMember addProjectMember(GitlabProject project, GitlabUser user, GitlabAccessLevel accessLevel) throws IOException {
        return this.addProjectMember(project.getId(), user.getId(), accessLevel);
    }

    public GitlabProjectMember addProjectMember(Integer projectId, Integer userId, GitlabAccessLevel accessLevel) throws IOException {
        Query query = new Query().appendIf("id", projectId).appendIf("user_id", userId).appendIf("access_level", accessLevel);
        String tailUrl = "/projects/" + projectId + "/members" + query.toString();
        return this.dispatch().to(tailUrl, GitlabProjectMember.class);
    }

    public void deleteProjectMember(GitlabProject project, GitlabUser user) throws IOException {
        this.deleteProjectMember(project.getId(), user.getId());
    }

    public void deleteProjectMember(Integer projectId, Integer userId) throws IOException {
        String tailUrl = "/projects/" + projectId + "/" + "/members" + "/" + userId;
        this.retrieve().method("DELETE").to(tailUrl, Void.class);
    }

    public List<GitlabProjectMember> getProjectMembers(GitlabProject project) throws IOException {
        return this.getProjectMembers(project.getId());
    }

    public List<GitlabProjectMember> getProjectMembers(Serializable projectId) throws IOException {
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/members";
        return Arrays.asList((Object[])this.retrieve().to(tailUrl, GitlabProjectMember[].class));
    }

    public List<GitlabProjectMember> getNamespaceMembers(GitlabNamespace namespace) throws IOException {
        return this.getNamespaceMembers(namespace.getId());
    }

    public List<GitlabProjectMember> getNamespaceMembers(Integer namespaceId) throws IOException {
        String tailUrl = "/groups/" + namespaceId + "/members";
        return Arrays.asList((Object[])this.retrieve().to(tailUrl, GitlabProjectMember[].class));
    }

    public void transfer(Integer namespaceId, Integer projectId) throws IOException {
        String tailUrl = "/groups/" + namespaceId + "/projects" + "/" + projectId;
        this.dispatch().to(tailUrl, Void.class);
    }

    public GitlabSSHKey createDeployKey(Integer targetProjectId, String title, String key) throws IOException {
        Query query = new Query().append("title", title).append("key", key);
        String tailUrl = "/projects/" + targetProjectId + GitlabSSHKey.KEYS_URL + query.toString();
        return this.dispatch().to(tailUrl, GitlabSSHKey.class);
    }

    public void deleteDeployKey(Integer targetProjectId, Integer targetKeyId) throws IOException {
        String tailUrl = "/projects/" + targetProjectId + GitlabSSHKey.KEYS_URL + "/" + targetKeyId;
        this.retrieve().method("DELETE").to(tailUrl, Void.class);
    }

    public List<GitlabSSHKey> getDeployKeys(Integer targetProjectId) throws IOException {
        String tailUrl = "/projects/" + targetProjectId + GitlabSSHKey.KEYS_URL;
        return Arrays.asList((Object[])this.retrieve().to(tailUrl, GitlabSSHKey[].class));
    }

    public GitlabSession getCurrentSession() throws IOException {
        String tailUrl = "/user";
        return this.retrieve().to(tailUrl, GitlabSession.class);
    }

    public List<GitlabSystemHook> getSystemHooks() throws IOException {
        String tailUrl = "/hooks";
        return Arrays.asList((Object[])this.retrieve().to(tailUrl, GitlabSystemHook[].class));
    }

    public GitlabSystemHook addSystemHook(String url) throws IOException {
        String tailUrl = "/hooks";
        return this.dispatch().with("url", url).to(tailUrl, GitlabSystemHook.class);
    }

    public void testSystemHook(Integer hookId) throws IOException {
        String tailUrl = "/hooks/" + hookId;
        this.retrieve().to(tailUrl, Void.class);
    }

    public GitlabSystemHook deleteSystemHook(Integer hookId) throws IOException {
        String tailUrl = "/hooks/" + hookId;
        return this.retrieve().method("DELETE").to(tailUrl, GitlabSystemHook.class);
    }

    private String sanitizeProjectId(Serializable projectId) {
        if (!(projectId instanceof String) && !(projectId instanceof Number)) {
            throw new IllegalArgumentException("projectId needs to be of type String or Number");
        }
        try {
            return URLEncoder.encode(String.valueOf(projectId), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String sanitizeBranch(String branch) {
        try {
            return URLEncoder.encode(branch, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public CommitComment createCommitComment(Integer projectId, String sha, String note, String path, String line, String line_type) throws IOException {
        Query query = new Query().append("id", projectId.toString()).appendIf("sha", sha).appendIf("note", note).appendIf("path", path).appendIf("line", line).appendIf("line_type", line_type);
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/repository/commits/" + sha + "/comments" + query.toString();
        return this.dispatch().to(tailUrl, CommitComment.class);
    }

    public List<CommitComment> getCommitComments(Integer projectId, String sha) throws IOException {
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/repository/commits/" + sha + "/comments";
        return Arrays.asList((Object[])this.retrieve().to(tailUrl, CommitComment[].class));
    }
}

