/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab.api.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.gitlab.api.AuthMethod;
import org.gitlab.api.GitlabAPI;
import org.gitlab.api.GitlabAPIException;
import org.gitlab.api.TokenType;
import org.gitlab.api.models.GitlabCommit;

public class GitlabHTTPRequestor {
    private static final Pattern PAGE_PATTERN = Pattern.compile("([&|?])page=(\\d+)");
    private final GitlabAPI root;
    private String method = "GET";
    private Map<String, Object> data = new HashMap<String, Object>();
    private String apiToken;
    private TokenType tokenType;
    private AuthMethod authMethod;

    public GitlabHTTPRequestor(GitlabAPI root) {
        this.root = root;
    }

    public GitlabHTTPRequestor authenticate(String token, TokenType type, AuthMethod method) {
        this.apiToken = token;
        this.tokenType = type;
        this.authMethod = method;
        return this;
    }

    public GitlabHTTPRequestor method(String method) {
        try {
            this.method = METHOD.valueOf(method).toString();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid HTTP Method: " + method + ". Must be one of " + METHOD.prettyValues());
        }
        return this;
    }

    public GitlabHTTPRequestor with(String key, Object value) {
        if (value != null && key != null) {
            this.data.put(key, value);
        }
        return this;
    }

    public <T> T to(String tailAPIUrl, T instance) throws IOException {
        return this.to(tailAPIUrl, null, instance);
    }

    public <T> T to(String tailAPIUrl, Class<T> type) throws IOException {
        return this.to(tailAPIUrl, type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T to(String tailAPIUrl, Class<T> type, T instance) throws IOException {
        HttpURLConnection connection = null;
        try {
            T t;
            connection = this.setupConnection(this.root.getAPIUrl(tailAPIUrl));
            if (this.hasOutput()) {
                this.submitData(connection);
            } else if ("PUT".equals(this.method)) {
                connection.setDoOutput(true);
                connection.setFixedLengthStreamingMode(0);
            }
            try {
                t = this.parse(connection, type, instance);
            }
            catch (IOException e) {
                T t2;
                block10: {
                    this.handleAPIError(e, connection);
                    t2 = null;
                    if (connection == null) break block10;
                    connection.disconnect();
                }
                return t2;
            }
            return t;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public <T> List<T> getAll(String tailUrl, Class<T[]> type) {
        ArrayList<T> results = new ArrayList<T>();
        Iterator<T[]> iterator = this.asIterator(tailUrl, type);
        while (iterator.hasNext()) {
            T[] requests = iterator.next();
            if (requests.length <= 0) continue;
            results.addAll(Arrays.asList(requests));
        }
        return results;
    }

    public <T> Iterator<T> asIterator(final String tailApiUrl, final Class<T> type) {
        this.method("GET");
        if (!this.data.isEmpty()) {
            throw new IllegalStateException();
        }
        return new Iterator<T>(){
            T next;
            URL url;
            {
                try {
                    this.url = GitlabHTTPRequestor.this.root.getAPIUrl(tailApiUrl);
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }

            @Override
            public boolean hasNext() {
                this.fetch();
                if (this.next != null && this.next.getClass().isArray()) {
                    Object[] arr = (Object[])this.next;
                    return arr.length != 0;
                }
                return this.next != null;
            }

            @Override
            public T next() {
                this.fetch();
                Object record = this.next;
                if (record == null) {
                    throw new NoSuchElementException();
                }
                this.next = null;
                return record;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void fetch() {
                if (this.next != null) {
                    return;
                }
                if (this.url == null) {
                    return;
                }
                try {
                    HttpURLConnection connection = GitlabHTTPRequestor.this.setupConnection(this.url);
                    try {
                        this.next = GitlabHTTPRequestor.this.parse(connection, type, null);
                        assert (this.next != null);
                        this.findNextUrl();
                    }
                    catch (IOException e) {
                        GitlabHTTPRequestor.this.handleAPIError(e, connection);
                    }
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }

            private void findNextUrl() throws MalformedURLException {
                String url = this.url.toString();
                this.url = null;
                Matcher matcher = PAGE_PATTERN.matcher(url);
                if (matcher.find()) {
                    Integer page = Integer.parseInt(matcher.group(2)) + 1;
                    this.url = new URL(matcher.replaceAll(matcher.group(1) + "page=" + page));
                } else {
                    this.url = GitlabCommit[].class == type ? new URL(url + (url.indexOf(63) > 0 ? (char)'&' : '?') + "page=1") : new URL(url + (url.indexOf(63) > 0 ? (char)'&' : '?') + "&page=2");
                }
            }
        };
    }

    private void submitData(HttpURLConnection connection) throws IOException {
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "application/json");
        GitlabAPI.MAPPER.writeValue(connection.getOutputStream(), this.data);
    }

    private boolean hasOutput() {
        return this.method.equals("POST") || this.method.equals("PUT") && !this.data.isEmpty();
    }

    private HttpURLConnection setupConnection(URL url) throws IOException {
        int requestTimeout;
        if (this.root.isIgnoreCertificateErrors()) {
            this.ignoreCertificateErrors();
        }
        if (this.apiToken != null && this.authMethod == AuthMethod.URL_PARAMETER) {
            String urlWithAuth = url.toString();
            urlWithAuth = urlWithAuth + (urlWithAuth.indexOf(63) > 0 ? (char)'&' : '?') + this.tokenType.getTokenParamName() + "=" + this.apiToken;
            url = new URL(urlWithAuth);
        }
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if (this.apiToken != null && this.authMethod == AuthMethod.HEADER) {
            connection.setRequestProperty(this.tokenType.getTokenHeaderName(), String.format(this.tokenType.getTokenHeaderFormat(), this.apiToken));
        }
        if ((requestTimeout = this.root.getRequestTimeout()) > 0) {
            connection.setReadTimeout(requestTimeout);
        }
        try {
            connection.setRequestMethod(this.method);
        }
        catch (ProtocolException e) {
            try {
                Field methodField = connection.getClass().getDeclaredField("method");
                methodField.setAccessible(true);
                methodField.set(connection, this.method);
            }
            catch (Exception x) {
                throw (IOException)new IOException("Failed to set the custom verb").initCause(x);
            }
        }
        connection.setRequestProperty("Accept-Encoding", "gzip");
        return connection;
    }

    private <T> T parse(HttpURLConnection connection, Class<T> type, T instance) throws IOException {
        T t;
        InputStreamReader reader;
        block9: {
            String data;
            block8: {
                block7: {
                    reader = null;
                    reader = new InputStreamReader(this.wrapStream(connection, connection.getInputStream()), "UTF-8");
                    if (byte[].class != type) break block7;
                    T t2 = type.cast(IOUtils.toByteArray((Reader)reader));
                    IOUtils.closeQuietly((Reader)reader);
                    return t2;
                }
                data = IOUtils.toString((Reader)reader);
                if (type == null) break block8;
                Object object = GitlabAPI.MAPPER.readValue(data, type);
                IOUtils.closeQuietly((Reader)reader);
                return (T)object;
            }
            if (instance == null) break block9;
            Object object = GitlabAPI.MAPPER.readerForUpdating(instance).readValue(data);
            IOUtils.closeQuietly((Reader)reader);
            return (T)object;
        }
        try {
            t = null;
        }
        catch (SSLHandshakeException e) {
            try {
                throw new SSLHandshakeException("You can disable certificate checking by setting ignoreCertificateErrors on GitlabHTTPRequestor. SSL Error: " + e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return t;
    }

    private InputStream wrapStream(HttpURLConnection connection, InputStream inputStream) throws IOException {
        String encoding = connection.getContentEncoding();
        if (encoding == null || inputStream == null) {
            return inputStream;
        }
        if (encoding.equals("gzip")) {
            return new GZIPInputStream(inputStream);
        }
        throw new UnsupportedOperationException("Unexpected Content-Encoding: " + encoding);
    }

    private void handleAPIError(IOException e, HttpURLConnection connection) throws IOException {
        if (e instanceof FileNotFoundException) {
            throw e;
        }
        if (e instanceof SocketTimeoutException && this.root.getRequestTimeout() > 0) {
            throw e;
        }
        InputStream es = this.wrapStream(connection, connection.getErrorStream());
        try {
            String error = null;
            if (es != null) {
                error = IOUtils.toString((InputStream)es, (String)"UTF-8");
            }
            throw new GitlabAPIException(error, connection.getResponseCode(), e);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)es);
            throw throwable;
        }
    }

    private void ignoreCertificateErrors() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        HostnameVerifier nullVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(nullVerifier);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static enum METHOD {
        GET,
        PUT,
        POST,
        PATCH,
        DELETE,
        HEAD,
        OPTIONS,
        TRACE;


        public static String prettyValues() {
            METHOD[] methods = METHOD.values();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < methods.length; ++i) {
                METHOD method = methods[i];
                builder.append(method.toString());
                if (i == methods.length - 1) continue;
                builder.append(", ");
            }
            return builder.toString();
        }
    }
}

