/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab.api.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.gitlab.api.GitlabAPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitlabHTTPRequestor {
    private final GitlabAPI _root;
    private String _method = "GET";
    private Map<String, Object> _data = new HashMap<String, Object>();

    public GitlabHTTPRequestor(GitlabAPI root) {
        this._root = root;
    }

    public GitlabHTTPRequestor method(String method) {
        try {
            this._method = METHOD.valueOf(method).toString();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid HTTP Method: " + method + ". Must be one of " + METHOD.prettyValues());
        }
        return this;
    }

    public GitlabHTTPRequestor with(String key, Object value) {
        if (value != null && key != null) {
            this._data.put(key, value);
        }
        return this;
    }

    public <T> T to(String tailAPIUrl, T instance) throws IOException {
        return this.to(tailAPIUrl, null, instance);
    }

    public <T> T to(String tailAPIUrl, Class<T> type) throws IOException {
        return this.to(tailAPIUrl, type, null);
    }

    public <T> T to(String tailAPIUrl, Class<T> type, T instance) throws IOException {
        HttpURLConnection connection = this.setupConnection(this._root.getAPIUrl(tailAPIUrl));
        if (this.hasOutput()) {
            this.submitData(connection);
        }
        try {
            return this.parse(connection, type, instance);
        }
        catch (IOException e) {
            this.handleAPIError(e, connection);
            return null;
        }
    }

    public <T> Iterator<T> asIterator(final String tailApiUrl, final Class<T> type) {
        this.method("GET");
        if (!this._data.isEmpty()) {
            throw new IllegalStateException();
        }
        return new Iterator<T>(){
            T _next;
            URL _url;
            {
                try {
                    this._url = GitlabHTTPRequestor.this._root.getAPIUrl(tailApiUrl);
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }

            @Override
            public boolean hasNext() {
                this.fetch();
                if (this._next.getClass().isArray()) {
                    Object[] arr = (Object[])this._next;
                    return arr.length != 0;
                }
                return this._next != null;
            }

            @Override
            public T next() {
                this.fetch();
                Object record = this._next;
                if (record == null) {
                    throw new NoSuchElementException();
                }
                this._next = null;
                return record;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void fetch() {
                if (this._next != null) {
                    return;
                }
                if (this._url == null) {
                    return;
                }
                try {
                    HttpURLConnection connection = GitlabHTTPRequestor.this.setupConnection(this._url);
                    try {
                        this._next = GitlabHTTPRequestor.this.parse(connection, type, null);
                        assert (this._next != null);
                        this.findNextUrl(connection);
                    }
                    catch (IOException e) {
                        GitlabHTTPRequestor.this.handleAPIError(e, connection);
                    }
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }

            private void findNextUrl(HttpURLConnection connection) throws MalformedURLException {
                String url = this._url.toString();
                this._url = null;
                Pattern pattern = Pattern.compile("([&|?])page=(\\d+)");
                Matcher matcher = pattern.matcher(url);
                if (matcher.find()) {
                    Integer page = Integer.parseInt(matcher.group(2)) + 1;
                    this._url = new URL(matcher.replaceAll(matcher.group(1) + "page=" + page));
                } else {
                    this._url = new URL(url + "&page=2");
                }
            }
        };
    }

    private void submitData(HttpURLConnection connection) throws IOException {
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "application/json");
        GitlabAPI.MAPPER.writeValue(connection.getOutputStream(), this._data);
    }

    private boolean hasOutput() {
        return this._method.equals("POST") || this._method.equals("PUT") && !this._data.isEmpty();
    }

    private HttpURLConnection setupConnection(URL url) throws IOException {
        if (this._root.isIgnoreCertificateErrors()) {
            this.ignoreCertificateErrors();
        }
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        try {
            connection.setRequestMethod(this._method);
        }
        catch (ProtocolException e) {
            try {
                Field methodField = connection.getClass().getDeclaredField("method");
                methodField.setAccessible(true);
                methodField.set(connection, this._method);
            }
            catch (Exception x) {
                throw (IOException)new IOException("Failed to set the custom verb").initCause(x);
            }
        }
        connection.setRequestProperty("Accept-Encoding", "gzip");
        return connection;
    }

    private <T> T parse(HttpURLConnection connection, Class<T> type, T instance) throws IOException {
        T t;
        InputStreamReader reader;
        block7: {
            String data;
            block6: {
                reader = null;
                reader = new InputStreamReader(this.wrapStream(connection, connection.getInputStream()), "UTF-8");
                data = IOUtils.toString((Reader)reader);
                if (type == null) break block6;
                Object object = GitlabAPI.MAPPER.readValue(data, type);
                IOUtils.closeQuietly((Reader)reader);
                return (T)object;
            }
            if (instance == null) break block7;
            Object object = GitlabAPI.MAPPER.readerForUpdating(instance).readValue(data);
            IOUtils.closeQuietly((Reader)reader);
            return (T)object;
        }
        try {
            t = null;
        }
        catch (SSLHandshakeException e) {
            try {
                throw new SSLHandshakeException("You can disable certificate checking by setting ignoreCertificateErrors on GitlabHTTPRequestor");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return t;
    }

    private InputStream wrapStream(HttpURLConnection connection, InputStream inputStream) throws IOException {
        String encoding = connection.getContentEncoding();
        if (encoding == null || inputStream == null) {
            return inputStream;
        }
        if (encoding.equals("gzip")) {
            return new GZIPInputStream(inputStream);
        }
        throw new UnsupportedOperationException("Unexpected Content-Encoding: " + encoding);
    }

    private void handleAPIError(IOException e, HttpURLConnection connection) throws IOException {
        if (e instanceof FileNotFoundException) {
            throw e;
        }
        InputStream es = this.wrapStream(connection, connection.getErrorStream());
        try {
            if (es != null) {
                throw (IOException)new IOException(IOUtils.toString((InputStream)es, (String)"UTF-8")).initCause(e);
            }
            throw e;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)es);
            throw throwable;
        }
    }

    private void ignoreCertificateErrors() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum METHOD {
        GET,
        PUT,
        POST,
        PATCH,
        DELETE,
        HEAD,
        OPTIONS,
        TRACE;


        public static String prettyValues() {
            METHOD[] methods = METHOD.values();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < methods.length; ++i) {
                METHOD method = methods[i];
                builder.append(method.toString());
                if (i == methods.length - 1) continue;
                builder.append(", ");
            }
            return builder.toString();
        }
    }
}

