/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.jaxb.gco;

import java.util.UUID;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.xml.XLink;
import org.geotoolkit.internal.jaxb.MarshalContext;
import org.geotoolkit.internal.jaxb.SpecializedIdentifier;
import org.geotoolkit.internal.jaxb.gco.ObjectIdentification;
import org.geotoolkit.xml.IdentifiedObject;
import org.geotoolkit.xml.IdentifierMap;
import org.geotoolkit.xml.IdentifierSpace;
import org.geotoolkit.xml.ObjectLinker;
import org.opengis.metadata.Identifier;

final class ObjectReference {
    String anyUUID;
    XLink xlink;
    private transient UUID uuid;

    ObjectReference() {
    }

    ObjectReference(UUID uUID, String string, XLink xLink) {
        this.uuid = uUID;
        this.anyUUID = string;
        this.xlink = xLink;
    }

    static UUID toUUID(String string) throws IllegalArgumentException {
        return string != null ? MarshalContext.converters().toUUID(string) : null;
    }

    final <T> T resolve(Class<T> clazz, T t) throws IllegalArgumentException {
        if (this.uuid == null) {
            this.uuid = ObjectReference.toUUID(this.anyUUID);
        }
        if (t == null) {
            ObjectLinker objectLinker = MarshalContext.linker();
            if (!(this.uuid != null && (t = objectLinker.resolve(clazz, this.uuid)) != null || this.xlink != null && (t = objectLinker.resolve(clazz, this.xlink)) != null)) {
                int n = 0;
                Object[] objectArray = new SpecializedIdentifier[2];
                if (this.uuid != null) {
                    objectArray[n++] = new SpecializedIdentifier<UUID>(IdentifierSpace.UUID, this.uuid);
                }
                if (this.xlink != null) {
                    objectArray[n++] = new SpecializedIdentifier<XLink>(IdentifierSpace.XLINK, this.xlink);
                }
                objectArray = (SpecializedIdentifier[])ArraysExt.resize((Object[])objectArray, (int)n);
                t = objectLinker.newIdentifiedObject(clazz, (Identifier[])objectArray);
            }
        } else {
            Object object;
            if (this.uuid != null && t.equals(object = ObjectIdentification.UUIDs.lookup(this.uuid))) {
                return clazz.cast(object);
            }
            if (t instanceof IdentifiedObject) {
                object = ((IdentifiedObject)t).getIdentifierMap();
                if (this.uuid != null) {
                    new SpecializedIdentifier<UUID>(IdentifierSpace.UUID, this.uuid).putInto((IdentifierMap)object);
                }
                if (this.xlink != null) {
                    new SpecializedIdentifier<XLink>(IdentifierSpace.XLINK, this.xlink).putInto((IdentifierMap)object);
                }
            }
        }
        return t;
    }
}

