/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.jaxb;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.internal.jaxb.IdentifierMapEntry;
import org.geotoolkit.internal.jaxb.IdentifierMapWithSpecialCases;
import org.geotoolkit.internal.jaxb.SpecializedIdentifier;
import org.geotoolkit.util.UnsupportedImplementationException;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.XCollections;
import org.geotoolkit.xml.IdentifierMap;
import org.geotoolkit.xml.IdentifierSpace;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;

public class IdentifierMapAdapter
extends AbstractMap<Citation, String>
implements IdentifierMap,
Serializable {
    private static final long serialVersionUID = 2661044384787218964L;
    public static final IdentifierMap EMPTY = new IdentifierMapAdapter(Collections.<Identifier>emptySet());
    public final Collection<Identifier> identifiers;
    private transient Set<Map.Entry<Citation, String>> entries;

    IdentifierMapAdapter(Collection<Identifier> collection) {
        this.identifiers = collection;
    }

    public static <T extends Identifier> IdentifierMapAdapter create(Class<T> clazz, Collection<T> collection) {
        if (clazz == Identifier.class) {
            return new IdentifierMapWithSpecialCases(collection);
        }
        throw new UnsupportedImplementationException(clazz);
    }

    @Override
    public void clear() throws UnsupportedOperationException {
        this.identifiers.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.identifiers.isEmpty();
    }

    @Override
    public boolean containsValue(Object object) {
        if (object instanceof String) {
            for (Identifier identifier : this.identifiers) {
                if (identifier == null || !Utilities.equals((Object)object, (Object)identifier.getCode())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsKey(Object object) {
        return object instanceof Citation && this.getIdentifier((Citation)object) != null;
    }

    private Identifier getIdentifier(Citation citation) {
        for (Identifier identifier : this.identifiers) {
            if (identifier == null || !Utilities.equals((Object)citation, (Object)identifier.getAuthority())) continue;
            return identifier;
        }
        return null;
    }

    @Override
    public <T> T getSpecialized(IdentifierSpace<T> identifierSpace) {
        Identifier identifier = this.getIdentifier(identifierSpace);
        return identifier instanceof SpecializedIdentifier ? (T)((SpecializedIdentifier)identifier).value : null;
    }

    @Override
    public String get(Object object) {
        Identifier identifier;
        if (object instanceof Citation && (identifier = this.getIdentifier((Citation)object)) != null) {
            return identifier.getCode();
        }
        return null;
    }

    @Override
    public String remove(Object object) {
        return object instanceof Citation ? this.put((Citation)object, null) : null;
    }

    @Override
    public String put(Citation citation, String string) throws UnsupportedOperationException {
        ArgumentChecks.ensureNonNull((String)"authority", (Object)citation);
        String string2 = null;
        Iterator<Identifier> iterator = this.identifiers.iterator();
        while (iterator.hasNext()) {
            Identifier identifier = iterator.next();
            if (identifier == null) {
                iterator.remove();
                continue;
            }
            if (!Utilities.equals((Object)citation, (Object)identifier.getAuthority())) continue;
            if (string != null && identifier instanceof IdentifierMapEntry) {
                return ((IdentifierMapEntry)identifier).setValue(string);
            }
            if (string2 == null) {
                string2 = identifier.getCode();
            }
            iterator.remove();
        }
        if (string != null) {
            this.identifiers.add(SpecializedIdentifier.parse(citation, string));
        }
        return string2;
    }

    @Override
    public <T> T putSpecialized(IdentifierSpace<T> identifierSpace, T t) throws UnsupportedOperationException {
        ArgumentChecks.ensureNonNull((String)"authority", identifierSpace);
        T t2 = null;
        Iterator<Identifier> iterator = this.identifiers.iterator();
        while (iterator.hasNext()) {
            Identifier identifier = iterator.next();
            if (identifier == null) {
                iterator.remove();
                continue;
            }
            if (!Utilities.equals(identifierSpace, (Object)identifier.getAuthority())) continue;
            if (identifier instanceof SpecializedIdentifier) {
                SpecializedIdentifier specializedIdentifier = (SpecializedIdentifier)identifier;
                if (t2 == null) {
                    t2 = specializedIdentifier.value;
                }
                if (t != null) {
                    specializedIdentifier.value = t;
                    return t2;
                }
            }
            iterator.remove();
        }
        if (t != null) {
            this.identifiers.add(new SpecializedIdentifier<T>(identifierSpace, t));
        }
        return t2;
    }

    final boolean putSpecialized(SpecializedIdentifier<?> specializedIdentifier) throws UnsupportedOperationException {
        assert (this.put(specializedIdentifier.getAuthority(), null) == null) : specializedIdentifier;
        this.identifiers.add(specializedIdentifier);
        return true;
    }

    @Override
    public synchronized Set<Map.Entry<Citation, String>> entrySet() {
        if (this.entries == null) {
            this.entries = new Entries(this.identifiers);
        }
        return this.entries;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append('{');
        for (Map.Entry<Citation, String> entry : this.entrySet()) {
            if (stringBuilder.length() != 1) {
                stringBuilder.append(", ");
            }
            SpecializedIdentifier.format(stringBuilder, entry.getKey(), entry.getValue());
        }
        return stringBuilder.append('}').toString();
    }

    private static final class Iter
    extends HashMap<Citation, Boolean>
    implements Iterator<Map.Entry<Citation, String>> {
        private Iterator<? extends Identifier> identifiers;
        private transient Map.Entry<Citation, String> next;
        private transient Citation authority;

        Iter(Collection<? extends Identifier> collection) {
            super(XCollections.hashMapCapacity((int)collection.size()));
            this.identifiers = collection.iterator();
        }

        private void toNext() {
            Iterator<? extends Identifier> iterator = this.identifiers;
            if (iterator != null) {
                while (iterator.hasNext()) {
                    Identifier identifier = iterator.next();
                    if (identifier == null) continue;
                    Citation citation = identifier.getAuthority();
                    Boolean bl = this.put(citation, Boolean.FALSE);
                    if (bl == null) {
                        this.next = identifier instanceof IdentifierMapEntry ? (IdentifierMapEntry)identifier : new IdentifierMapEntry.Immutable(citation, identifier.getCode());
                        this.authority = citation;
                        return;
                    }
                    if (bl != Boolean.TRUE) continue;
                    iterator.remove();
                }
                this.identifiers = null;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                this.toNext();
            }
            return this.identifiers != null;
        }

        @Override
        public Map.Entry<Citation, String> next() throws NoSuchElementException {
            Map.Entry<Citation, String> entry = this.next;
            if (entry == null) {
                this.toNext();
                entry = this.next;
            }
            this.next = null;
            if (this.identifiers == null) {
                throw new NoSuchElementException();
            }
            return entry;
        }

        @Override
        public void remove() throws IllegalStateException {
            Iterator<? extends Identifier> iterator = this.identifiers;
            if (iterator == null || this.next != null) {
                throw new IllegalStateException();
            }
            iterator.remove();
            this.put(this.authority, Boolean.TRUE);
        }
    }

    private static final class Entries
    extends AbstractSet<Map.Entry<Citation, String>> {
        private final Collection<? extends Identifier> identifiers;

        Entries(Collection<? extends Identifier> collection) {
            this.identifiers = collection;
        }

        @Override
        public void clear() throws UnsupportedOperationException {
            this.identifiers.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.identifiers.isEmpty();
        }

        @Override
        public int size() {
            HashMap hashMap = new HashMap();
            for (Identifier identifier : this.identifiers) {
                if (identifier == null) continue;
                hashMap.put(identifier.getAuthority(), null);
            }
            return hashMap.size();
        }

        @Override
        public Iterator<Map.Entry<Citation, String>> iterator() {
            return new Iter(this.identifiers);
        }
    }
}

