/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.jaxb;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.geotoolkit.factory.FactoryNotFoundException;
import org.geotoolkit.internal.jaxb.MarshalContext;
import org.geotoolkit.lang.Static;
import org.geotoolkit.resources.Errors;

public final class XmlUtilities
extends Static {
    private static DatatypeFactory factory;
    private static final ThreadLocal<Calendar> CALENDAR;

    private XmlUtilities() {
    }

    public static synchronized DatatypeFactory getDatatypeFactory() throws FactoryNotFoundException {
        if (factory == null) {
            try {
                factory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                throw new FactoryNotFoundException(Errors.format((int)63, DatatypeFactory.class), (Throwable)datatypeConfigurationException);
            }
        }
        return factory;
    }

    public static boolean trimTime(XMLGregorianCalendar xMLGregorianCalendar, boolean bl) {
        if (bl || xMLGregorianCalendar.getMillisecond() == 0) {
            xMLGregorianCalendar.setMillisecond(Integer.MIN_VALUE);
            if (bl || xMLGregorianCalendar.getHour() == 0 && xMLGregorianCalendar.getMinute() == 0 && xMLGregorianCalendar.getSecond() == 0) {
                xMLGregorianCalendar.setHour(Integer.MIN_VALUE);
                xMLGregorianCalendar.setMinute(Integer.MIN_VALUE);
                xMLGregorianCalendar.setSecond(Integer.MIN_VALUE);
                xMLGregorianCalendar.setTimezone(Integer.MIN_VALUE);
                return true;
            }
        }
        return false;
    }

    public static XMLGregorianCalendar toXML(Date date) {
        if (date != null) {
            GregorianCalendar gregorianCalendar = MarshalContext.createGregorianCalendar();
            gregorianCalendar.setTime(date);
            return XmlUtilities.getDatatypeFactory().newXMLGregorianCalendar(gregorianCalendar);
        }
        return null;
    }

    public static Date toDate(XMLGregorianCalendar xMLGregorianCalendar) {
        if (xMLGregorianCalendar != null) {
            return xMLGregorianCalendar.toGregorianCalendar().getTime();
        }
        return null;
    }

    public static Date parseDateTime(String string) throws IllegalArgumentException {
        if (string == null) {
            return null;
        }
        return DatatypeConverter.parseDateTime((String)string).getTime();
    }

    public static String printDateTime(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = CALENDAR.get();
        calendar.setTime(date);
        return DatatypeConverter.printDateTime((Calendar)calendar);
    }

    static {
        CALENDAR = new ThreadLocal<Calendar>(){

            @Override
            protected Calendar initialValue() {
                return new GregorianCalendar(TimeZone.getTimeZone("UTC"), Locale.CANADA);
            }
        };
    }
}

