/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.jaxb;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.geotoolkit.internal.simple.SimpleCitation;
import org.geotoolkit.util.collection.XCollections;
import org.geotoolkit.util.logging.Logging;
import org.geotoolkit.xml.IdentifierSpace;
import org.opengis.metadata.Identifier;

public final class NonMarshalledAuthority<T>
extends SimpleCitation
implements IdentifierSpace<T>,
Serializable {
    private static final long serialVersionUID = -6309485399210742418L;
    public static final int ID = 0;
    public static final int UUID = 1;
    public static final int HREF = 2;
    public static final int XLINK = 3;
    public static final int ISSN = 4;
    public static final int ISBN = 5;
    final transient int ordinal;

    public NonMarshalledAuthority(String string, int n) {
        super(string);
        this.ordinal = n;
    }

    @Override
    public String getName() {
        return this.title;
    }

    public String toString() {
        return "IdentifierSpace[" + this.title + ']';
    }

    public static <T extends Identifier> T getMarshallable(Collection<? extends T> collection) {
        if (collection != null) {
            for (Identifier identifier : collection) {
                if (identifier == null || identifier.getAuthority() instanceof NonMarshalledAuthority) continue;
                return (T)identifier;
            }
        }
        return null;
    }

    public static <T extends Identifier> void setMarshallable(Collection<T> collection, T t) {
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Identifier identifier = (Identifier)iterator.next();
            if (identifier != null && identifier.getAuthority() instanceof NonMarshalledAuthority) continue;
            iterator.remove();
        }
        XCollections.addIfNonNull(collection, t);
    }

    public static <T extends Identifier> Collection<T> getIdentifiers(Collection<? extends T> collection) {
        ArrayList<Identifier> arrayList = null;
        if (collection != null) {
            int n = collection.size();
            for (Identifier identifier : collection) {
                if (identifier != null && identifier.getAuthority() instanceof NonMarshalledAuthority) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<Identifier>(n);
                    }
                    arrayList.add(identifier);
                }
                --n;
            }
        }
        return arrayList;
    }

    public static <T extends Identifier> void setIdentifiers(Collection<T> collection, Collection<T> collection2) {
        if (collection != null) {
            Iterator<T> iterator = collection.iterator();
            while (iterator.hasNext()) {
                Identifier identifier = (Identifier)iterator.next();
                if (identifier != null && !(identifier.getAuthority() instanceof NonMarshalledAuthority)) continue;
                iterator.remove();
            }
            if (collection2 != null) {
                collection.addAll(collection2);
            }
        }
    }

    private static IdentifierSpace<?> getCitation(String string) throws ObjectStreamException {
        try {
            Field field = Class.forName("org.geotoolkit.metadata.iso.citation.DefaultCitation").getDeclaredField(string);
            field.setAccessible(true);
            return (IdentifierSpace)field.get(null);
        }
        catch (Exception exception) {
            Logging.unexpectedException(NonMarshalledAuthority.class, (String)"readResolve", (Throwable)exception);
            return null;
        }
    }

    private Object readResolve() throws ObjectStreamException {
        int n = 0;
        while (true) {
            IdentifierSpace<Object> identifierSpace;
            switch (n) {
                case 0: {
                    identifierSpace = IdentifierSpace.ID;
                    break;
                }
                case 1: {
                    identifierSpace = IdentifierSpace.UUID;
                    break;
                }
                case 2: {
                    identifierSpace = IdentifierSpace.HREF;
                    break;
                }
                case 3: {
                    identifierSpace = IdentifierSpace.XLINK;
                    break;
                }
                case 5: {
                    identifierSpace = NonMarshalledAuthority.getCitation("ISBN");
                    break;
                }
                case 4: {
                    identifierSpace = NonMarshalledAuthority.getCitation("ISSN");
                    break;
                }
                default: {
                    return this;
                }
            }
            if (identifierSpace instanceof NonMarshalledAuthority && ((NonMarshalledAuthority)identifierSpace).title.equals(this.title)) {
                return identifierSpace;
            }
            ++n;
        }
    }
}

