/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.jaxb;

import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.geotoolkit.internal.jaxb.NonMarshalledAuthority;
import org.geotoolkit.util.Version;
import org.geotoolkit.util.collection.UnmodifiableArrayList;
import org.geotoolkit.xml.ObjectConverters;
import org.geotoolkit.xml.ObjectLinker;
import org.opengis.metadata.Identifier;

public final class MarshalContext {
    public static final Version GML_3_0 = new Version("3.0");
    public static final Version GML_3_2 = new Version("3.2");
    private static final int MARSHALING = 1;
    public static final int SUBSTITUTE_LANGUAGE = 2;
    public static final int SUBSTITUTE_COUNTRY = 4;
    private static final ThreadLocal<MarshalContext> CURRENT = new ThreadLocal();
    private ObjectConverters converters;
    private ObjectLinker linker;
    private Version versionGML;
    private Map<String, String> schemas;
    private Locale locale;
    private TimeZone timezone;
    private int bitMasks;
    private final MarshalContext previous = CURRENT.get();

    private MarshalContext() {
        CURRENT.set(this);
    }

    private void inherit() {
        MarshalContext marshalContext = this.previous;
        if (marshalContext != null) {
            this.converters = marshalContext.converters;
            this.linker = marshalContext.linker;
            this.versionGML = marshalContext.versionGML;
            this.schemas = marshalContext.schemas;
            this.locale = marshalContext.locale;
            this.timezone = marshalContext.timezone;
            this.bitMasks = marshalContext.bitMasks;
        }
    }

    public static Collection<Identifier> filterIdentifiers(Collection<Identifier> collection) {
        int n;
        if (collection != null && MarshalContext.isMarshaling() && (n = collection.size()) != 0) {
            Object[] objectArray = collection.toArray(new Identifier[n]);
            int n2 = n;
            while (--n2 >= 0) {
                Identifier identifier = objectArray[n2];
                if (identifier != null && !(identifier.getAuthority() instanceof NonMarshalledAuthority)) continue;
                System.arraycopy(objectArray, n2 + 1, objectArray, n2, --n - n2);
            }
            collection = n != 0 ? UnmodifiableArrayList.wrap((Object[])objectArray, (int)0, (int)n) : null;
        }
        return collection;
    }

    public static ObjectLinker linker() {
        ObjectLinker objectLinker;
        MarshalContext marshalContext = CURRENT.get();
        if (marshalContext != null && (objectLinker = marshalContext.linker) != null) {
            return objectLinker;
        }
        return ObjectLinker.DEFAULT;
    }

    public static ObjectConverters converters() {
        ObjectConverters objectConverters;
        MarshalContext marshalContext = CURRENT.get();
        if (marshalContext != null && (objectConverters = marshalContext.converters) != null) {
            return objectConverters;
        }
        return ObjectConverters.DEFAULT;
    }

    public static boolean versionGML(Version version) {
        Version version2;
        MarshalContext marshalContext = CURRENT.get();
        if (marshalContext != null && (version2 = marshalContext.versionGML) != null) {
            return version2.compareTo(version) >= 0;
        }
        return true;
    }

    public static String schema(String string) {
        Map<String, String> map;
        MarshalContext marshalContext = CURRENT.get();
        if (marshalContext != null && (map = marshalContext.schemas) != null) {
            return map.get(string);
        }
        return null;
    }

    public static String schema(String string, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder(128);
        String string5 = MarshalContext.schema(string);
        if (string5 == null) {
            string5 = "http://schemas.opengis.net/iso/19139/20070417/";
        }
        stringBuilder.append(string5);
        int n = stringBuilder.length();
        if (n != 0 && stringBuilder.charAt(n - 1) != '/') {
            stringBuilder.append('/');
        }
        return stringBuilder.append(string2).append('/').append(string3).append('#').append(string4).toString();
    }

    public static boolean isMarshaling() {
        MarshalContext marshalContext = CURRENT.get();
        return marshalContext != null && (marshalContext.bitMasks & 1) != 0;
    }

    static GregorianCalendar createGregorianCalendar() {
        MarshalContext marshalContext = CURRENT.get();
        if (marshalContext != null) {
            Locale locale = marshalContext.locale;
            TimeZone timeZone = marshalContext.timezone;
            if (timeZone != null) {
                return locale != null ? new GregorianCalendar(timeZone, locale) : new GregorianCalendar(timeZone);
            }
            if (locale != null) {
                return new GregorianCalendar(locale);
            }
        }
        return new GregorianCalendar();
    }

    public static TimeZone getTimeZone() {
        MarshalContext marshalContext = CURRENT.get();
        return marshalContext != null ? marshalContext.timezone : null;
    }

    public static Locale getLocale() {
        MarshalContext marshalContext = CURRENT.get();
        return marshalContext != null ? marshalContext.locale : null;
    }

    public static void pushLocale(Locale locale) {
        MarshalContext marshalContext = new MarshalContext();
        marshalContext.inherit();
        if (locale != null) {
            marshalContext.locale = locale;
        }
    }

    public static void pullLocale() {
        MarshalContext marshalContext = CURRENT.get();
        if (marshalContext != null) {
            marshalContext.finish();
        }
    }

    public static int getFlags() {
        MarshalContext marshalContext = CURRENT.get();
        return marshalContext != null ? marshalContext.bitMasks : 0;
    }

    public static MarshalContext begin(ObjectConverters objectConverters, ObjectLinker objectLinker, Version version, Map<String, String> map, Locale locale, TimeZone timeZone, int n) {
        MarshalContext marshalContext = new MarshalContext();
        marshalContext.converters = objectConverters;
        marshalContext.linker = objectLinker;
        marshalContext.versionGML = version;
        marshalContext.schemas = map;
        marshalContext.locale = locale;
        marshalContext.timezone = timeZone;
        marshalContext.bitMasks = n;
        return marshalContext;
    }

    public void setMarshalling() {
        this.bitMasks |= 1;
    }

    public void finish() {
        if (this.previous != null) {
            CURRENT.set(this.previous);
        } else {
            CURRENT.remove();
        }
    }
}

