/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.converter;

import java.io.ObjectStreamException;
import java.io.Serializable;
import net.jcip.annotations.Immutable;
import org.geotoolkit.util.converter.NonconvertibleObjectException;
import org.geotoolkit.util.converter.Numbers;
import org.geotoolkit.util.converter.SimpleConverter;

@Immutable
abstract class NumberConverter<T>
extends SimpleConverter<Number, T>
implements Serializable {
    private static final long serialVersionUID = -8715054480508622025L;

    NumberConverter() {
    }

    @Override
    public final Class<Number> getSourceClass() {
        return Number.class;
    }

    @Override
    public boolean isOrderPreserving() {
        return false;
    }

    @Immutable
    static final class Color
    extends NumberConverter<java.awt.Color> {
        private static final long serialVersionUID = 8866612442279600953L;
        public static final Color INSTANCE = new Color();

        private Color() {
        }

        @Override
        public Class<java.awt.Color> getTargetClass() {
            return java.awt.Color.class;
        }

        @Override
        public java.awt.Color convert(Number number) throws NonconvertibleObjectException {
            int n;
            if (number == null) {
                return null;
            }
            int n2 = (n = number.intValue()) & 0xFF000000;
            return new java.awt.Color(n, n2 != 0);
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    @Immutable
    static final class BigInteger
    extends NumberConverter<java.math.BigInteger> {
        private static final long serialVersionUID = 5940724099300523246L;
        public static final BigInteger INSTANCE = new BigInteger();

        private BigInteger() {
        }

        @Override
        public Class<java.math.BigInteger> getTargetClass() {
            return java.math.BigInteger.class;
        }

        @Override
        public java.math.BigInteger convert(Number number) throws NonconvertibleObjectException {
            if (number == null) {
                return null;
            }
            if (number instanceof java.math.BigInteger) {
                return (java.math.BigInteger)number;
            }
            if (number instanceof java.math.BigDecimal) {
                return ((java.math.BigDecimal)number).toBigInteger();
            }
            return java.math.BigInteger.valueOf(number.longValue());
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    @Immutable
    static final class BigDecimal
    extends NumberConverter<java.math.BigDecimal> {
        private static final long serialVersionUID = -6318144992861058878L;
        public static final BigDecimal INSTANCE = new BigDecimal();

        private BigDecimal() {
        }

        @Override
        public Class<java.math.BigDecimal> getTargetClass() {
            return java.math.BigDecimal.class;
        }

        @Override
        public java.math.BigDecimal convert(Number number) throws NonconvertibleObjectException {
            if (number == null) {
                return null;
            }
            if (number instanceof java.math.BigDecimal) {
                return (java.math.BigDecimal)number;
            }
            if (number instanceof java.math.BigInteger) {
                return new java.math.BigDecimal((java.math.BigInteger)number);
            }
            if (Numbers.isInteger(number.getClass())) {
                return java.math.BigDecimal.valueOf(number.longValue());
            }
            return java.math.BigDecimal.valueOf(number.doubleValue());
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    @Immutable
    static final class Boolean
    extends NumberConverter<java.lang.Boolean> {
        private static final long serialVersionUID = -7522980351031833731L;
        public static final Boolean INSTANCE = new Boolean();

        private Boolean() {
        }

        @Override
        public Class<java.lang.Boolean> getTargetClass() {
            return java.lang.Boolean.class;
        }

        @Override
        public java.lang.Boolean convert(Number number) throws NonconvertibleObjectException {
            return number != null ? java.lang.Boolean.valueOf(number.intValue() != 0) : null;
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    @Immutable
    static final class Byte
    extends NumberConverter<java.lang.Byte> {
        private static final long serialVersionUID = 1381038535870541045L;
        public static final Byte INSTANCE = new Byte();

        private Byte() {
        }

        @Override
        public Class<java.lang.Byte> getTargetClass() {
            return java.lang.Byte.class;
        }

        @Override
        public java.lang.Byte convert(Number number) throws NonconvertibleObjectException {
            return number != null ? java.lang.Byte.valueOf(number.byteValue()) : null;
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    @Immutable
    static final class Short
    extends NumberConverter<java.lang.Short> {
        private static final long serialVersionUID = -5943559376400249179L;
        public static final Short INSTANCE = new Short();

        private Short() {
        }

        @Override
        public Class<java.lang.Short> getTargetClass() {
            return java.lang.Short.class;
        }

        @Override
        public java.lang.Short convert(Number number) throws NonconvertibleObjectException {
            return number != null ? java.lang.Short.valueOf(number.shortValue()) : null;
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    @Immutable
    static final class Integer
    extends NumberConverter<java.lang.Integer> {
        private static final long serialVersionUID = 2661178278691398269L;
        public static final Integer INSTANCE = new Integer();

        private Integer() {
        }

        @Override
        public Class<java.lang.Integer> getTargetClass() {
            return java.lang.Integer.class;
        }

        @Override
        public java.lang.Integer convert(Number number) throws NonconvertibleObjectException {
            return number != null ? java.lang.Integer.valueOf(number.intValue()) : null;
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    @Immutable
    static final class Long
    extends NumberConverter<java.lang.Long> {
        private static final long serialVersionUID = -5320144566275003574L;
        public static final Long INSTANCE = new Long();

        private Long() {
        }

        @Override
        public Class<java.lang.Long> getTargetClass() {
            return java.lang.Long.class;
        }

        @Override
        public java.lang.Long convert(Number number) throws NonconvertibleObjectException {
            return number != null ? java.lang.Long.valueOf(number.longValue()) : null;
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    @Immutable
    static final class Float
    extends NumberConverter<java.lang.Float> {
        private static final long serialVersionUID = -5900985555014433974L;
        public static final Float INSTANCE = new Float();

        private Float() {
        }

        @Override
        public Class<java.lang.Float> getTargetClass() {
            return java.lang.Float.class;
        }

        @Override
        public java.lang.Float convert(Number number) throws NonconvertibleObjectException {
            return number != null ? java.lang.Float.valueOf(number.floatValue()) : null;
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    @Immutable
    static final class Double
    extends NumberConverter<java.lang.Double> {
        private static final long serialVersionUID = 1643009985070268985L;
        public static final Double INSTANCE = new Double();

        private Double() {
        }

        @Override
        public Class<java.lang.Double> getTargetClass() {
            return java.lang.Double.class;
        }

        @Override
        public java.lang.Double convert(Number number) throws NonconvertibleObjectException {
            return number != null ? java.lang.Double.valueOf(number.doubleValue()) : null;
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    @Immutable
    static final class String
    extends NumberConverter<java.lang.String> {
        private static final long serialVersionUID = 1460382215827540172L;
        public static final String INSTANCE = new String();

        private String() {
        }

        @Override
        public Class<java.lang.String> getTargetClass() {
            return java.lang.String.class;
        }

        @Override
        public java.lang.String convert(Number number) throws NonconvertibleObjectException {
            return number != null ? number.toString() : null;
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    @Immutable
    static final class Comparable
    extends NumberConverter<java.lang.Comparable<?>> {
        private static final long serialVersionUID = 3716134638218072176L;
        public static final Comparable INSTANCE = new Comparable();

        private Comparable() {
        }

        @Override
        public Class<java.lang.Comparable<?>> getTargetClass() {
            return java.lang.Comparable.class;
        }

        @Override
        public java.lang.Comparable<?> convert(Number number) throws NonconvertibleObjectException {
            if (number == null || number instanceof java.lang.Comparable) {
                return (java.lang.Comparable)((Object)number);
            }
            return number.doubleValue();
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }
}

