/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.collection;

import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import org.geotoolkit.util.collection.XCollections;

public class KeySortedList<K extends Comparable<K>, V>
extends AbstractSequentialList<V>
implements Serializable {
    private static final long serialVersionUID = 6969483179756527012L;
    private final SortedMap<K, List<V>> map;

    public KeySortedList() {
        this.map = new TreeMap<K, List<V>>();
    }

    private KeySortedList(SortedMap<K, List<V>> sortedMap) {
        this.map = sortedMap;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public int size() {
        int n = 0;
        for (List<V> list : this.map.values()) {
            n += list.size();
        }
        return n;
    }

    public void add(K k, V v) {
        ArrayList<V> arrayList = (ArrayList<V>)this.map.get(k);
        if (arrayList == null) {
            arrayList = new ArrayList<V>();
            this.map.put(k, arrayList);
        }
        arrayList.add(v);
    }

    public int removeAll(K k) {
        List list = (List)this.map.remove(k);
        return list != null ? list.size() : 0;
    }

    public int count(K k) {
        List list = (List)this.map.get(k);
        return list != null ? list.size() : 0;
    }

    public boolean containsKey(K k) {
        return this.map.containsKey(k);
    }

    public V first(K k) throws NoSuchElementException {
        List list = (List)this.map.get(k);
        if (XCollections.isNullOrEmpty(list)) {
            throw new NoSuchElementException();
        }
        return (V)list.get(0);
    }

    public V last(K k) throws NoSuchElementException {
        List list = (List)this.map.get(k);
        if (XCollections.isNullOrEmpty(list)) {
            throw new NoSuchElementException();
        }
        return (V)list.get(list.size() - 1);
    }

    public ListIterator<V> listIterator(K k) {
        return new Iter(this, k);
    }

    @Override
    public ListIterator<V> listIterator(int n) {
        return new Iter(this, n);
    }

    public KeySortedList<K, V> headList(K k) {
        return new KeySortedList<K, V>(this.map.headMap(k));
    }

    public KeySortedList<K, V> tailList(K k) {
        return new KeySortedList<K, V>(this.map.tailMap(k));
    }

    private static final class Iter
    implements ListIterator<V> {
        private Iterator<Map.Entry<K, List<V>>> entriesIter;
        private K key;
        private List<V> values;
        private ListIterator<V> valuesIter;
        private int base;
        final /* synthetic */ KeySortedList this$0;

        public Iter(K k) {
            this.this$0 = var1_1;
            for (Map.Entry entry : ((KeySortedList)var1_1).map.entrySet()) {
                this.key = (Comparable)entry.getKey();
                this.values = entry.getValue();
                if (k.compareTo(this.key) <= 0) {
                    this.valuesIter = this.values.listIterator();
                    assert (this.equivalent(new Iter(var1_1, this.base)));
                    return;
                }
                this.base += this.values.size();
            }
            this.key = null;
            this.values = Collections.emptyList();
            this.valuesIter = this.values.listIterator();
        }

        public Iter(KeySortedList keySortedList, int n) {
            this.this$0 = keySortedList;
            for (Map.Entry entry : keySortedList.map.entrySet()) {
                this.key = (Comparable)entry.getKey();
                this.values = entry.getValue();
                int n2 = this.values.size();
                if (n < n2) {
                    this.valuesIter = this.values.listIterator(n);
                    return;
                }
                n -= n2;
                this.base += n2;
            }
            if (n != 0) {
                throw new IndexOutOfBoundsException();
            }
            this.key = null;
            this.values = Collections.emptyList();
            this.valuesIter = this.values.listIterator();
        }

        @Override
        public boolean hasNext() {
            return this.valuesIter.hasNext() || this.entriesIter.hasNext();
        }

        @Override
        public V next() {
            while (!this.valuesIter.hasNext()) {
                if (this.entriesIter.hasNext()) {
                    Map.Entry entry = this.entriesIter.next();
                    this.base += this.values.size();
                    this.key = (Comparable)entry.getKey();
                    this.values = entry.getValue();
                    this.valuesIter = this.values.listIterator();
                    continue;
                }
                this.key = null;
                this.values = Collections.emptyList();
                this.valuesIter = this.values.listIterator();
                break;
            }
            return this.valuesIter.next();
        }

        @Override
        public boolean hasPrevious() {
            return this.valuesIter.hasPrevious() || this.base != 0;
        }

        @Override
        public V previous() {
            while (!this.valuesIter.hasPrevious() && this.base != 0) {
                this.key = (Comparable)this.this$0.map.headMap(this.key).lastKey();
                this.entriesIter = this.this$0.map.tailMap(this.key).entrySet().iterator();
                Map.Entry entry = this.entriesIter.next();
                assert (this.key == entry.getKey()) : this.key;
                this.values = entry.getValue();
                int n = this.values.size();
                this.valuesIter = this.values.listIterator(Math.max(n - 1, 0));
                this.base -= n;
                assert (this.base >= 0) : this.base;
            }
            return this.valuesIter.previous();
        }

        @Override
        public int nextIndex() {
            return this.base + this.valuesIter.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.base + this.valuesIter.previousIndex();
        }

        @Override
        public void remove() {
            this.valuesIter.remove();
        }

        @Override
        public void set(V v) {
            this.valuesIter.set(v);
        }

        @Override
        public void add(V v) {
            this.valuesIter.add(v);
        }

        private boolean equivalent(Iter iter) {
            return this.key == iter.key && this.values == iter.values && this.base == iter.base && this.valuesIter.nextIndex() == iter.valuesIter.nextIndex();
        }
    }
}

