/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.collection;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import org.geotoolkit.util.ArgumentChecks;

public class FrequencySortedSet<E>
extends AbstractSet<E>
implements SortedSet<E>,
Comparator<E>,
Serializable {
    private static final long serialVersionUID = 6034102231354388179L;
    private final Map<E, Integer> count;
    private final int order;
    private transient E[] sorted;
    private transient int[] frequencies;
    private static final Comparator<Map.Entry<?, Integer>> COMPARATOR = new Comparator<Map.Entry<?, Integer>>(){

        @Override
        public int compare(Map.Entry<?, Integer> entry, Map.Entry<?, Integer> entry2) {
            return entry.getValue().compareTo(entry2.getValue());
        }
    };

    public FrequencySortedSet() {
        this(false);
    }

    public FrequencySortedSet(boolean bl) {
        this(16, bl);
    }

    public FrequencySortedSet(int n, boolean bl) {
        this.count = new LinkedHashMap<E, Integer>(n);
        this.order = bl ? -1 : 1;
    }

    @Override
    public int size() {
        return this.count.size();
    }

    @Override
    public boolean isEmpty() {
        return this.count.isEmpty();
    }

    public boolean add(E e, int n) throws IllegalArgumentException {
        if (n != 0) {
            ArgumentChecks.ensurePositive("occurrence", n);
            this.sorted = null;
            Integer n2 = this.count.put(e, n *= this.order);
            if (n2 == null) {
                return true;
            }
            this.count.put(e, n2 + n);
        }
        return false;
    }

    @Override
    public boolean add(E e) {
        return this.add(e, 1);
    }

    @Override
    public boolean contains(Object object) {
        return this.count.containsKey(object);
    }

    @Override
    public boolean remove(Object object) {
        if (this.count.remove(object) != null) {
            this.sorted = null;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.frequencies = null;
        this.sorted = null;
        this.count.clear();
    }

    @Override
    public Iterator<E> iterator() {
        this.ensureSorted();
        return new Iter();
    }

    @Override
    public SortedSet<E> headSet(E e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SortedSet<E> tailSet(E e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SortedSet<E> subSet(E e, E e2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public E first() throws NoSuchElementException {
        this.ensureSorted();
        if (this.sorted.length != 0) {
            return this.sorted[0];
        }
        throw new NoSuchElementException();
    }

    @Override
    public E last() throws NoSuchElementException {
        this.ensureSorted();
        int n = this.sorted.length;
        if (n != 0) {
            return this.sorted[n - 1];
        }
        throw new NoSuchElementException();
    }

    private void ensureSorted() {
        if (this.sorted != null) {
            return;
        }
        Map.Entry[] entryArray = this.count.entrySet().toArray(new Map.Entry[this.count.size()]);
        Arrays.sort(entryArray, COMPARATOR);
        int n = entryArray.length;
        this.sorted = new Object[n];
        if (this.frequencies == null || this.frequencies.length != n) {
            this.frequencies = new int[n];
        }
        for (int i = 0; i < n; ++i) {
            Map.Entry entry = entryArray[i];
            this.sorted[i] = entry.getKey();
            this.frequencies[i] = Math.abs((Integer)entry.getValue());
        }
    }

    @Override
    public final Comparator<E> comparator() {
        return this;
    }

    @Override
    public final int compare(E e, E e2) {
        return this.signedFrequency(e) - this.signedFrequency(e2);
    }

    private int signedFrequency(E e) {
        Integer n = this.count.get(e);
        return n != null ? n : 0;
    }

    public int frequency(E e) {
        return Math.abs(this.signedFrequency(e));
    }

    public int[] frequencies() {
        this.ensureSorted();
        return (int[])this.frequencies.clone();
    }

    @Override
    public Object[] toArray() {
        this.ensureSorted();
        return (Object[])this.sorted.clone();
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        this.ensureSorted();
        if (objectArray.length < this.sorted.length) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.sorted.length);
        }
        System.arraycopy(this.sorted, 0, objectArray, 0, this.sorted.length);
        return objectArray;
    }

    private final class Iter
    implements Iterator<E> {
        private final E[] elements;
        private int index;

        Iter() {
            this.elements = FrequencySortedSet.this.sorted;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.elements.length;
        }

        @Override
        public E next() {
            if (this.index >= this.elements.length) {
                throw new NoSuchElementException();
            }
            return this.elements[this.index++];
        }

        @Override
        public void remove() {
            if (this.index == 0) {
                throw new IllegalStateException();
            }
            if (!FrequencySortedSet.this.remove(this.elements[this.index - 1])) {
                throw new IllegalStateException();
            }
        }
    }
}

