/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.collection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.geotoolkit.util.ArgumentChecks;

public abstract class DeferringIterator<E>
implements Iterator<E> {
    private Iterator<E> iterator;
    private List<E> fallbacks;
    private boolean usingFallbacks;

    protected DeferringIterator(Iterator<E> iterator) {
        ArgumentChecks.ensureNonNull("iterator", iterator);
        this.iterator = iterator;
    }

    protected abstract boolean isDeferred(E var1);

    @Override
    public boolean hasNext() {
        boolean bl = this.iterator.hasNext();
        if (!bl && !this.usingFallbacks && this.fallbacks != null) {
            bl = this.fallbacks().hasNext();
        }
        return bl;
    }

    @Override
    public E next() {
        do {
            E e = this.iterator.next();
            if (this.usingFallbacks || !this.isDeferred(e)) {
                return e;
            }
            if (this.fallbacks == null) {
                this.fallbacks = new ArrayList();
            }
            this.fallbacks.add(e);
        } while (this.iterator.hasNext());
        return this.fallbacks().next();
    }

    private Iterator<E> fallbacks() {
        this.iterator = this.fallbacks.iterator();
        this.fallbacks = null;
        this.usingFallbacks = true;
        return this.iterator;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        if (this.usingFallbacks) {
            throw new UnsupportedOperationException();
        }
        this.iterator.remove();
    }
}

