/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import org.geotoolkit.lang.Static;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.Utilities;

public final class XArrays
extends Static {
    public static final double[] EMPTY_DOUBLE = new double[0];
    public static final float[] EMPTY_FLOAT = new float[0];
    public static final long[] EMPTY_LONG = new long[0];
    public static final int[] EMPTY_INT = new int[0];
    public static final short[] EMPTY_SHORT = new short[0];
    public static final byte[] EMPTY_BYTE = new byte[0];
    public static final char[] EMPTY_CHAR = new char[0];
    public static final boolean[] EMPTY_BOOLEAN = new boolean[0];

    private XArrays() {
    }

    public static <E> E[] resize(E[] EArray, int n) {
        return EArray == null || EArray.length == n ? EArray : Arrays.copyOf(EArray, n);
    }

    public static double[] resize(double[] dArray, int n) {
        if (dArray != null) {
            if (n == 0) {
                return EMPTY_DOUBLE;
            }
            if (dArray.length != n) {
                return Arrays.copyOf(dArray, n);
            }
        }
        return dArray;
    }

    public static float[] resize(float[] fArray, int n) {
        if (fArray != null) {
            if (n == 0) {
                return EMPTY_FLOAT;
            }
            if (fArray.length != n) {
                return Arrays.copyOf(fArray, n);
            }
        }
        return fArray;
    }

    public static long[] resize(long[] lArray, int n) {
        if (lArray != null) {
            if (n == 0) {
                return EMPTY_LONG;
            }
            if (lArray.length != n) {
                return Arrays.copyOf(lArray, n);
            }
        }
        return lArray;
    }

    public static int[] resize(int[] nArray, int n) {
        if (nArray != null) {
            if (n == 0) {
                return EMPTY_INT;
            }
            if (nArray.length != n) {
                return Arrays.copyOf(nArray, n);
            }
        }
        return nArray;
    }

    public static short[] resize(short[] sArray, int n) {
        if (sArray != null) {
            if (n == 0) {
                return EMPTY_SHORT;
            }
            if (sArray.length != n) {
                return Arrays.copyOf(sArray, n);
            }
        }
        return sArray;
    }

    public static byte[] resize(byte[] byArray, int n) {
        if (byArray != null) {
            if (n == 0) {
                return EMPTY_BYTE;
            }
            if (byArray.length != n) {
                return Arrays.copyOf(byArray, n);
            }
        }
        return byArray;
    }

    public static char[] resize(char[] cArray, int n) {
        if (cArray != null) {
            if (n == 0) {
                return EMPTY_CHAR;
            }
            if (cArray.length != n) {
                return Arrays.copyOf(cArray, n);
            }
        }
        return cArray;
    }

    public static boolean[] resize(boolean[] blArray, int n) {
        if (blArray != null) {
            if (n == 0) {
                return EMPTY_BOOLEAN;
            }
            if (blArray.length != n) {
                return Arrays.copyOf(blArray, n);
            }
        }
        return blArray;
    }

    private static <T> T doRemove(T t, int n, int n2) {
        if (n2 == 0) {
            return t;
        }
        ArgumentChecks.ensureNonNull("array", t);
        int n3 = Array.getLength(t);
        Object object = Array.newInstance(t.getClass().getComponentType(), n3 -= n2);
        System.arraycopy(t, 0, object, 0, n);
        System.arraycopy(t, n + n2, object, n, n3 - n);
        return (T)object;
    }

    public static <E> E[] remove(E[] EArray, int n, int n2) {
        return XArrays.doRemove(EArray, n, n2);
    }

    public static double[] remove(double[] dArray, int n, int n2) {
        return n == 0 && dArray != null && n2 == dArray.length ? EMPTY_DOUBLE : XArrays.doRemove(dArray, n, n2);
    }

    public static float[] remove(float[] fArray, int n, int n2) {
        return n == 0 && fArray != null && n2 == fArray.length ? EMPTY_FLOAT : XArrays.doRemove(fArray, n, n2);
    }

    public static long[] remove(long[] lArray, int n, int n2) {
        return n == 0 && lArray != null && n2 == lArray.length ? EMPTY_LONG : XArrays.doRemove(lArray, n, n2);
    }

    public static int[] remove(int[] nArray, int n, int n2) {
        return n == 0 && nArray != null && n2 == nArray.length ? EMPTY_INT : XArrays.doRemove(nArray, n, n2);
    }

    public static short[] remove(short[] sArray, int n, int n2) {
        return n == 0 && sArray != null && n2 == sArray.length ? EMPTY_SHORT : XArrays.doRemove(sArray, n, n2);
    }

    public static byte[] remove(byte[] byArray, int n, int n2) {
        return n == 0 && byArray != null && n2 == byArray.length ? EMPTY_BYTE : XArrays.doRemove(byArray, n, n2);
    }

    public static char[] remove(char[] cArray, int n, int n2) {
        return n == 0 && cArray != null && n2 == cArray.length ? EMPTY_CHAR : XArrays.doRemove(cArray, n, n2);
    }

    public static boolean[] remove(boolean[] blArray, int n, int n2) {
        return n == 0 && blArray != null && n2 == blArray.length ? EMPTY_BOOLEAN : XArrays.doRemove(blArray, n, n2);
    }

    private static <T> T doInsert(T t, int n, int n2) {
        if (n2 == 0) {
            return t;
        }
        ArgumentChecks.ensureNonNull("array", t);
        int n3 = Array.getLength(t);
        Object object = Array.newInstance(t.getClass().getComponentType(), n3 + n2);
        System.arraycopy(t, 0, object, 0, n);
        System.arraycopy(t, n, object, n + n2, n3 - n);
        return (T)object;
    }

    public static <E> E[] insert(E[] EArray, int n, int n2) {
        return XArrays.doInsert(EArray, n, n2);
    }

    public static double[] insert(double[] dArray, int n, int n2) {
        return XArrays.doInsert(dArray, n, n2);
    }

    public static float[] insert(float[] fArray, int n, int n2) {
        return XArrays.doInsert(fArray, n, n2);
    }

    public static long[] insert(long[] lArray, int n, int n2) {
        return XArrays.doInsert(lArray, n, n2);
    }

    public static int[] insert(int[] nArray, int n, int n2) {
        return XArrays.doInsert(nArray, n, n2);
    }

    public static short[] insert(short[] sArray, int n, int n2) {
        return XArrays.doInsert(sArray, n, n2);
    }

    public static byte[] insert(byte[] byArray, int n, int n2) {
        return XArrays.doInsert(byArray, n, n2);
    }

    public static char[] insert(char[] cArray, int n, int n2) {
        return XArrays.doInsert(cArray, n, n2);
    }

    public static boolean[] insert(boolean[] blArray, int n, int n2) {
        return XArrays.doInsert(blArray, n, n2);
    }

    private static <T> T doInsert(T t, int n, T t2, int n2, int n3) {
        if (n3 == 0) {
            return t2;
        }
        ArgumentChecks.ensureNonNull("src", t);
        ArgumentChecks.ensureNonNull("dst", t2);
        int n4 = Array.getLength(t2);
        Object object = Array.newInstance(t2.getClass().getComponentType(), n4 + n3);
        System.arraycopy(t2, 0, object, 0, n2);
        System.arraycopy(t, n, object, n2, n3);
        System.arraycopy(t2, n2, object, n2 + n3, n4 - n2);
        return (T)object;
    }

    public static <E> E[] insert(E[] EArray, int n, E[] EArray2, int n2, int n3) {
        return XArrays.doInsert(EArray, n, EArray2, n2, n3);
    }

    public static double[] insert(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        return XArrays.doInsert(dArray, n, dArray2, n2, n3);
    }

    public static float[] insert(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        return XArrays.doInsert(fArray, n, fArray2, n2, n3);
    }

    public static long[] insert(long[] lArray, int n, long[] lArray2, int n2, int n3) {
        return XArrays.doInsert(lArray, n, lArray2, n2, n3);
    }

    public static int[] insert(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        return XArrays.doInsert(nArray, n, nArray2, n2, n3);
    }

    public static short[] insert(short[] sArray, int n, short[] sArray2, int n2, int n3) {
        return XArrays.doInsert(sArray, n, sArray2, n2, n3);
    }

    public static byte[] insert(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        return XArrays.doInsert(byArray, n, byArray2, n2, n3);
    }

    public static char[] insert(char[] cArray, int n, char[] cArray2, int n2, int n3) {
        return XArrays.doInsert(cArray, n, cArray2, n2, n3);
    }

    public static boolean[] insert(boolean[] blArray, int n, boolean[] blArray2, int n2, int n3) {
        return XArrays.doInsert(blArray, n, blArray2, n2, n3);
    }

    public static <T> T[] append(T[] TArray, T t) {
        ArgumentChecks.ensureNonNull("array", TArray);
        T[] TArray2 = Arrays.copyOf(TArray, TArray.length + 1);
        TArray2[TArray.length] = t;
        return TArray2;
    }

    public static int removeDuplicated(Object[] objectArray) {
        int n;
        if (objectArray == null) {
            return 0;
        }
        int n2 = n = objectArray.length;
        block0: while (--n2 >= 0) {
            Object object = objectArray[n2];
            int n3 = n2;
            while (--n3 >= 0) {
                if (!Utilities.equals(objectArray[n3], object)) continue;
                System.arraycopy(objectArray, n2 + 1, objectArray, n2, --n - n2);
                objectArray[n] = null;
                continue block0;
            }
        }
        return n;
    }

    public static void reverse(Object[] objectArray) {
        if (objectArray != null) {
            int n = objectArray.length >>> 1;
            int n2 = n + (objectArray.length & 1);
            while (--n >= 0) {
                Object object = objectArray[n];
                objectArray[n] = objectArray[n2];
                objectArray[n2++] = object;
            }
        }
    }

    public static void reverse(int[] nArray) {
        if (nArray != null) {
            int n = nArray.length >>> 1;
            int n2 = n + (nArray.length & 1);
            while (--n >= 0) {
                int n3 = nArray[n];
                nArray[n] = nArray[n2];
                nArray[n2++] = n3;
            }
        }
    }

    public static float[] copyAsFloats(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        float[] fArray = new float[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            fArray[i] = (float)dArray[i];
        }
        return fArray;
    }

    public static int[] copyAsInts(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            nArray[i] = (int)Math.round(dArray[i]);
        }
        return nArray;
    }

    public static <E> boolean isSorted(E[] EArray, Comparator<E> comparator, boolean bl) {
        for (int i = 1; i < EArray.length; ++i) {
            int n = comparator.compare(EArray[i], EArray[i - 1]);
            if (!(bl ? n <= 0 : n < 0)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(double[] dArray, boolean bl) {
        int n = 0;
        for (int i = 1; i < dArray.length; ++i) {
            double d = dArray[i];
            double d2 = dArray[n];
            if (bl ? d <= d2 : d < d2) {
                return false;
            }
            if (Double.isNaN(d)) continue;
            n = i;
        }
        return true;
    }

    public static boolean isSorted(float[] fArray, boolean bl) {
        int n = 0;
        for (int i = 1; i < fArray.length; ++i) {
            float f = fArray[i];
            float f2 = fArray[n];
            if (bl ? f <= f2 : f < f2) {
                return false;
            }
            if (Float.isNaN(f)) continue;
            n = i;
        }
        return true;
    }

    public static boolean isSorted(long[] lArray, boolean bl) {
        for (int i = 1; i < lArray.length; ++i) {
            long l = lArray[i];
            long l2 = lArray[i - 1];
            if (!(bl ? l <= l2 : l < l2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(int[] nArray, boolean bl) {
        for (int i = 1; i < nArray.length; ++i) {
            int n = nArray[i];
            int n2 = nArray[i - 1];
            if (!(bl ? n <= n2 : n < n2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(short[] sArray, boolean bl) {
        for (int i = 1; i < sArray.length; ++i) {
            short s = sArray[i];
            short s2 = sArray[i - 1];
            if (!(bl ? s <= s2 : s < s2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(byte[] byArray, boolean bl) {
        for (int i = 1; i < byArray.length; ++i) {
            byte by = byArray[i];
            byte by2 = byArray[i - 1];
            if (!(bl ? by <= by2 : by < by2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(char[] cArray, boolean bl) {
        for (int i = 1; i < cArray.length; ++i) {
            char c = cArray[i];
            char c2 = cArray[i - 1];
            if (!(bl ? c <= c2 : c < c2)) continue;
            return false;
        }
        return true;
    }

    public static boolean allEquals(double[] dArray, double d) {
        if (Double.isNaN(d)) {
            for (int i = 0; i < dArray.length; ++i) {
                if (Double.isNaN(dArray[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < dArray.length; ++i) {
                if (dArray[i] == d) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean allEquals(float[] fArray, float f) {
        if (Float.isNaN(f)) {
            for (int i = 0; i < fArray.length; ++i) {
                if (Float.isNaN(fArray[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < fArray.length; ++i) {
                if (fArray[i] == f) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean hasNaN(double[] dArray) {
        if (dArray != null) {
            for (int i = 0; i < dArray.length; ++i) {
                if (!Double.isNaN(dArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasNaN(float[] fArray) {
        if (fArray != null) {
            for (int i = 0; i < fArray.length; ++i) {
                if (!Float.isNaN(fArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsIgnoreCase(String[] stringArray, String string) {
        if (stringArray != null) {
            for (String string2 : stringArray) {
                if (!string.equalsIgnoreCase(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsIdentity(Object[] objectArray, Object object) {
        if (objectArray != null) {
            for (Object object2 : objectArray) {
                if (object2 != object) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(Object[] objectArray, Object object) {
        if (objectArray != null) {
            for (Object object2 : objectArray) {
                if (!Utilities.equals(object2, object)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean intersects(Object[] objectArray, Object[] objectArray2) {
        if (objectArray != null) {
            for (Object object : objectArray) {
                if (!XArrays.contains(objectArray2, object)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> T[] concatenate(T[] ... TArray) {
        T[] TArray2 = null;
        if (TArray != null) {
            int n = 0;
            for (T[] TArray3 : TArray) {
                if (TArray3 == null) continue;
                n += TArray3.length;
            }
            int n2 = 0;
            for (T[] TArray4 : TArray) {
                if (TArray4 == null) continue;
                if (TArray2 == null) {
                    if (TArray4.length == n) {
                        return TArray4;
                    }
                    TArray2 = Arrays.copyOf(TArray4, n);
                } else {
                    System.arraycopy(TArray4, 0, TArray2, n2, TArray4.length);
                }
                n2 += TArray4.length;
            }
        }
        return TArray2;
    }

    public static int[] unionSorted(int[] nArray, int[] nArray2) {
        if (nArray == null) {
            return nArray2;
        }
        if (nArray2 == null) {
            return nArray;
        }
        assert (XArrays.isSorted(nArray, true));
        assert (XArrays.isSorted(nArray2, true));
        int[] nArray3 = new int[nArray.length + nArray2.length];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            int n4;
            int n5;
            if (n2 == nArray.length) {
                n5 = nArray2.length - n3;
                System.arraycopy(nArray2, n3, nArray3, n, n5);
                n += n5;
                break;
            }
            if (n3 == nArray2.length) {
                n5 = nArray.length - n2;
                System.arraycopy(nArray, n2, nArray3, n, n5);
                n += n5;
                break;
            }
            n5 = nArray[n2];
            int n6 = nArray2[n3];
            if (n5 <= n6) {
                n4 = n5;
                ++n2;
                if (n5 == n6) {
                    ++n3;
                }
            } else {
                n4 = n6;
                ++n3;
            }
            nArray3[n++] = n4;
        }
        nArray3 = XArrays.resize(nArray3, n);
        assert (XArrays.isSorted(nArray3, true));
        return nArray3;
    }
}

