/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.resources;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.geotoolkit.lang.Static;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.XArrays;
import org.geotoolkit.util.collection.XCollections;
import org.geotoolkit.util.logging.Logging;

public final class Locales
extends Static {
    private static final Map<Locale, Locale> POOL;

    private Locales() {
    }

    public static Locale[] getAvailableLanguages() {
        return new Locale[]{Locale.ENGLISH, Locale.FRENCH, Locale.GERMAN};
    }

    public static Locale[] getAvailableLocales() {
        Locale[] localeArray = Locales.getAvailableLanguages();
        Locale[] localeArray2 = Locale.getAvailableLocales();
        int n = 0;
        for (int i = 0; i < localeArray2.length; ++i) {
            Locale locale = localeArray2[i];
            if (!Locales.containsLanguage(localeArray, locale)) continue;
            localeArray2[n++] = locale;
        }
        localeArray2 = XArrays.resize(localeArray2, n);
        return localeArray2;
    }

    private static boolean containsLanguage(Locale[] localeArray, Locale locale) {
        String string = locale.getLanguage();
        for (int i = 0; i < localeArray.length; ++i) {
            if (!string.equals(localeArray[i].getLanguage())) continue;
            return true;
        }
        return false;
    }

    public static String[] getAvailableLocales(Locale locale) {
        Locale[] localeArray = Locales.getAvailableLocales();
        Object[] objectArray = new String[localeArray.length];
        for (int i = 0; i < localeArray.length; ++i) {
            objectArray[i] = localeArray[i].getDisplayName(locale);
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    public static Locale unique(Locale locale) {
        Locale locale2 = POOL.get(locale);
        return locale2 != null ? locale2 : locale;
    }

    public static Locale parse(String string) throws IllegalArgumentException {
        int n;
        String string2;
        String string3;
        String string4;
        int n2 = string.indexOf(95);
        if (n2 < 0) {
            string4 = string.trim();
            string3 = "";
            string2 = "";
        } else {
            string4 = string.substring(0, n2).trim();
            if ((n = string.indexOf(95, ++n2)) < 0) {
                string3 = string.substring(n2).trim();
                string2 = "";
            } else {
                string3 = string.substring(n2, n).trim();
                string2 = string.substring(++n).trim();
                if (string.indexOf(95, n) >= 0) {
                    throw new IllegalArgumentException(Errors.format(11, string));
                }
            }
        }
        n = Locales.isThreeLetters(string4);
        boolean bl = Locales.isThreeLetters(string3);
        if (n != 0 || bl) {
            String string5 = string4;
            String string6 = string3;
            for (Locale locale : Locale.getAvailableLocales()) {
                String string7;
                String string8 = string7 = n != 0 ? locale.getISO3Language() : locale.getLanguage();
                if (!string4.equals(string7)) continue;
                if (string6 == string3) {
                    string5 = locale.getLanguage();
                }
                String string9 = string7 = bl ? locale.getISO3Country() : locale.getCountry();
                if (!string3.equals(string7)) continue;
                string6 = locale.getCountry();
                if (!string2.equals(locale.getVariant())) continue;
                return Locales.unique(locale);
            }
            return Locales.unique(new Locale(string5, string6, string2));
        }
        return Locales.unique(new Locale(string4, string3, string2));
    }

    private static boolean isThreeLetters(String string) {
        switch (string.length()) {
            case 0: 
            case 2: {
                return false;
            }
            case 3: {
                return true;
            }
        }
        throw new IllegalArgumentException(Errors.format(11, string));
    }

    public static String getLanguage(Locale locale) {
        try {
            return locale.getISO3Language();
        }
        catch (MissingResourceException missingResourceException) {
            Logging.recoverableException(Locales.class, "getLanguage", missingResourceException);
            return locale.getLanguage();
        }
    }

    static {
        Locale[] localeArray = Locale.getAvailableLocales();
        POOL = new HashMap<Locale, Locale>(XCollections.hashMapCapacity(localeArray.length));
        for (Locale locale : localeArray) {
            POOL.put(locale, locale);
        }
        try {
            Object[] objectArray = Locale.class.getFields();
            for (int i = 0; i < objectArray.length; ++i) {
                Locale locale;
                Object object = objectArray[i];
                if (!Modifier.isStatic(((Field)object).getModifiers()) || !Locale.class.isAssignableFrom(((Field)object).getType())) continue;
                locale = (Locale)((Field)object).get(null);
                POOL.put(locale, locale);
            }
        }
        catch (Exception exception) {
            Logging.unexpectedException(Locales.class, "unique", exception);
        }
    }
}

