/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.math;

import java.util.Arrays;
import org.geotoolkit.lang.Static;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.XArrays;
import org.geotoolkit.util.converter.Numbers;

public final class XMath
extends Static {
    public static final double SQRT2 = 1.4142135623730951;
    public static final long SIGN_BIT_MASK = Long.MIN_VALUE;
    private static final double[] POW10 = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
    private static short[] primes = new short[]{2, 3};
    private static final int MAX_PRIMES_LENGTH = 6542;
    private static final double EPS = 1.0E-6;

    private XMath() {
    }

    public static double magnitude(double ... dArray) {
        double d;
        double d2;
        double d3;
        int n = dArray.length;
        do {
            if (n != 0) continue;
            return 0.0;
        } while ((d3 = dArray[--n]) == 0.0);
        do {
            if (n != 0) continue;
            return Math.abs(d3);
        } while ((d2 = dArray[--n]) == 0.0);
        do {
            if (n != 0) continue;
            return Math.hypot(d3, d2);
        } while ((d = dArray[--n]) == 0.0);
        d3 = d3 * d3 + d2 * d2 + d * d;
        while (n != 0) {
            d2 = dArray[--n];
            d3 += d2 * d2;
        }
        return Math.sqrt(d3);
    }

    public static double pow10(double d) {
        int n = (int)d;
        if ((double)n == d) {
            return XMath.pow10(n);
        }
        return Math.pow(10.0, d);
    }

    public static strictfp double pow10(int n) {
        int n2;
        if (n >= 0) {
            if (n < POW10.length) {
                return POW10[n];
            }
        } else if (n != Integer.MIN_VALUE && (n2 = -n) < POW10.length) {
            return 1.0 / POW10[n2];
        }
        try {
            return Double.parseDouble("1E" + n);
        }
        catch (NumberFormatException numberFormatException) {
            return StrictMath.pow(10.0, n);
        }
    }

    public static double atanh(double d) {
        return 0.5 * Math.log1p(2.0 * d / (1.0 - d));
    }

    public static boolean isPositive(double d) {
        return (Double.doubleToRawLongBits(d) & Long.MIN_VALUE) == 0L && !Double.isNaN(d);
    }

    public static boolean isNegative(double d) {
        return (Double.doubleToRawLongBits(d) & Long.MIN_VALUE) != 0L && !Double.isNaN(d);
    }

    public static boolean isSameSign(double d, double d2) {
        return !Double.isNaN(d) && !Double.isNaN(d2) && ((Double.doubleToRawLongBits(d) ^ Double.doubleToRawLongBits(d2)) & Long.MIN_VALUE) == 0L;
    }

    public static int sgn(double d) {
        if (d > 0.0) {
            return 1;
        }
        if (d < 0.0) {
            return -1;
        }
        return 0;
    }

    public static int sgn(float f) {
        if (f > 0.0f) {
            return 1;
        }
        if (f < 0.0f) {
            return -1;
        }
        return 0;
    }

    public static int sgn(long l) {
        if (l > 0L) {
            return 1;
        }
        if (l < 0L) {
            return -1;
        }
        return 0;
    }

    public static int sgn(int n) {
        if (n > 0) {
            return 1;
        }
        if (n < 0) {
            return -1;
        }
        return 0;
    }

    public static short sgn(short s) {
        if (s > 0) {
            return 1;
        }
        if (s < 0) {
            return -1;
        }
        return 0;
    }

    public static byte sgn(byte by) {
        if (by > 0) {
            return 1;
        }
        if (by < 0) {
            return -1;
        }
        return 0;
    }

    public static double xorSign(double d, double d2) {
        return Double.longBitsToDouble(Double.doubleToRawLongBits(d) ^ Double.doubleToRawLongBits(d2) & Long.MIN_VALUE);
    }

    public static double adjacentForType(Class<? extends Number> clazz, double d, int n) throws IllegalArgumentException {
        boolean bl;
        if (Numbers.isInteger(clazz)) {
            if (n == 0) {
                return Math.rint(d);
            }
            d = n > 0 ? Math.floor(d) : Math.ceil(d);
            return d + (double)n;
        }
        boolean bl2 = bl = n < 0;
        if (bl) {
            n = -n;
            d = -d;
        }
        if (clazz == Double.class) {
            while (--n >= 0) {
                d = Math.nextUp(d);
            }
        } else if (clazz == Float.class) {
            float f = (float)d;
            while (--n >= 0) {
                f = Math.nextUp(f);
            }
            d = f;
        } else {
            throw new IllegalArgumentException(Errors.format(240, clazz));
        }
        if (bl) {
            d = -d;
        }
        return d;
    }

    public static float toNaN(int n) throws IndexOutOfBoundsException {
        if ((n += 0x200000) < 0 || n > 0x3FFFFF) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        float f = Float.intBitsToFloat(2143289344 + n);
        assert (Float.isNaN(f)) : f;
        return f;
    }

    public static synchronized int primeNumber(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= 6542) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        short[] sArray = primes;
        if (n >= sArray.length) {
            int n2 = sArray.length;
            int n3 = sArray[n2 - 1] & 0xFFFF;
            sArray = Arrays.copyOf(sArray, Math.min((n | 0xF) + 1, 6542));
            block0: while (true) {
                n3 += 2;
                for (int i = 1; i < n2; ++i) {
                    if (n3 % (sArray[i] & 0xFFFF) == 0) continue block0;
                }
                assert (n3 < 65535) : n2;
                sArray[n2] = (short)n3;
                if (++n2 >= sArray.length) break;
            }
            primes = sArray;
        }
        return sArray[n] & 0xFFFF;
    }

    public static int[] divisors(int n) {
        int n2;
        int n3;
        if (n == 0) {
            return XArrays.EMPTY_INT;
        }
        n = Math.abs(n);
        int[] nArray = new int[16];
        nArray[0] = 1;
        int n4 = 1;
        int n5 = (int)(Math.sqrt(n) + 1.0E-6);
        int n6 = 0;
        while ((n3 = XMath.primeNumber(n6)) <= n5) {
            if (n % n3 == 0) {
                if (n4 == nArray.length) {
                    nArray = Arrays.copyOf(nArray, n4 * 2);
                }
                nArray[n4++] = n3;
            }
            ++n6;
        }
        n3 = n4;
        if (n4 * 2 > nArray.length) {
            nArray = Arrays.copyOf(nArray, n4 * 2);
        }
        if ((n6 = nArray[--n3]) != (n2 = n / n6)) {
            nArray[n4++] = n2;
        }
        while (--n3 >= 0) {
            nArray[n4++] = n / nArray[n3];
        }
        for (int i = 1; i < n4; ++i) {
            n6 = nArray[i];
            for (int j = i; j < n4; ++j) {
                int n7;
                n2 = n6 * nArray[j];
                if (n % n2 != 0 || (n7 = Arrays.binarySearch(nArray, j, n4, n2)) >= 0) continue;
                n7 ^= 0xFFFFFFFF;
                if (n4 == nArray.length) {
                    nArray = Arrays.copyOf(nArray, n4 * 2);
                }
                System.arraycopy(nArray, n7, nArray, n7 + 1, n4 - n7);
                nArray[n7] = n2;
                ++n4;
            }
        }
        nArray = XArrays.resize(nArray, n4);
        assert (XArrays.isSorted(nArray, true));
        return nArray;
    }

    public static int[] commonDivisors(int ... nArray) {
        int n;
        if (nArray.length == 0) {
            return XArrays.EMPTY_INT;
        }
        int n2 = Integer.MAX_VALUE;
        for (int i = 0; i < nArray.length; ++i) {
            n = Math.abs(nArray[i]);
            if (n > n2) continue;
            n2 = n;
        }
        int[] nArray2 = XMath.divisors(n2);
        n = nArray2.length;
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = Math.abs(nArray[i]);
            if (n3 == n2) continue;
            int n4 = n;
            while (--n4 > 0) {
                if (n3 % nArray2[n4] == 0) continue;
                System.arraycopy(nArray2, n4 + 1, nArray2, n4, --n - n4);
            }
        }
        return XArrays.resize(nArray2, n);
    }
}

