/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.math;

import org.geotoolkit.math.XMath;
import org.geotoolkit.util.Cloneable;

public final class Fraction
extends Number
implements Comparable<Fraction>,
Cloneable {
    private static final long serialVersionUID = -4501644254763471216L;
    private int numerator;
    private int denominator;

    public Fraction() {
    }

    public Fraction(Fraction fraction) {
        this.numerator = fraction.numerator;
        this.denominator = fraction.denominator;
    }

    public Fraction(int n) {
        this.numerator = n;
        this.denominator = 1;
    }

    public Fraction(int n, int n2) {
        this.numerator = n;
        this.denominator = n2;
        this.simplify();
    }

    public void set(int n, int n2) {
        this.numerator = n;
        this.denominator = n2;
        this.simplify();
    }

    public void add(Fraction fraction) {
        this.numerator = this.numerator * fraction.denominator + fraction.numerator * this.denominator;
        this.denominator *= fraction.denominator;
        this.simplify();
    }

    public void subtract(Fraction fraction) {
        this.numerator = this.numerator * fraction.denominator - fraction.numerator * this.denominator;
        this.denominator *= fraction.denominator;
        this.simplify();
    }

    public void multiply(Fraction fraction) {
        this.numerator *= fraction.numerator;
        this.denominator *= fraction.denominator;
        this.simplify();
    }

    public void divide(Fraction fraction) {
        this.numerator *= fraction.denominator;
        this.denominator *= fraction.numerator;
        this.simplify();
    }

    private void simplify() {
        if (this.numerator == 0) {
            this.denominator = XMath.sgn(this.denominator);
            return;
        }
        if (this.denominator == 0) {
            this.numerator = XMath.sgn(this.numerator);
            return;
        }
        if (this.denominator % this.numerator == 0) {
            this.denominator /= this.numerator;
            if (this.denominator < 0) {
                this.denominator = -this.denominator;
                this.numerator = -1;
            } else {
                this.numerator = 1;
            }
            return;
        }
        int n = Math.abs(this.numerator);
        int n2 = Math.abs(this.denominator);
        if ((n %= n2) == 0) {
            this.numerator /= this.denominator;
            this.denominator = 1;
            return;
        }
        int n3 = 1;
        int n4 = n;
        do {
            n = n2;
            n2 = n4;
            n3 = n4;
        } while ((n4 = n % n2) != 0);
        this.numerator /= n3;
        this.denominator /= n3;
        if (this.denominator < 0) {
            this.numerator = -this.numerator;
            this.denominator = -this.denominator;
        }
    }

    public int numerator() {
        return this.numerator;
    }

    public int denominator() {
        return this.denominator;
    }

    @Override
    public double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public long longValue() {
        return this.intValue();
    }

    @Override
    public int intValue() {
        return Fraction.round(this.numerator, this.denominator);
    }

    public static long round(long l, long l2) {
        long l3;
        long l4 = l / l2;
        long l5 = l % l2;
        if (l5 != 0L && ((l5 = Math.abs(l5 << 1)) > (l3 = Math.abs(l2)) || l5 == l3 && (l4 & 1L) != 0L)) {
            l4 = (l ^ l2) >= 0L ? ++l4 : --l4;
        }
        return l4;
    }

    public static int round(int n, int n2) {
        int n3;
        int n4 = n / n2;
        int n5 = n % n2;
        if (n5 != 0 && ((n5 = Math.abs(n5 << 1)) > (n3 = Math.abs(n2)) || n5 == n3 && (n4 & 1) != 0)) {
            n4 = (n ^ n2) >= 0 ? ++n4 : --n4;
        }
        return n4;
    }

    public static int floor(int n, int n2) {
        int n3 = n / n2;
        if ((n ^ n2) < 0 && n % n2 != 0) {
            --n3;
        }
        return n3;
    }

    public static int ceil(int n, int n2) {
        int n3 = n / n2;
        if ((n ^ n2) >= 0 && n % n2 != 0) {
            ++n3;
        }
        return n3;
    }

    @Override
    public int compareTo(Fraction fraction) {
        return this.numerator * fraction.denominator - fraction.numerator * this.denominator;
    }

    public boolean equals(Object object) {
        if (object instanceof Fraction) {
            Fraction fraction = (Fraction)object;
            return this.numerator == fraction.numerator && this.denominator == fraction.denominator;
        }
        return false;
    }

    public int hashCode() {
        return this.numerator + 31 * this.denominator ^ 0xA9A52E90;
    }

    @Override
    public Fraction clone() {
        try {
            return (Fraction)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public String toString() {
        return String.valueOf(this.numerator) + '/' + this.denominator;
    }
}

