/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.rmi;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ExecutionException;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.internal.rmi.ShareableTask;
import org.geotoolkit.internal.rmi.TaskFuture;

@ThreadSafe
final class RemoteFuture<Output>
extends UnicastRemoteObject
implements TaskFuture<Output> {
    private static final long serialVersionUID = 7868765562360450526L;
    private final ShareableTask<?, Output> task;
    private final List<TaskFuture<Output>> futures;
    private transient Output output;

    RemoteFuture(ShareableTask<?, Output> shareableTask, List<TaskFuture<Output>> list) throws RemoteException {
        this.task = shareableTask;
        this.futures = list;
    }

    @Override
    public synchronized Output get() throws RemoteException, ExecutionException, InterruptedException {
        if (this.output == null) {
            ArrayList<Output> arrayList = new ArrayList<Output>(this.futures.size());
            for (TaskFuture<Output> taskFuture : this.futures) {
                arrayList.add(taskFuture.get());
            }
            this.output = this.task.aggregate(arrayList);
        }
        return this.output;
    }

    @Override
    public synchronized void rollback() throws RemoteException {
        RemoteException remoteException = null;
        ListIterator<TaskFuture<Output>> listIterator = this.futures.listIterator(this.futures.size());
        while (listIterator.hasPrevious()) {
            TaskFuture<Output> taskFuture = listIterator.previous();
            listIterator.remove();
            try {
                taskFuture.rollback();
            }
            catch (RemoteException remoteException2) {
                if (remoteException != null) continue;
                remoteException = remoteException2;
            }
        }
        if (remoteException != null) {
            throw remoteException;
        }
    }
}

